/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.xsync;

import com.antkorwin.xsync.XMutex;
import com.antkorwin.xsync.XMutexFactory;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;

public class XMutexFactoryImpl<KeyT>
implements XMutexFactory<KeyT> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final ConcurrentReferenceHashMap.ReferenceType DEFAULT_REFERENCE_TYPE = ConcurrentReferenceHashMap.ReferenceType.WEAK;
    private final ConcurrentMap<KeyT, XMutex<KeyT>> map;

    public XMutexFactoryImpl() {
        this.map = new ConcurrentReferenceHashMap<KeyT, XMutex<KeyT>>(16, 0.75f, 16, DEFAULT_REFERENCE_TYPE, DEFAULT_REFERENCE_TYPE, null);
    }

    public XMutexFactoryImpl(int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType referenceType) {
        this.map = new ConcurrentReferenceHashMap<KeyT, XMutex<KeyT>>(16, 0.75f, concurrencyLevel, referenceType, referenceType, null);
    }

    @Override
    public XMutex<KeyT> getMutex(KeyT key) {
        return this.map.computeIfAbsent(key, XMutex::new);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    public void purgeUnreferenced() {
        ((ConcurrentReferenceHashMap)this.map).purgeStaleEntries();
    }
}

