/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.betterstrings.tokenizer;

import com.antkorwin.betterstrings.tokenizer.Token;
import com.antkorwin.betterstrings.tokenizer.TokenType;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    private final String HEAD = "${";
    private final String TAIL = "}";

    public List<Token> split(JCTree.JCLiteral jcLiteral) {
        int offset = jcLiteral.getPreferredPosition();
        List<Token> tokens = this.split((String)jcLiteral.getValue());
        for (Token t : tokens) {
            t.setOffset(offset);
        }
        return tokens;
    }

    public List<Token> split(String literalValue) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int startIndex = 0;
        while (startIndex < literalValue.length()) {
            String variable;
            int headIndex = literalValue.indexOf("${", startIndex);
            if (headIndex < 0) {
                tokens.add(new Token(literalValue.substring(startIndex), TokenType.STRING_LITERAL));
                break;
            }
            int endIndex = literalValue.indexOf("}", headIndex);
            if (endIndex < 0) {
                throw new RuntimeException("Not found ending bracket `}` of a variable declaration in string value: " + literalValue);
            }
            String prefix = literalValue.substring(startIndex, headIndex);
            if (!prefix.equals("")) {
                tokens.add(new Token(prefix, TokenType.STRING_LITERAL));
            }
            if (!(variable = literalValue.substring(headIndex + "${".length(), endIndex)).equals("")) {
                tokens.add(new Token(variable, TokenType.EXPRESSION));
            }
            startIndex = endIndex + "}".length();
        }
        return tokens;
    }
}

