/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.betterstrings.ast;

import com.antkorwin.betterstrings.DisabledStringInterpolation;
import com.antkorwin.betterstrings.ast.ExpressionParser;
import com.antkorwin.betterstrings.tokenizer.Token;
import com.antkorwin.betterstrings.tokenizer.Tokenizer;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import java.util.List;
import java.util.function.Supplier;

public class InnerStringVarsAstTranslator
extends TreeTranslator {
    private final TreeMaker treeMaker;
    private final Tokenizer tokenizer;
    private final ExpressionParser expressionParser;
    private boolean skip;

    public InnerStringVarsAstTranslator(Context context) {
        this.treeMaker = TreeMaker.instance(context);
        this.tokenizer = new Tokenizer();
        this.expressionParser = new ExpressionParser(Names.instance(context));
    }

    @Override
    public <T extends JCTree> T translate(T t) {
        return super.translate(t);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
        this.doWithSkipResolving(() -> this.skip || this.isAnnotatedBySkip(jcClassDecl.getModifiers()), () -> super.visitClassDef(jcClassDecl));
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jcAnnotation) {
        this.doWithSkipResolving(() -> true, () -> super.visitAnnotation(jcAnnotation));
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jcMethodDecl) {
        this.doWithSkipResolving(() -> this.skip || this.isAnnotatedBySkip(jcMethodDecl.getModifiers()), () -> super.visitMethodDef(jcMethodDecl));
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jcVariableDecl) {
        this.doWithSkipResolving(() -> this.skip || this.isAnnotatedBySkip(jcVariableDecl.getModifiers()), () -> super.visitVarDef(jcVariableDecl));
    }

    private boolean isAnnotatedBySkip(JCTree.JCModifiers modifiers) {
        for (JCTree.JCAnnotation annotation : modifiers.getAnnotations()) {
            if (annotation.getAnnotationType() == null || annotation.type == null || !annotation.type.toString().equals(DisabledStringInterpolation.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private void doWithSkipResolving(Supplier<Boolean> skipCondition, Runnable run) {
        boolean skipBefore = this.skip;
        this.skip = skipCondition.get();
        run.run();
        this.skip = skipBefore;
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jcLiteral) {
        super.visitLiteral(jcLiteral);
        if (this.skip) {
            return;
        }
        if (jcLiteral.getValue() instanceof String) {
            List<Token> tokens = this.tokenizer.split(jcLiteral);
            if (tokens.isEmpty()) {
                return;
            }
            if (tokens.size() == 1) {
                this.result = this.convertToExpression(tokens.get(0));
                return;
            }
            JCTree.JCExpression exprLeft = this.convertToExpression(tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                JCTree.JCExpression exprRight = this.convertToExpression(tokens.get(i));
                exprLeft = this.treeMaker.Binary(JCTree.Tag.PLUS, exprLeft, exprRight);
            }
            this.result = exprLeft;
        }
    }

    private JCTree.JCExpression convertToExpression(Token token) {
        switch (token.getType()) {
            case EXPRESSION: {
                return this.expressionParser.parse(token);
            }
            case STRING_LITERAL: {
                return this.treeMaker.Literal(token.getValue());
            }
        }
        throw new RuntimeException("Unexpected token type: " + (Object)((Object)token.getType()));
    }
}

