/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.betterstrings;

import com.antkorwin.betterstrings.ast.InnerStringVarsAstTranslator;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class BetterStringsProcessor
extends AbstractProcessor {
    private JavacProcessingEnvironment env;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.env = (JavacProcessingEnvironment)processingEnv;
        super.init(processingEnv);
        this.printBanner();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Context context = this.env.getContext();
        Trees trees = Trees.instance(this.env);
        for (Element element : roundEnv.getRootElements()) {
            if (!this.isClassOrEnum(element)) continue;
            JCTree tree = (JCTree)((Object)trees.getPath(element).getCompilationUnit());
            new InnerStringVarsAstTranslator(context).translate(tree);
        }
        return false;
    }

    private boolean isClassOrEnum(Element codeElement) {
        return codeElement.getKind() == ElementKind.CLASS || codeElement.getKind() == ElementKind.ENUM;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void printBanner() {
        String banner = "v0.3 String Interpolation Java Plugin, by Anatoliy Korovin";
        this.messager.printMessage(Diagnostic.Kind.NOTE, banner);
    }
}

