/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.function.IndexedIntPredicate;
import com.annimon.stream.iterator.PrimitiveIndexedIterator;
import com.annimon.stream.iterator.PrimitiveIterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class IntFilterIndexed
extends PrimitiveIterator.OfInt {
    private final PrimitiveIndexedIterator.OfInt iterator;
    private final IndexedIntPredicate predicate;
    private boolean hasNext;
    private boolean hasNextEvaluated;
    private int next;

    public IntFilterIndexed(@NotNull PrimitiveIndexedIterator.OfInt iterator, @NotNull IndexedIntPredicate predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNextEvaluated) {
            this.nextIteration();
            this.hasNextEvaluated = true;
        }
        return this.hasNext;
    }

    @Override
    public int nextInt() {
        if (!this.hasNextEvaluated) {
            this.hasNext = this.hasNext();
        }
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNextEvaluated = false;
        return this.next;
    }

    private void nextIteration() {
        while (this.iterator.hasNext()) {
            int index = this.iterator.getIndex();
            this.next = this.iterator.nextInt();
            if (!this.predicate.test(index, this.next)) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }
}

