/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.iterator.PrimitiveIterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class IntCodePoints
extends PrimitiveIterator.OfInt {
    private final CharSequence charSequence;
    private final boolean isString;
    private int current;
    private int length;

    public IntCodePoints(@NotNull CharSequence charSequence) {
        this.charSequence = charSequence;
        this.isString = charSequence instanceof String;
        this.current = 0;
        this.length = -1;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.ensureLength();
    }

    @Override
    public int nextInt() {
        char currentChar;
        char nextChar;
        int length = this.ensureLength();
        if (this.current >= length) {
            throw new NoSuchElementException();
        }
        if (Character.isHighSurrogate(nextChar = this.charSequence.charAt(this.current++)) && this.current < length && Character.isLowSurrogate(currentChar = this.charSequence.charAt(this.current))) {
            ++this.current;
            return Character.toCodePoint(nextChar, currentChar);
        }
        return nextChar;
    }

    private int ensureLength() {
        if (this.isString) {
            if (this.length == -1) {
                this.length = this.charSequence.length();
            }
            return this.length;
        }
        return this.charSequence.length();
    }
}

