/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableIntPredicate;
import org.jetbrains.annotations.NotNull;

public interface IntPredicate {
    public boolean test(int var1);

    public static class Util {
        private Util() {
        }

        public static IntPredicate and(final @NotNull IntPredicate p1, final @NotNull IntPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static IntPredicate or(final @NotNull IntPredicate p1, final @NotNull IntPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static IntPredicate xor(final @NotNull IntPredicate p1, final @NotNull IntPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static IntPredicate negate(final @NotNull IntPredicate p1) {
            Objects.requireNonNull(p1);
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return !p1.test(value);
                }
            };
        }

        public static IntPredicate safe(@NotNull ThrowableIntPredicate<Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static IntPredicate safe(final @NotNull ThrowableIntPredicate<Throwable> throwablePredicate, final boolean resultIfFailed) {
            Objects.requireNonNull(throwablePredicate);
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

