/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.IntConsumer;
import org.jetbrains.annotations.NotNull;

public interface IndexedIntConsumer {
    public void accept(int var1, int var2);

    public static class Util {
        private Util() {
        }

        public static IndexedIntConsumer andThen(final @NotNull IndexedIntConsumer c1, final @NotNull IndexedIntConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new IndexedIntConsumer(){

                @Override
                public void accept(int index, int value) {
                    c1.accept(index, value);
                    c2.accept(index, value);
                }
            };
        }

        public static IndexedIntConsumer accept(final IntConsumer c1, final IntConsumer c2) {
            return new IndexedIntConsumer(){

                @Override
                public void accept(int index, int value) {
                    if (c1 != null) {
                        c1.accept(index);
                    }
                    if (c2 != null) {
                        c2.accept(value);
                    }
                }
            };
        }
    }
}

