/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableDoublePredicate;
import org.jetbrains.annotations.NotNull;

public interface DoublePredicate {
    public boolean test(double var1);

    public static class Util {
        private Util() {
        }

        public static DoublePredicate and(final @NotNull DoublePredicate p1, final @NotNull DoublePredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static DoublePredicate or(final @NotNull DoublePredicate p1, final @NotNull DoublePredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static DoublePredicate xor(final @NotNull DoublePredicate p1, final @NotNull DoublePredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static DoublePredicate negate(final @NotNull DoublePredicate p1) {
            Objects.requireNonNull(p1);
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    return !p1.test(value);
                }
            };
        }

        public static DoublePredicate safe(@NotNull ThrowableDoublePredicate<Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static DoublePredicate safe(final @NotNull ThrowableDoublePredicate<Throwable> throwablePredicate, final boolean resultIfFailed) {
            Objects.requireNonNull(throwablePredicate);
            return new DoublePredicate(){

                @Override
                public boolean test(double value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

