/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BooleanConsumer;
import com.annimon.stream.function.BooleanFunction;
import com.annimon.stream.function.BooleanPredicate;
import com.annimon.stream.function.BooleanSupplier;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalBoolean {
    private static final OptionalBoolean EMPTY = new OptionalBoolean();
    private static final OptionalBoolean TRUE = new OptionalBoolean(true);
    private static final OptionalBoolean FALSE = new OptionalBoolean(false);
    private final boolean isPresent;
    private final boolean value;

    @NotNull
    public static OptionalBoolean empty() {
        return EMPTY;
    }

    @NotNull
    public static OptionalBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @NotNull
    public static OptionalBoolean ofNullable(@Nullable Boolean value) {
        return value == null ? EMPTY : OptionalBoolean.of(value);
    }

    private OptionalBoolean() {
        this.isPresent = false;
        this.value = false;
    }

    private OptionalBoolean(boolean value) {
        this.isPresent = true;
        this.value = value;
    }

    public boolean getAsBoolean() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(@NotNull BooleanConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(@NotNull BooleanConsumer consumer, @NotNull Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    public OptionalBoolean executeIfPresent(@NotNull BooleanConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    @NotNull
    public OptionalBoolean executeIfAbsent(@NotNull Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    @Nullable
    public <R> R custom(@NotNull Function<OptionalBoolean, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public OptionalBoolean filter(@NotNull BooleanPredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalBoolean.empty();
    }

    @NotNull
    public OptionalBoolean filterNot(@NotNull BooleanPredicate predicate) {
        return this.filter(BooleanPredicate.Util.negate(predicate));
    }

    @NotNull
    public OptionalBoolean map(@NotNull BooleanPredicate mapper) {
        if (!this.isPresent()) {
            return OptionalBoolean.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalBoolean.of(mapper.test(this.value));
    }

    @NotNull
    public <U> Optional<U> mapToObj(@NotNull BooleanFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(mapper.apply(this.value));
    }

    @NotNull
    public OptionalBoolean or(@NotNull Supplier<OptionalBoolean> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public boolean orElse(boolean other) {
        return this.isPresent ? this.value : other;
    }

    public boolean orElseGet(@NotNull BooleanSupplier other) {
        return this.isPresent ? this.value : other.getAsBoolean();
    }

    public boolean orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> boolean orElseThrow(@NotNull Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalBoolean)) {
            return false;
        }
        OptionalBoolean other = (OptionalBoolean)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? (this.value ? 1231 : 1237) : 0;
    }

    @NotNull
    public String toString() {
        return this.isPresent ? (this.value ? "OptionalBoolean[true]" : "OptionalBoolean[false]") : "OptionalBoolean.empty";
    }
}

