/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IndexedIntConsumer;
import com.annimon.stream.function.IndexedIntPredicate;
import com.annimon.stream.function.IntBinaryOperator;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.IntPredicate;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.IntToDoubleFunction;
import com.annimon.stream.function.IntToLongFunction;
import com.annimon.stream.function.IntUnaryOperator;
import com.annimon.stream.function.ObjIntConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.internal.Compose;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.internal.Params;
import com.annimon.stream.internal.SpinedBuffer;
import com.annimon.stream.iterator.PrimitiveIndexedIterator;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.IntArray;
import com.annimon.stream.operator.IntCodePoints;
import com.annimon.stream.operator.IntConcat;
import com.annimon.stream.operator.IntDropWhile;
import com.annimon.stream.operator.IntFilter;
import com.annimon.stream.operator.IntFilterIndexed;
import com.annimon.stream.operator.IntFlatMap;
import com.annimon.stream.operator.IntGenerate;
import com.annimon.stream.operator.IntIterate;
import com.annimon.stream.operator.IntLimit;
import com.annimon.stream.operator.IntMap;
import com.annimon.stream.operator.IntMapIndexed;
import com.annimon.stream.operator.IntMapToDouble;
import com.annimon.stream.operator.IntMapToLong;
import com.annimon.stream.operator.IntMapToObj;
import com.annimon.stream.operator.IntPeek;
import com.annimon.stream.operator.IntRangeClosed;
import com.annimon.stream.operator.IntSample;
import com.annimon.stream.operator.IntScan;
import com.annimon.stream.operator.IntScanIdentity;
import com.annimon.stream.operator.IntSkip;
import com.annimon.stream.operator.IntSorted;
import com.annimon.stream.operator.IntTakeUntil;
import com.annimon.stream.operator.IntTakeWhile;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntStream
implements Closeable {
    private static final IntStream EMPTY = new IntStream(new PrimitiveIterator.OfInt(){

        @Override
        public int nextInt() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    });
    private final PrimitiveIterator.OfInt iterator;
    private final Params params;
    private static final ToIntFunction<Integer> UNBOX_FUNCTION = new ToIntFunction<Integer>(){

        @Override
        public int applyAsInt(Integer t) {
            return t;
        }
    };

    @NotNull
    public static IntStream empty() {
        return EMPTY;
    }

    @NotNull
    public static IntStream of(@NotNull PrimitiveIterator.OfInt iterator) {
        Objects.requireNonNull(iterator);
        return new IntStream(iterator);
    }

    @NotNull
    public static IntStream of(int ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return IntStream.empty();
        }
        return new IntStream(new IntArray(values));
    }

    @NotNull
    public static IntStream of(int t) {
        return new IntStream(new IntArray(new int[]{t}));
    }

    @NotNull
    public static IntStream ofCodePoints(@NotNull CharSequence charSequence) {
        return new IntStream(new IntCodePoints(charSequence));
    }

    @NotNull
    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStream.empty();
        }
        return IntStream.rangeClosed(startInclusive, endExclusive - 1);
    }

    @NotNull
    public static IntStream rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStream.empty();
        }
        if (startInclusive == endInclusive) {
            return IntStream.of(startInclusive);
        }
        return new IntStream(new IntRangeClosed(startInclusive, endInclusive));
    }

    @NotNull
    public static IntStream generate(@NotNull IntSupplier s) {
        Objects.requireNonNull(s);
        return new IntStream(new IntGenerate(s));
    }

    @NotNull
    public static IntStream iterate(int seed, @NotNull IntUnaryOperator f) {
        Objects.requireNonNull(f);
        return new IntStream(new IntIterate(seed, f));
    }

    @NotNull
    public static IntStream iterate(int seed, @NotNull IntPredicate predicate, @NotNull IntUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return IntStream.iterate(seed, op).takeWhile(predicate);
    }

    @NotNull
    public static IntStream concat(@NotNull IntStream a, @NotNull IntStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        IntStream result = new IntStream(new IntConcat(a.iterator, b.iterator));
        return result.onClose(Compose.closeables(a, b));
    }

    @NotNull
    public static IntStream concat(@NotNull IntStream a, @NotNull IntStream b, IntStream ... rest) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Objects.requireNonNull(rest);
        ArrayList<PrimitiveIterator.OfInt> iterators = new ArrayList<PrimitiveIterator.OfInt>(rest.length + 2);
        ArrayList<IntStream> closeables = new ArrayList<IntStream>(rest.length + 2);
        Collections.addAll(iterators, a.iterator, b.iterator);
        Collections.addAll(closeables, a, b);
        for (IntStream stream : rest) {
            iterators.add(stream.iterator);
            closeables.add(stream);
        }
        IntStream result = new IntStream(new IntConcat(iterators));
        return result.onClose(Compose.closeables(closeables));
    }

    private IntStream(PrimitiveIterator.OfInt iterator) {
        this(null, iterator);
    }

    IntStream(Params params, PrimitiveIterator.OfInt iterator) {
        this.params = params;
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfInt iterator() {
        return this.iterator;
    }

    @Nullable
    public <R> R custom(@NotNull Function<IntStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public Stream<Integer> boxed() {
        return new Stream<Integer>(this.params, this.iterator);
    }

    @NotNull
    public IntStream prepend(@NotNull IntStream stream) {
        return IntStream.concat(stream, this);
    }

    @NotNull
    public IntStream append(@NotNull IntStream stream) {
        return IntStream.concat(this, stream);
    }

    @NotNull
    public IntStream filter(@NotNull IntPredicate predicate) {
        return new IntStream(this.params, new IntFilter(this.iterator, predicate));
    }

    @NotNull
    public IntStream filterIndexed(@NotNull IndexedIntPredicate predicate) {
        return this.filterIndexed(0, 1, predicate);
    }

    @NotNull
    public IntStream filterIndexed(int from, int step, @NotNull IndexedIntPredicate predicate) {
        return new IntStream(this.params, new IntFilterIndexed(new PrimitiveIndexedIterator.OfInt(from, step, this.iterator), predicate));
    }

    @NotNull
    public IntStream filterNot(@NotNull IntPredicate predicate) {
        return this.filter(IntPredicate.Util.negate(predicate));
    }

    @NotNull
    public IntStream map(@NotNull IntUnaryOperator mapper) {
        return new IntStream(this.params, new IntMap(this.iterator, mapper));
    }

    @NotNull
    public IntStream mapIndexed(@NotNull IntBinaryOperator mapper) {
        return this.mapIndexed(0, 1, mapper);
    }

    @NotNull
    public IntStream mapIndexed(int from, int step, @NotNull IntBinaryOperator mapper) {
        return new IntStream(this.params, new IntMapIndexed(new PrimitiveIndexedIterator.OfInt(from, step, this.iterator), mapper));
    }

    @NotNull
    public <R> Stream<R> mapToObj(@NotNull IntFunction<? extends R> mapper) {
        return new Stream<R>(this.params, new IntMapToObj<R>(this.iterator, mapper));
    }

    @NotNull
    public LongStream mapToLong(@NotNull IntToLongFunction mapper) {
        return new LongStream(this.params, new IntMapToLong(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream mapToDouble(@NotNull IntToDoubleFunction mapper) {
        return new DoubleStream(this.params, new IntMapToDouble(this.iterator, mapper));
    }

    @NotNull
    public IntStream flatMap(@NotNull IntFunction<? extends IntStream> mapper) {
        return new IntStream(this.params, new IntFlatMap(this.iterator, mapper));
    }

    @NotNull
    public IntStream mapMulti(final @NotNull IntMapMultiConsumer mapper) {
        return this.flatMap((IntFunction<? extends IntStream>)new IntFunction<IntStream>(){

            @Override
            public IntStream apply(int value) {
                SpinedBuffer.OfInt buffer = new SpinedBuffer.OfInt();
                mapper.accept(value, buffer);
                return IntStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public IntStream distinct() {
        return this.boxed().distinct().mapToInt(UNBOX_FUNCTION);
    }

    @NotNull
    public IntStream sorted() {
        return new IntStream(this.params, new IntSorted(this.iterator));
    }

    @NotNull
    public IntStream sorted(@Nullable Comparator<Integer> comparator) {
        return this.boxed().sorted(comparator).mapToInt(UNBOX_FUNCTION);
    }

    @NotNull
    public IntStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new IntStream(this.params, new IntSample(this.iterator, stepWidth));
    }

    @NotNull
    public IntStream peek(@NotNull IntConsumer action) {
        return new IntStream(this.params, new IntPeek(this.iterator, action));
    }

    @NotNull
    public IntStream scan(@NotNull IntBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new IntStream(this.params, new IntScan(this.iterator, accumulator));
    }

    @NotNull
    public IntStream scan(int identity, @NotNull IntBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new IntStream(this.params, new IntScanIdentity(this.iterator, identity, accumulator));
    }

    @NotNull
    public IntStream takeWhile(@NotNull IntPredicate predicate) {
        return new IntStream(this.params, new IntTakeWhile(this.iterator, predicate));
    }

    @NotNull
    public IntStream takeUntil(@NotNull IntPredicate stopPredicate) {
        return new IntStream(this.params, new IntTakeUntil(this.iterator, stopPredicate));
    }

    @NotNull
    public IntStream dropWhile(@NotNull IntPredicate predicate) {
        return new IntStream(this.params, new IntDropWhile(this.iterator, predicate));
    }

    @NotNull
    public IntStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return IntStream.empty();
        }
        return new IntStream(this.params, new IntLimit(this.iterator, maxSize));
    }

    @NotNull
    public IntStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new IntStream(this.params, new IntSkip(this.iterator, n));
    }

    public void forEach(@NotNull IntConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextInt());
        }
    }

    public void forEachIndexed(@NotNull IndexedIntConsumer action) {
        this.forEachIndexed(0, 1, action);
    }

    public void forEachIndexed(int from, int step, @NotNull IndexedIntConsumer action) {
        int index = from;
        while (this.iterator.hasNext()) {
            action.accept(index, this.iterator.nextInt());
            index += step;
        }
    }

    public int reduce(int identity, @NotNull IntBinaryOperator op) {
        int result = identity;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            result = op.applyAsInt(result, value);
        }
        return result;
    }

    @NotNull
    public OptionalInt reduce(@NotNull IntBinaryOperator op) {
        boolean foundAny = false;
        int result = 0;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = op.applyAsInt(result, value);
        }
        return foundAny ? OptionalInt.of(result) : OptionalInt.empty();
    }

    @NotNull
    public int[] toArray() {
        return Operators.toIntArray(this.iterator);
    }

    @Nullable
    public <R> R collect(@NotNull Supplier<R> supplier, @NotNull ObjIntConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            accumulator.accept(result, value);
        }
        return result;
    }

    public int sum() {
        int sum = 0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextInt();
        }
        return sum;
    }

    @NotNull
    public OptionalInt min() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left < right ? left : right;
            }
        });
    }

    @NotNull
    public OptionalInt max() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left > right ? left : right;
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextInt();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(@NotNull IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(@NotNull IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(@NotNull IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public OptionalInt findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalInt.of(this.iterator.nextInt());
        }
        return OptionalInt.empty();
    }

    public int findFirstOrElse(int other) {
        if (this.iterator.hasNext()) {
            return this.iterator.nextInt();
        }
        return other;
    }

    @NotNull
    public OptionalInt findLast() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return right;
            }
        });
    }

    public int single() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.nextInt();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("IntStream contains no element");
    }

    @NotNull
    public OptionalInt findSingle() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.nextInt();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return OptionalInt.of(singleCandidate);
        }
        return OptionalInt.empty();
    }

    @NotNull
    public IntStream onClose(@NotNull Runnable closeHandler) {
        Objects.requireNonNull(closeHandler);
        Params newParams = Params.wrapWithCloseHandler(this.params, closeHandler);
        return new IntStream(newParams, this.iterator);
    }

    @Override
    public void close() {
        if (this.params != null && this.params.closeHandler != null) {
            this.params.closeHandler.run();
            this.params.closeHandler = null;
        }
    }

    public static interface IntMapMultiConsumer {
        public void accept(int var1, IntConsumer var2);
    }
}

