/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.function.IndexedDoublePredicate;
import com.annimon.stream.iterator.PrimitiveIndexedIterator;
import com.annimon.stream.iterator.PrimitiveIterator;
import java.util.NoSuchElementException;

public class DoubleFilterIndexed
extends PrimitiveIterator.OfDouble {
    private final PrimitiveIndexedIterator.OfDouble iterator;
    private final IndexedDoublePredicate predicate;
    private boolean hasNext;
    private boolean hasNextEvaluated;
    private double next;

    public DoubleFilterIndexed(PrimitiveIndexedIterator.OfDouble iterator, IndexedDoublePredicate predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNextEvaluated) {
            this.nextIteration();
            this.hasNextEvaluated = true;
        }
        return this.hasNext;
    }

    @Override
    public double nextDouble() {
        if (!this.hasNextEvaluated) {
            this.hasNext = this.hasNext();
        }
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNextEvaluated = false;
        return this.next;
    }

    private void nextIteration() {
        while (this.iterator.hasNext()) {
            int index = this.iterator.getIndex();
            this.next = this.iterator.next();
            if (!this.predicate.test(index, this.next)) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }
}

