/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;
import com.annimon.stream.function.ThrowableDoubleConsumer;

@FunctionalInterface
public interface DoubleConsumer {
    public void accept(double var1);

    public static class Util {
        private Util() {
        }

        public static DoubleConsumer andThen(final DoubleConsumer c1, final DoubleConsumer c2) {
            return new DoubleConsumer(){

                @Override
                public void accept(double value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static DoubleConsumer safe(ThrowableDoubleConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static DoubleConsumer safe(final ThrowableDoubleConsumer<Throwable> throwableConsumer, final DoubleConsumer onFailedConsumer) {
            return new DoubleConsumer(){

                @Override
                public void accept(double value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

