/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Collectors;
import com.annimon.stream.ComparatorCompat;
import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntPair;
import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IndexedBiFunction;
import com.annimon.stream.function.IndexedConsumer;
import com.annimon.stream.function.IndexedFunction;
import com.annimon.stream.function.IndexedPredicate;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.function.UnaryOperator;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.iterator.IndexedIterator;
import com.annimon.stream.iterator.LazyIterator;
import com.annimon.stream.operator.ObjArray;
import com.annimon.stream.operator.ObjChunkBy;
import com.annimon.stream.operator.ObjConcat;
import com.annimon.stream.operator.ObjDistinct;
import com.annimon.stream.operator.ObjDropWhile;
import com.annimon.stream.operator.ObjDropWhileIndexed;
import com.annimon.stream.operator.ObjFilter;
import com.annimon.stream.operator.ObjFilterIndexed;
import com.annimon.stream.operator.ObjFlatMap;
import com.annimon.stream.operator.ObjFlatMapToDouble;
import com.annimon.stream.operator.ObjFlatMapToInt;
import com.annimon.stream.operator.ObjFlatMapToLong;
import com.annimon.stream.operator.ObjGenerate;
import com.annimon.stream.operator.ObjIterate;
import com.annimon.stream.operator.ObjLimit;
import com.annimon.stream.operator.ObjMap;
import com.annimon.stream.operator.ObjMapIndexed;
import com.annimon.stream.operator.ObjMapToDouble;
import com.annimon.stream.operator.ObjMapToInt;
import com.annimon.stream.operator.ObjMapToLong;
import com.annimon.stream.operator.ObjPeek;
import com.annimon.stream.operator.ObjScan;
import com.annimon.stream.operator.ObjScanIdentity;
import com.annimon.stream.operator.ObjSkip;
import com.annimon.stream.operator.ObjSlidingWindow;
import com.annimon.stream.operator.ObjSorted;
import com.annimon.stream.operator.ObjTakeUntil;
import com.annimon.stream.operator.ObjTakeUntilIndexed;
import com.annimon.stream.operator.ObjTakeWhile;
import com.annimon.stream.operator.ObjTakeWhileIndexed;
import com.annimon.stream.operator.ObjZip;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class Stream<T> {
    private final Iterator<? extends T> iterator;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private static final int MATCH_NONE = 2;

    public static <T> Stream<T> empty() {
        return Stream.of(Collections.emptyList());
    }

    public static <K, V> Stream<Map.Entry<K, V>> of(Map<K, V> map) {
        Objects.requireNonNull(map);
        return new Stream<Map.Entry<K, V>>(map.entrySet());
    }

    public static <T> Stream<T> of(Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        return new Stream<T>(iterator);
    }

    public static <T> Stream<T> of(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        return new Stream<T>(iterable);
    }

    public static <T> Stream<T> of(T ... elements) {
        Objects.requireNonNull(elements);
        if (elements.length == 0) {
            return Stream.empty();
        }
        return new Stream<T>(new ObjArray<T>(elements));
    }

    public static <T> Stream<T> ofNullable(T element) {
        return element == null ? Stream.empty() : Stream.of(element);
    }

    public static <T> Stream<T> ofNullable(Iterable<? extends T> iterable) {
        return iterable == null ? Stream.empty() : Stream.of(iterable);
    }

    public static Stream<Integer> range(int from, int to) {
        return IntStream.range(from, to).boxed();
    }

    public static Stream<Long> range(long from, long to) {
        return LongStream.range(from, to).boxed();
    }

    public static Stream<Integer> rangeClosed(int from, int to) {
        return IntStream.rangeClosed(from, to).boxed();
    }

    public static Stream<Long> rangeClosed(long from, long to) {
        return LongStream.rangeClosed(from, to).boxed();
    }

    public static <T> Stream<T> generate(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new Stream<T>(new ObjGenerate<T>(supplier));
    }

    public static <T> Stream<T> iterate(T seed, UnaryOperator<T> op) {
        Objects.requireNonNull(op);
        return new Stream<T>(new ObjIterate<T>(seed, op));
    }

    public static <T> Stream<T> iterate(T seed, Predicate<? super T> predicate, UnaryOperator<T> op) {
        Objects.requireNonNull(predicate);
        return Stream.iterate(seed, op).takeWhile(predicate);
    }

    public static <T> Stream<T> concat(Stream<? extends T> stream1, Stream<? extends T> stream2) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        return new Stream<T>(new ObjConcat<T>(stream1.iterator, stream2.iterator));
    }

    public static <F, S, R> Stream<R> zip(Stream<? extends F> stream1, Stream<? extends S> stream2, BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(stream1);
        Objects.requireNonNull(stream2);
        return Stream.zip(stream1.iterator, stream2.iterator, combiner);
    }

    public static <F, S, R> Stream<R> zip(Iterator<? extends F> iterator1, Iterator<? extends S> iterator2, BiFunction<? super F, ? super S, ? extends R> combiner) {
        Objects.requireNonNull(iterator1);
        Objects.requireNonNull(iterator2);
        return new Stream(new ObjZip<F, S, R>(iterator1, iterator2, combiner));
    }

    private Stream(Iterator<? extends T> iterator) {
        this.iterator = iterator;
    }

    private Stream(Iterable<? extends T> iterable) {
        this(new LazyIterator<T>(iterable));
    }

    @Deprecated
    public Iterator<? extends T> getIterator() {
        return this.iterator;
    }

    public Iterator<? extends T> iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<Stream<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<T> filter(Predicate<? super T> predicate) {
        return new Stream<T>(new ObjFilter<T>(this.iterator, predicate));
    }

    public Stream<T> filterIndexed(IndexedPredicate<? super T> predicate) {
        return this.filterIndexed(0, 1, predicate);
    }

    public Stream<T> filterIndexed(int from, int step, IndexedPredicate<? super T> predicate) {
        return new Stream<T>(new ObjFilterIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    public Stream<T> filterNot(Predicate<? super T> predicate) {
        return this.filter(Predicate.Util.negate(predicate));
    }

    public <TT> Stream<TT> select(final Class<TT> clazz) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return clazz.isInstance(value);
            }
        });
    }

    public Stream<T> withoutNulls() {
        return this.filter(Predicate.Util.notNull());
    }

    public Stream<T> nullsOnly() {
        return this.filterNot(Predicate.Util.notNull());
    }

    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return new Stream<T>(new ObjMap<T, R>(this.iterator, mapper));
    }

    public <R> Stream<R> mapIndexed(IndexedFunction<? super T, ? extends R> mapper) {
        return this.mapIndexed(0, 1, mapper);
    }

    public <R> Stream<R> mapIndexed(int from, int step, IndexedFunction<? super T, ? extends R> mapper) {
        return new Stream<T>(new ObjMapIndexed<T, R>(new IndexedIterator<T>(from, step, this.iterator), mapper));
    }

    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return IntStream.of(new ObjMapToInt<T>(this.iterator, mapper));
    }

    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return LongStream.of(new ObjMapToLong<T>(this.iterator, mapper));
    }

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return DoubleStream.of(new ObjMapToDouble<T>(this.iterator, mapper));
    }

    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Stream<T>(new ObjFlatMap(this.iterator, mapper));
    }

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return IntStream.of(new ObjFlatMapToInt<T>(this.iterator, mapper));
    }

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return LongStream.of(new ObjFlatMapToLong<T>(this.iterator, mapper));
    }

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return DoubleStream.of(new ObjFlatMapToDouble<T>(this.iterator, mapper));
    }

    public Stream<IntPair<T>> indexed() {
        return this.indexed(0, 1);
    }

    public Stream<IntPair<T>> indexed(int from, int step) {
        return this.mapIndexed(from, step, new IndexedFunction<T, IntPair<T>>(){

            @Override
            public IntPair<T> apply(int index, T t) {
                return new IntPair(index, t);
            }
        });
    }

    public Stream<T> distinct() {
        return new Stream<T>(new ObjDistinct<T>(this.iterator));
    }

    public Stream<T> sorted() {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        });
    }

    public Stream<T> sorted(Comparator<? super T> comparator) {
        return new Stream<T>(new ObjSorted<T>(this.iterator, comparator));
    }

    public <R extends Comparable<? super R>> Stream<T> sortBy(Function<? super T, ? extends R> f) {
        return this.sorted(ComparatorCompat.comparing(f));
    }

    public <K> Stream<Map.Entry<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return Stream.of(this.collect(Collectors.groupingBy(classifier)));
    }

    public <K> Stream<List<T>> chunkBy(Function<? super T, ? extends K> classifier) {
        return new Stream<List<T>>(new ObjChunkBy<T, K>(this.iterator, classifier));
    }

    public Stream<T> sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return this.slidingWindow(1, stepWidth).map(new Function<List<T>, T>(){

            @Override
            public T apply(List<T> list) {
                return list.get(0);
            }
        });
    }

    public Stream<List<T>> slidingWindow(int windowSize) {
        return this.slidingWindow(windowSize, 1);
    }

    public Stream<List<T>> slidingWindow(int windowSize, int stepWidth) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("windowSize cannot be zero or negative");
        }
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        return new Stream<T>(new ObjSlidingWindow<T>(this.iterator, windowSize, stepWidth));
    }

    public Stream<T> peek(Consumer<? super T> action) {
        return new Stream<T>(new ObjPeek<T>(this.iterator, action));
    }

    public Stream<T> scan(BiFunction<T, T, T> accumulator) {
        Objects.requireNonNull(accumulator);
        return new Stream<T>(new ObjScan<T>(this.iterator, accumulator));
    }

    public <R> Stream<R> scan(R identity, BiFunction<? super R, ? super T, ? extends R> accumulator) {
        Objects.requireNonNull(accumulator);
        return new Stream<T>(new ObjScanIdentity<T, R>(this.iterator, identity, accumulator));
    }

    public Stream<T> takeWhile(Predicate<? super T> predicate) {
        return new Stream<T>(new ObjTakeWhile<T>(this.iterator, predicate));
    }

    public Stream<T> takeWhileIndexed(IndexedPredicate<? super T> predicate) {
        return this.takeWhileIndexed(0, 1, predicate);
    }

    public Stream<T> takeWhileIndexed(int from, int step, IndexedPredicate<? super T> predicate) {
        return new Stream<T>(new ObjTakeWhileIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    public Stream<T> takeUntil(Predicate<? super T> stopPredicate) {
        return new Stream<T>(new ObjTakeUntil<T>(this.iterator, stopPredicate));
    }

    public Stream<T> takeUntilIndexed(IndexedPredicate<? super T> stopPredicate) {
        return this.takeUntilIndexed(0, 1, stopPredicate);
    }

    public Stream<T> takeUntilIndexed(int from, int step, IndexedPredicate<? super T> stopPredicate) {
        return new Stream<T>(new ObjTakeUntilIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), stopPredicate));
    }

    public Stream<T> dropWhile(Predicate<? super T> predicate) {
        return new Stream<T>(new ObjDropWhile<T>(this.iterator, predicate));
    }

    public Stream<T> dropWhileIndexed(IndexedPredicate<? super T> predicate) {
        return this.dropWhileIndexed(0, 1, predicate);
    }

    public Stream<T> dropWhileIndexed(int from, int step, IndexedPredicate<? super T> predicate) {
        return new Stream<T>(new ObjDropWhileIndexed<T>(new IndexedIterator<T>(from, step, this.iterator), predicate));
    }

    public Stream<T> limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return Stream.empty();
        }
        return new Stream<T>(new ObjLimit<T>(this.iterator, maxSize));
    }

    public Stream<T> skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new Stream<T>(new ObjSkip<T>(this.iterator, n));
    }

    public void forEach(Consumer<? super T> action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    public void forEachIndexed(IndexedConsumer<? super T> action) {
        this.forEachIndexed(0, 1, action);
    }

    public void forEachIndexed(int from, int step, IndexedConsumer<? super T> action) {
        int index = from;
        while (this.iterator.hasNext()) {
            action.accept(index, this.iterator.next());
            index += step;
        }
    }

    public <R> R reduce(R identity, BiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(result, value);
        }
        return result;
    }

    public <R> R reduceIndexed(R identity, IndexedBiFunction<? super R, ? super T, ? extends R> accumulator) {
        return this.reduceIndexed(0, 1, identity, accumulator);
    }

    public <R> R reduceIndexed(int from, int step, R identity, IndexedBiFunction<? super R, ? super T, ? extends R> accumulator) {
        R result = identity;
        int index = from;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(index, result, value);
            index += step;
        }
        return result;
    }

    public Optional<T> reduce(BiFunction<T, T, T> accumulator) {
        boolean foundAny = false;
        Object result = null;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.apply(result, value);
        }
        return foundAny ? Optional.of(result) : Optional.empty();
    }

    public Object[] toArray() {
        return this.toArray((IntFunction<R[]>)new IntFunction<Object[]>(){

            @Override
            public Object[] apply(int value) {
                return new Object[value];
            }
        });
    }

    public <R> R[] toArray(IntFunction<R[]> generator) {
        return Operators.toArray(this.iterator, generator);
    }

    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        while (this.iterator.hasNext()) {
            result.add(this.iterator.next());
        }
        return result;
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            accumulator.accept(result, value);
        }
        return result;
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            collector.accumulator().accept(container, value);
        }
        if (collector.finisher() != null) {
            return collector.finisher().apply(container);
        }
        return Collectors.castIdentity().apply(container);
    }

    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.minBy(comparator));
    }

    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.maxBy(comparator));
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 0);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 1);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 2);
    }

    public Optional<T> findFirst() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }

    public T single() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("Stream contains no element");
    }

    public Optional<T> findSingle() {
        if (this.iterator.hasNext()) {
            T singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("Stream contains more than one element");
            }
            return Optional.of(singleCandidate);
        }
        return Optional.empty();
    }

    private boolean match(Predicate<? super T> predicate, int matchKind) {
        boolean kindAll;
        boolean kindAny = matchKind == 0;
        boolean bl = kindAll = matchKind == 1;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            boolean match = predicate.test(value);
            if (!(match ^ kindAll)) continue;
            return kindAny && match;
        }
        return !kindAny;
    }
}

