/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;

@FunctionalInterface
public interface LongPredicate {
    public boolean test(long var1);

    public static class Util {
        private Util() {
        }

        public static LongPredicate and(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static LongPredicate or(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static LongPredicate xor(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static LongPredicate negate(final LongPredicate p1) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return !p1.test(value);
                }
            };
        }
    }
}

