/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.PrimitiveExtIterator;
import com.annimon.stream.PrimitiveIterator;
import com.annimon.stream.SpinedBuffer;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IntBinaryOperator;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.IntPredicate;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.IntToDoubleFunction;
import com.annimon.stream.function.IntToLongFunction;
import com.annimon.stream.function.IntUnaryOperator;
import com.annimon.stream.function.ObjIntConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToIntFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class IntStream {
    private static final IntStream EMPTY = new IntStream(new PrimitiveIterator.OfInt(){

        @Override
        public int nextInt() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    });
    private final PrimitiveIterator.OfInt iterator;
    private static final ToIntFunction<Integer> UNBOX_FUNCTION = new ToIntFunction<Integer>(){

        @Override
        public int applyAsInt(Integer t) {
            return t;
        }
    };

    public static IntStream empty() {
        return EMPTY;
    }

    public static IntStream of(PrimitiveIterator.OfInt iterator) {
        Objects.requireNonNull(iterator);
        return new IntStream(iterator);
    }

    public static IntStream of(final int ... values) {
        Objects.requireNonNull(values);
        return new IntStream(new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public int nextInt() {
                return values[this.index++];
            }

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }
        });
    }

    public static IntStream of(final int t) {
        return new IntStream(new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public int nextInt() {
                ++this.index;
                return t;
            }

            @Override
            public boolean hasNext() {
                return this.index == 0;
            }
        });
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStream.empty();
        }
        return IntStream.rangeClosed(startInclusive, endExclusive - 1);
    }

    public static IntStream rangeClosed(final int startInclusive, final int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStream.empty();
        }
        if (startInclusive == endInclusive) {
            return IntStream.of(startInclusive);
        }
        return new IntStream(new PrimitiveIterator.OfInt(){
            private int current;
            private boolean hasNext;
            {
                this.current = startInclusive;
                this.hasNext = this.current <= endInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int nextInt() {
                if (this.current >= endInclusive) {
                    this.hasNext = false;
                    return endInclusive;
                }
                return this.current++;
            }
        });
    }

    public static IntStream generate(final IntSupplier s) {
        Objects.requireNonNull(s);
        return new IntStream(new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return s.getAsInt();
            }

            @Override
            public boolean hasNext() {
                return true;
            }
        });
    }

    public static IntStream iterate(final int seed, final IntUnaryOperator f) {
        Objects.requireNonNull(f);
        return new IntStream(new PrimitiveIterator.OfInt(){
            private int current;
            {
                this.current = seed;
            }

            @Override
            public int nextInt() {
                int old = this.current;
                this.current = f.applyAsInt(this.current);
                return old;
            }

            @Override
            public boolean hasNext() {
                return true;
            }
        });
    }

    public static IntStream concat(final IntStream a, final IntStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return new IntStream(new PrimitiveIterator.OfInt(){
            private boolean firstStreamIsCurrent = true;

            @Override
            public int nextInt() {
                return this.firstStreamIsCurrent ? a.iterator.nextInt() : b.iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                if (this.firstStreamIsCurrent) {
                    if (a.iterator.hasNext()) {
                        return true;
                    }
                    this.firstStreamIsCurrent = false;
                }
                return b.iterator.hasNext();
            }
        });
    }

    private IntStream(PrimitiveIterator.OfInt iterator) {
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfInt iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<IntStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Integer> boxed() {
        return Stream.of(this.iterator);
    }

    public IntStream filter(final IntPredicate predicate) {
        return new IntStream(new PrimitiveIterator.OfInt(){
            private int next;

            @Override
            public int nextInt() {
                return this.next;
            }

            @Override
            public boolean hasNext() {
                while (IntStream.this.iterator.hasNext()) {
                    this.next = IntStream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public IntStream filterNot(IntPredicate predicate) {
        return this.filter(IntPredicate.Util.negate(predicate));
    }

    public IntStream map(final IntUnaryOperator mapper) {
        return new IntStream(new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return mapper.applyAsInt(IntStream.this.iterator.nextInt());
            }

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }
        });
    }

    public <R> Stream<R> mapToObj(final IntFunction<? extends R> mapper) {
        return Stream.of(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }

            @Override
            public R nextIteration() {
                return mapper.apply(IntStream.this.iterator.nextInt());
            }
        });
    }

    public LongStream mapToLong(final IntToLongFunction mapper) {
        return LongStream.of(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return mapper.applyAsLong(IntStream.this.iterator.nextInt());
            }
        });
    }

    public DoubleStream mapToDouble(final IntToDoubleFunction mapper) {
        return DoubleStream.of(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return mapper.applyAsDouble(IntStream.this.iterator.nextInt());
            }
        });
    }

    public IntStream flatMap(final IntFunction<? extends IntStream> mapper) {
        return new IntStream(new PrimitiveIterator.OfInt(){
            private PrimitiveIterator.OfInt inner;

            @Override
            public int nextInt() {
                return this.inner.nextInt();
            }

            @Override
            public boolean hasNext() {
                if (this.inner != null && this.inner.hasNext()) {
                    return true;
                }
                while (IntStream.this.iterator.hasNext()) {
                    int arg = IntStream.this.iterator.next();
                    IntStream result = (IntStream)mapper.apply(arg);
                    if (result == null || !result.iterator.hasNext()) continue;
                    this.inner = result.iterator;
                    return true;
                }
                return false;
            }
        });
    }

    public IntStream distinct() {
        return this.boxed().distinct().mapToInt(UNBOX_FUNCTION);
    }

    public IntStream sorted() {
        return new IntStream(new PrimitiveExtIterator.OfInt(){
            private int index = 0;
            private int[] array;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    this.array = IntStream.this.toArray();
                    Arrays.sort(this.array);
                }
                boolean bl = this.hasNext = this.index < this.array.length;
                if (this.hasNext) {
                    this.next = this.array[this.index++];
                }
            }
        });
    }

    public IntStream sorted(Comparator<Integer> comparator) {
        return this.boxed().sorted(comparator).mapToInt(UNBOX_FUNCTION);
    }

    public IntStream sample(final int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new IntStream(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }

            @Override
            public int nextInt() {
                int result = IntStream.this.iterator.nextInt();
                for (int skip = 1; skip < stepWidth && IntStream.this.iterator.hasNext(); ++skip) {
                    IntStream.this.iterator.nextInt();
                }
                return result;
            }
        });
    }

    public IntStream peek(final IntConsumer action) {
        return new IntStream(new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                int value = IntStream.this.iterator.nextInt();
                action.accept(value);
                return value;
            }

            @Override
            public boolean hasNext() {
                return IntStream.this.iterator.hasNext();
            }
        });
    }

    public IntStream takeWhile(final IntPredicate predicate) {
        return new IntStream(new PrimitiveExtIterator.OfInt(){

            @Override
            protected void nextIteration() {
                this.hasNext = IntStream.this.iterator.hasNext() && predicate.test(this.next = IntStream.this.iterator.next().intValue());
            }
        });
    }

    public IntStream dropWhile(final IntPredicate predicate) {
        return new IntStream(new PrimitiveExtIterator.OfInt(){

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    while (this.hasNext = IntStream.this.iterator.hasNext()) {
                        this.next = IntStream.this.iterator.next();
                        if (predicate.test(this.next)) continue;
                        return;
                    }
                }
                boolean bl = this.hasNext = this.hasNext && IntStream.this.iterator.hasNext();
                if (!this.hasNext) {
                    return;
                }
                this.next = IntStream.this.iterator.next();
            }
        });
    }

    public IntStream limit(final long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return IntStream.empty();
        }
        return new IntStream(new PrimitiveIterator.OfInt(){
            private long index = 0L;

            @Override
            public int nextInt() {
                ++this.index;
                return IntStream.this.iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                return this.index < maxSize && IntStream.this.iterator.hasNext();
            }
        });
    }

    public IntStream skip(final long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new IntStream(new PrimitiveIterator.OfInt(){
            long skipped = 0L;

            @Override
            public int nextInt() {
                return IntStream.this.iterator.nextInt();
            }

            @Override
            public boolean hasNext() {
                while (IntStream.this.iterator.hasNext() && this.skipped != n) {
                    ++this.skipped;
                    IntStream.this.iterator.nextInt();
                }
                return IntStream.this.iterator.hasNext();
            }
        });
    }

    public void forEach(IntConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextInt());
        }
    }

    public int reduce(int identity, IntBinaryOperator op) {
        int result = identity;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            result = op.applyAsInt(result, value);
        }
        return result;
    }

    public OptionalInt reduce(IntBinaryOperator op) {
        boolean foundAny = false;
        int result = 0;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = op.applyAsInt(result, value);
        }
        return foundAny ? OptionalInt.of(result) : OptionalInt.empty();
    }

    public int[] toArray() {
        SpinedBuffer.OfInt b = new SpinedBuffer.OfInt();
        this.forEach(b);
        return (int[])b.asPrimitiveArray();
    }

    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            accumulator.accept(result, value);
        }
        return result;
    }

    public int sum() {
        int sum = 0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextInt();
        }
        return sum;
    }

    public OptionalInt min() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left < right ? left : right;
            }
        });
    }

    public OptionalInt max() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left > right ? left : right;
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextInt();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public OptionalInt findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalInt.of(this.iterator.nextInt());
        }
        return OptionalInt.empty();
    }

    public int single() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("IntStream contains no element");
    }

    public OptionalInt findSingle() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.next();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return OptionalInt.of(singleCandidate);
        }
        return OptionalInt.empty();
    }
}

