/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.Objects;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalInt of(int value) {
        return new OptionalInt(value);
    }

    public int getAsInt() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(IntConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public OptionalInt executeIfPresent(IntConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    public OptionalInt executeIfAbsent(Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    public IntStream stream() {
        if (!this.isPresent()) {
            return IntStream.empty();
        }
        return IntStream.of(this.value);
    }

    public OptionalInt or(Supplier<OptionalInt> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public int orElse(int other) {
        return this.isPresent ? this.value : other;
    }

    public int orElseGet(IntSupplier other) {
        return this.isPresent ? this.value : other.getAsInt();
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

