/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Supplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Collectors {
    public static <T> Collector<T, ?, List<T>> toList() {
        return new Collector<T, List<T>, List<T>>(){

            @Override
            public Supplier<List<T>> supplier() {
                return new Supplier<List<T>>(){

                    @Override
                    public List<T> get() {
                        return new ArrayList();
                    }
                };
            }

            @Override
            public BiConsumer<List<T>, T> accumulator() {
                return new BiConsumer<List<T>, T>(){

                    @Override
                    public void accept(List<T> t, T u) {
                        t.add(u);
                    }
                };
            }

            @Override
            public Function<List<T>, List<T>> finisher() {
                return null;
            }
        };
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return new Collector<T, Set<T>, Set<T>>(){

            @Override
            public Supplier<Set<T>> supplier() {
                return new Supplier<Set<T>>(){

                    @Override
                    public Set<T> get() {
                        return new HashSet();
                    }
                };
            }

            @Override
            public BiConsumer<Set<T>, T> accumulator() {
                return new BiConsumer<Set<T>, T>(){

                    @Override
                    public void accept(Set<T> t, T u) {
                        t.add(u);
                    }
                };
            }

            @Override
            public Function<Set<T>, Set<T>> finisher() {
                return null;
            }
        };
    }

    public static Collector<CharSequence, ?, String> joining() {
        return new Collector<CharSequence, StringBuilder, String>(){

            @Override
            public Supplier<StringBuilder> supplier() {
                return new Supplier<StringBuilder>(){

                    @Override
                    public StringBuilder get() {
                        return new StringBuilder();
                    }
                };
            }

            @Override
            public BiConsumer<StringBuilder, CharSequence> accumulator() {
                return new BiConsumer<StringBuilder, CharSequence>(){

                    @Override
                    public void accept(StringBuilder t, CharSequence u) {
                        t.append(u);
                    }
                };
            }

            @Override
            public Function<StringBuilder, String> finisher() {
                return new Function<StringBuilder, String>(){

                    @Override
                    public String apply(StringBuilder value) {
                        return value.toString();
                    }
                };
            }
        };
    }

    public static <T> Collector<T, ?, Double> averaging(final Function<? super T, Double> mapper) {
        return new Collector<T, Double[], Double>(){

            @Override
            public Supplier<Double[]> supplier() {
                return new Supplier<Double[]>(){

                    @Override
                    public Double[] get() {
                        return new Double[]{0.0, 0.0};
                    }
                };
            }

            @Override
            public BiConsumer<Double[], T> accumulator() {
                return new BiConsumer<Double[], T>(){

                    @Override
                    public void accept(Double[] t, T u) {
                        Double[] doubleArray = t;
                        Double d = doubleArray[0];
                        Double d2 = doubleArray[0] = Double.valueOf(doubleArray[0] + 1.0);
                        doubleArray = t;
                        Double.valueOf(doubleArray[1] + (Double)mapper.apply(u));
                    }
                };
            }

            @Override
            public Function<Double[], Double> finisher() {
                return new Function<Double[], Double>(){

                    @Override
                    public Double apply(Double[] t) {
                        return t[1] / t[0];
                    }
                };
            }
        };
    }
}

