/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.containertag.proto.Serving;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.Types;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ResourceUtil {
    private static final int BUFFER_SIZE = 1024;

    private ResourceUtil() {
    }

    public static ExpandedResource getExpandedResource(Serving.Resource resource) throws InvalidResourceException {
        TypeSystem.Value[] expandedValues = new TypeSystem.Value[resource.value.length];
        for (int i = 0; i < resource.value.length; ++i) {
            ResourceUtil.expandValue(i, resource, expandedValues, new HashSet<Integer>(0));
        }
        ExpandedResourceBuilder builder = ExpandedResource.newBuilder();
        ArrayList<ExpandedFunctionCall> tags = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.tag.length; ++i) {
            tags.add(ResourceUtil.expandFunctionCall(resource.tag[i], resource, expandedValues, i));
        }
        ArrayList<ExpandedFunctionCall> predicates = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.predicate.length; ++i) {
            predicates.add(ResourceUtil.expandFunctionCall(resource.predicate[i], resource, expandedValues, i));
        }
        ArrayList<ExpandedFunctionCall> macros = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.macro.length; ++i) {
            ExpandedFunctionCall thisMacro = ResourceUtil.expandFunctionCall(resource.macro[i], resource, expandedValues, i);
            builder.addMacro(thisMacro);
            macros.add(thisMacro);
        }
        for (Serving.Rule r : resource.rule) {
            builder.addRule(ResourceUtil.expandRule(r, tags, macros, predicates, resource));
        }
        builder.setVersion(resource.version);
        builder.setResourceFormatVersion(resource.resourceFormatVersion);
        return builder.build();
    }

    public static TypeSystem.Value newValueBasedOnValue(TypeSystem.Value v) {
        TypeSystem.Value result = new TypeSystem.Value();
        result.type = v.type;
        result.escaping = (int[])v.escaping.clone();
        if (v.containsReferences) {
            result.containsReferences = v.containsReferences;
        }
        return result;
    }

    private static TypeSystem.Value expandValue(int i, Serving.Resource resource, TypeSystem.Value[] expandedValues, Set<Integer> pendingExpansions) throws InvalidResourceException {
        if (pendingExpansions.contains(i)) {
            ResourceUtil.logAndThrow("Value cycle detected.  Current value reference: " + i + "." + "  Previous value references: " + pendingExpansions + ".");
        }
        TypeSystem.Value value = ResourceUtil.getWithBoundsCheck(resource.value, i, "values");
        if (expandedValues[i] != null) {
            return expandedValues[i];
        }
        TypeSystem.Value toAdd = null;
        pendingExpansions.add(i);
        switch (value.type) {
            case 2: {
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                toAdd = ResourceUtil.newValueBasedOnValue(value);
                toAdd.listItem = new TypeSystem.Value[servingValue.listItem.length];
                int index = 0;
                for (int listIndex : servingValue.listItem) {
                    toAdd.listItem[index++] = ResourceUtil.expandValue(listIndex, resource, expandedValues, pendingExpansions);
                }
                break;
            }
            case 3: {
                toAdd = ResourceUtil.newValueBasedOnValue(value);
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                if (servingValue.mapKey.length != servingValue.mapValue.length) {
                    ResourceUtil.logAndThrow("Uneven map keys (" + servingValue.mapKey.length + ") and map values (" + servingValue.mapValue.length + ")");
                }
                toAdd.mapKey = new TypeSystem.Value[servingValue.mapKey.length];
                toAdd.mapValue = new TypeSystem.Value[servingValue.mapKey.length];
                int index = 0;
                for (int keyIndex : servingValue.mapKey) {
                    toAdd.mapKey[index++] = ResourceUtil.expandValue(keyIndex, resource, expandedValues, pendingExpansions);
                }
                index = 0;
                for (int valueIndex : servingValue.mapValue) {
                    toAdd.mapValue[index++] = ResourceUtil.expandValue(valueIndex, resource, expandedValues, pendingExpansions);
                }
                break;
            }
            case 4: {
                String macroName;
                toAdd = ResourceUtil.newValueBasedOnValue(value);
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                TypeSystem.Value macroNameValue = ResourceUtil.expandValue(servingValue.macroNameReference, resource, expandedValues, pendingExpansions);
                toAdd.macroReference = macroName = Types.valueToString(macroNameValue);
                break;
            }
            case 7: {
                toAdd = ResourceUtil.newValueBasedOnValue(value);
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                toAdd.templateToken = new TypeSystem.Value[servingValue.templateToken.length];
                int index = 0;
                for (int templateIndex : servingValue.templateToken) {
                    toAdd.templateToken[index++] = ResourceUtil.expandValue(templateIndex, resource, expandedValues, pendingExpansions);
                }
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                toAdd = value;
            }
        }
        if (toAdd == null) {
            ResourceUtil.logAndThrow("Invalid value: " + value);
        }
        expandedValues[i] = toAdd;
        pendingExpansions.remove(i);
        return toAdd;
    }

    private static Serving.ServingValue getServingValue(TypeSystem.Value value) throws InvalidResourceException {
        Serving.ServingValue servingValue = value.getExtension(Serving.ServingValue.ext);
        if (servingValue == null) {
            ResourceUtil.logAndThrow("Expected a ServingValue and didn't get one. Value is: " + value);
        }
        return value.getExtension(Serving.ServingValue.ext);
    }

    private static void logAndThrow(String error) throws InvalidResourceException {
        Log.e(error);
        throw new InvalidResourceException(error);
    }

    private static <T> T getWithBoundsCheck(T[] array, int idx, String listName) throws InvalidResourceException {
        if (idx < 0 || idx >= array.length) {
            ResourceUtil.logAndThrow("Index out of bounds detected: " + idx + " in " + listName);
        }
        return array[idx];
    }

    private static <T> T getWithBoundsCheck(List<T> list, int idx, String listName) throws InvalidResourceException {
        if (idx < 0 || idx >= list.size()) {
            ResourceUtil.logAndThrow("Index out of bounds detected: " + idx + " in " + listName);
        }
        return list.get(idx);
    }

    private static ExpandedFunctionCall expandFunctionCall(Serving.FunctionCall functionCall, Serving.Resource resource, TypeSystem.Value[] expandedValues, int idx) throws InvalidResourceException {
        ExpandedFunctionCallBuilder builder = ExpandedFunctionCall.newBuilder();
        int[] arr$ = functionCall.property;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            Serving.Property p = ResourceUtil.getWithBoundsCheck(resource.property, (int)i, "properties");
            String key = ResourceUtil.getWithBoundsCheck(resource.key, p.key, "keys");
            TypeSystem.Value value = ResourceUtil.getWithBoundsCheck(expandedValues, p.value, "values");
            if (Key.PUSH_AFTER_EVALUATE.toString().equals(key)) {
                builder.setPushAfterEvaluate(value);
                continue;
            }
            builder.addProperty(key, value);
        }
        return builder.build();
    }

    private static ExpandedRule expandRule(Serving.Rule rule, List<ExpandedFunctionCall> tags, List<ExpandedFunctionCall> macros, List<ExpandedFunctionCall> predicates, Serving.Resource resource) {
        Integer macroIndex;
        Integer ruleNameIndex;
        Integer tagIndex;
        Integer i;
        int i$;
        ExpandedRuleBuilder ruleBuilder = ExpandedRule.newBuilder();
        int[] arr$ = rule.positivePredicate;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            ruleBuilder.addPositivePredicate(predicates.get(i));
        }
        arr$ = rule.negativePredicate;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            ruleBuilder.addNegativePredicate(predicates.get(i));
        }
        arr$ = rule.addTag;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            tagIndex = arr$[i$];
            ruleBuilder.addAddTag(tags.get(tagIndex));
        }
        arr$ = rule.addTagRuleName;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            ruleNameIndex = arr$[i$];
            ruleBuilder.addAddTagRuleName(resource.value[ruleNameIndex.intValue()].string);
        }
        arr$ = rule.removeTag;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            tagIndex = arr$[i$];
            ruleBuilder.addRemoveTag(tags.get(tagIndex));
        }
        arr$ = rule.removeTagRuleName;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            ruleNameIndex = arr$[i$];
            ruleBuilder.addRemoveTagRuleName(resource.value[ruleNameIndex.intValue()].string);
        }
        arr$ = rule.addMacro;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            macroIndex = arr$[i$];
            ruleBuilder.addAddMacro(macros.get(macroIndex));
        }
        arr$ = rule.addMacroRuleName;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            ruleNameIndex = arr$[i$];
            ruleBuilder.addAddMacroRuleName(resource.value[ruleNameIndex.intValue()].string);
        }
        arr$ = rule.removeMacro;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            macroIndex = arr$[i$];
            ruleBuilder.addRemoveMacro(macros.get(macroIndex));
        }
        arr$ = rule.removeMacroRuleName;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            ruleNameIndex = arr$[i$];
            ruleBuilder.addRemoveMacroRuleName(resource.value[ruleNameIndex.intValue()].string);
        }
        return ruleBuilder.build();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int numBytes;
        while ((numBytes = in.read(buffer)) != -1) {
            out.write(buffer, 0, numBytes);
        }
        return;
    }

    public static class ExpandedResource {
        private final List<ExpandedRule> mRules;
        private final Map<String, List<ExpandedFunctionCall>> mMacros;
        private final String mVersion;
        private final int mResourceFormatVersion;

        private ExpandedResource(List<ExpandedRule> rules, Map<String, List<ExpandedFunctionCall>> macros, String version, int resourceFormatVersion) {
            this.mRules = Collections.unmodifiableList(rules);
            this.mMacros = Collections.unmodifiableMap(macros);
            this.mVersion = version;
            this.mResourceFormatVersion = resourceFormatVersion;
        }

        public static ExpandedResourceBuilder newBuilder() {
            return new ExpandedResourceBuilder();
        }

        public List<ExpandedRule> getRules() {
            return this.mRules;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public int getResourceFormatVersion() {
            return this.mResourceFormatVersion;
        }

        public List<ExpandedFunctionCall> getMacros(String name) {
            return this.mMacros.get(name);
        }

        public Map<String, List<ExpandedFunctionCall>> getAllMacros() {
            return this.mMacros;
        }

        public String toString() {
            return "Rules: " + this.getRules() + "  Macros: " + this.mMacros;
        }
    }

    public static class ExpandedResourceBuilder {
        private final List<ExpandedRule> mRules = new ArrayList<ExpandedRule>();
        private final Map<String, List<ExpandedFunctionCall>> mMacros = new HashMap<String, List<ExpandedFunctionCall>>();
        private String mVersion = "";
        private int mResourceFormatVersion = 0;

        private ExpandedResourceBuilder() {
        }

        public ExpandedResourceBuilder addRule(ExpandedRule r) {
            this.mRules.add(r);
            return this;
        }

        public ExpandedResourceBuilder addMacro(ExpandedFunctionCall f) {
            String macroName = Types.valueToString(f.getProperties().get(Key.INSTANCE_NAME.toString()));
            List<ExpandedFunctionCall> macroList = this.mMacros.get(macroName);
            if (macroList == null) {
                macroList = new ArrayList<ExpandedFunctionCall>();
                this.mMacros.put(macroName, macroList);
            }
            macroList.add(f);
            return this;
        }

        public ExpandedResourceBuilder setVersion(String version) {
            this.mVersion = version;
            return this;
        }

        public ExpandedResourceBuilder setResourceFormatVersion(int resourceFormatVersion) {
            this.mResourceFormatVersion = resourceFormatVersion;
            return this;
        }

        public ExpandedResource build() {
            return new ExpandedResource(this.mRules, this.mMacros, this.mVersion, this.mResourceFormatVersion);
        }
    }

    public static class ExpandedRule {
        private final List<ExpandedFunctionCall> mPositivePredicates;
        private final List<ExpandedFunctionCall> mNegativePredicates;
        private final List<ExpandedFunctionCall> mAddTags;
        private final List<ExpandedFunctionCall> mRemoveTags;
        private final List<ExpandedFunctionCall> mAddMacros;
        private final List<ExpandedFunctionCall> mRemoveMacros;
        private final List<String> mAddMacroRuleNames;
        private final List<String> mRemoveMacroRuleNames;
        private final List<String> mAddTagRuleNames;
        private final List<String> mRemoveTagRuleNames;

        private ExpandedRule(List<ExpandedFunctionCall> postivePredicates, List<ExpandedFunctionCall> negativePredicates, List<ExpandedFunctionCall> addTags, List<ExpandedFunctionCall> removeTags, List<ExpandedFunctionCall> addMacros, List<ExpandedFunctionCall> removeMacros, List<String> addMacroRuleNames, List<String> removeMacroRuleNames, List<String> addTagRuleNames, List<String> removeTagRuleNames) {
            this.mPositivePredicates = Collections.unmodifiableList(postivePredicates);
            this.mNegativePredicates = Collections.unmodifiableList(negativePredicates);
            this.mAddTags = Collections.unmodifiableList(addTags);
            this.mRemoveTags = Collections.unmodifiableList(removeTags);
            this.mAddMacros = Collections.unmodifiableList(addMacros);
            this.mRemoveMacros = Collections.unmodifiableList(removeMacros);
            this.mAddMacroRuleNames = Collections.unmodifiableList(addMacroRuleNames);
            this.mRemoveMacroRuleNames = Collections.unmodifiableList(removeMacroRuleNames);
            this.mAddTagRuleNames = Collections.unmodifiableList(addTagRuleNames);
            this.mRemoveTagRuleNames = Collections.unmodifiableList(removeTagRuleNames);
        }

        public static ExpandedRuleBuilder newBuilder() {
            return new ExpandedRuleBuilder();
        }

        public List<ExpandedFunctionCall> getPositivePredicates() {
            return this.mPositivePredicates;
        }

        public List<ExpandedFunctionCall> getNegativePredicates() {
            return this.mNegativePredicates;
        }

        public List<ExpandedFunctionCall> getAddTags() {
            return this.mAddTags;
        }

        public List<ExpandedFunctionCall> getRemoveTags() {
            return this.mRemoveTags;
        }

        public List<ExpandedFunctionCall> getAddMacros() {
            return this.mAddMacros;
        }

        public List<String> getAddMacroRuleNames() {
            return this.mAddMacroRuleNames;
        }

        public List<String> getRemoveMacroRuleNames() {
            return this.mRemoveMacroRuleNames;
        }

        public List<String> getAddTagRuleNames() {
            return this.mAddTagRuleNames;
        }

        public List<String> getRemoveTagRuleNames() {
            return this.mRemoveTagRuleNames;
        }

        public List<ExpandedFunctionCall> getRemoveMacros() {
            return this.mRemoveMacros;
        }

        public String toString() {
            return "Positive predicates: " + this.getPositivePredicates() + "  Negative predicates: " + this.getNegativePredicates() + "  Add tags: " + this.getAddTags() + "  Remove tags: " + this.getRemoveTags() + "  Add macros: " + this.getAddMacros() + "  Remove macros: " + this.getRemoveMacros();
        }
    }

    public static class ExpandedRuleBuilder {
        private final List<ExpandedFunctionCall> mPositivePredicates = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mNegativePredicates = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mAddTags = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mRemoveTags = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mAddMacros = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mRemoveMacros = new ArrayList<ExpandedFunctionCall>();
        private final List<String> mAddMacroRuleNames = new ArrayList<String>();
        private final List<String> mRemoveMacroRuleNames = new ArrayList<String>();
        private final List<String> mAddTagRuleNames = new ArrayList<String>();
        private final List<String> mRemoveTagRuleNames = new ArrayList<String>();

        private ExpandedRuleBuilder() {
        }

        public ExpandedRuleBuilder addPositivePredicate(ExpandedFunctionCall f) {
            this.mPositivePredicates.add(f);
            return this;
        }

        public ExpandedRuleBuilder addNegativePredicate(ExpandedFunctionCall f) {
            this.mNegativePredicates.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddTag(ExpandedFunctionCall f) {
            this.mAddTags.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddTagRuleName(String ruleName) {
            this.mAddTagRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addRemoveTag(ExpandedFunctionCall f) {
            this.mRemoveTags.add(f);
            return this;
        }

        public ExpandedRuleBuilder addRemoveTagRuleName(String ruleName) {
            this.mRemoveTagRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addAddMacro(ExpandedFunctionCall f) {
            this.mAddMacros.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddMacroRuleName(String ruleName) {
            this.mAddMacroRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addRemoveMacro(ExpandedFunctionCall f) {
            this.mRemoveMacros.add(f);
            return this;
        }

        public ExpandedRuleBuilder addRemoveMacroRuleName(String ruleName) {
            this.mRemoveMacroRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRule build() {
            return new ExpandedRule(this.mPositivePredicates, this.mNegativePredicates, this.mAddTags, this.mRemoveTags, this.mAddMacros, this.mRemoveMacros, this.mAddMacroRuleNames, this.mRemoveMacroRuleNames, this.mAddTagRuleNames, this.mRemoveTagRuleNames);
        }
    }

    public static class ExpandedFunctionCall {
        private final Map<String, TypeSystem.Value> mPropertiesMap;
        private final TypeSystem.Value mPushAfterEvaluate;

        private ExpandedFunctionCall(Map<String, TypeSystem.Value> propertiesMap, TypeSystem.Value pushAfterEvaluate) {
            this.mPropertiesMap = propertiesMap;
            this.mPushAfterEvaluate = pushAfterEvaluate;
        }

        public static ExpandedFunctionCallBuilder newBuilder() {
            return new ExpandedFunctionCallBuilder();
        }

        public void updateCacheableProperty(String key, TypeSystem.Value v) {
            this.mPropertiesMap.put(key, v);
        }

        public Map<String, TypeSystem.Value> getProperties() {
            return Collections.unmodifiableMap(this.mPropertiesMap);
        }

        public TypeSystem.Value getPushAfterEvaluate() {
            return this.mPushAfterEvaluate;
        }

        public String toString() {
            return "Properties: " + this.getProperties() + " pushAfterEvaluate: " + this.mPushAfterEvaluate;
        }
    }

    public static class ExpandedFunctionCallBuilder {
        private final Map<String, TypeSystem.Value> mPropertiesMap = new HashMap<String, TypeSystem.Value>();
        private TypeSystem.Value mPushAfterEvaluate;

        private ExpandedFunctionCallBuilder() {
        }

        public ExpandedFunctionCallBuilder addProperty(String key, TypeSystem.Value value) {
            this.mPropertiesMap.put(key, value);
            return this;
        }

        public ExpandedFunctionCallBuilder setPushAfterEvaluate(TypeSystem.Value value) {
            this.mPushAfterEvaluate = value;
            return this;
        }

        public ExpandedFunctionCall build() {
            return new ExpandedFunctionCall(this.mPropertiesMap, this.mPushAfterEvaluate);
        }
    }

    public static class InvalidResourceException
    extends Exception {
        public InvalidResourceException(String s) {
            super(s);
        }
    }
}

