/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.FunctionCallImplementation;
import aniways.com.google.tagmanager.Types;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexGroupMacro
extends FunctionCallImplementation {
    private static final String ID = FunctionType.REGEX_GROUP.toString();
    private static final String TO_MATCH = Key.ARG0.toString();
    private static final String REGEX = Key.ARG1.toString();
    private static final String IGNORE_CASE = Key.IGNORE_CASE.toString();
    private static final String GROUP = Key.GROUP.toString();

    public static String getFunctionId() {
        return ID;
    }

    public RegexGroupMacro() {
        super(ID, TO_MATCH, REGEX);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        TypeSystem.Value toMatch = parameters.get(TO_MATCH);
        TypeSystem.Value regex = parameters.get(REGEX);
        if (toMatch == null || toMatch == Types.getDefaultValue() || regex == null || regex == Types.getDefaultValue()) {
            return Types.getDefaultValue();
        }
        int flags = 64;
        if (Types.valueToBoolean(parameters.get(IGNORE_CASE)).booleanValue()) {
            flags |= 2;
        }
        int groupNumber = 1;
        TypeSystem.Value groupNumberValue = parameters.get(GROUP);
        if (groupNumberValue != null) {
            Long groupNumberLong = Types.valueToInt64(groupNumberValue);
            if (groupNumberLong == Types.getDefaultInt64()) {
                return Types.getDefaultValue();
            }
            groupNumber = groupNumberLong.intValue();
            if (groupNumber < 0) {
                return Types.getDefaultValue();
            }
        }
        try {
            String toMatchString = Types.valueToString(toMatch);
            String regexString = Types.valueToString(regex);
            String extracted = null;
            Matcher m = Pattern.compile(regexString, flags).matcher(toMatchString);
            if (m.find() && m.groupCount() >= groupNumber) {
                extracted = m.group(groupNumber);
            }
            return extracted == null ? Types.getDefaultValue() : Types.objectToValue(extracted);
        }
        catch (PatternSyntaxException err) {
            return Types.getDefaultValue();
        }
    }
}

