/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.FunctionCallImplementation;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.Types;
import java.util.HashMap;
import java.util.Map;

class CustomFunctionCall
extends FunctionCallImplementation {
    private static final String ID = FunctionType.FUNCTION_CALL.toString();
    private static final String FUNCTION_CALL_NAME = Key.FUNCTION_CALL_NAME.toString();
    private static final String ADDITIONAL_PARAMS = Key.ADDITIONAL_PARAMS.toString();
    private final CustomEvaluator mFunctionCallEvaluator;

    public static String getFunctionId() {
        return ID;
    }

    public static String getFunctionCallNameKey() {
        return FUNCTION_CALL_NAME;
    }

    public static String getAdditionalParamsKey() {
        return ADDITIONAL_PARAMS;
    }

    public CustomFunctionCall(CustomEvaluator functionCallEvaluator) {
        super(ID, FUNCTION_CALL_NAME);
        this.mFunctionCallEvaluator = functionCallEvaluator;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        String functionCallName = Types.valueToString(parameters.get(FUNCTION_CALL_NAME));
        HashMap<String, Object> objectParams = new HashMap<String, Object>();
        TypeSystem.Value additionalParamsValue = parameters.get(ADDITIONAL_PARAMS);
        if (additionalParamsValue != null) {
            Object additionalParamsObject = Types.valueToObject(additionalParamsValue);
            if (!(additionalParamsObject instanceof Map)) {
                Log.w("FunctionCallMacro: expected ADDITIONAL_PARAMS to be a map.");
                return Types.getDefaultValue();
            }
            Map additionalParams = (Map)additionalParamsObject;
            for (Map.Entry entry : additionalParams.entrySet()) {
                objectParams.put(entry.getKey().toString(), entry.getValue());
            }
        }
        try {
            return Types.objectToValue(this.mFunctionCallEvaluator.evaluate(functionCallName, objectParams));
        }
        catch (Exception e) {
            Log.w("Custom macro/tag " + functionCallName + " threw exception " + e.getMessage());
            return Types.getDefaultValue();
        }
    }

    public static interface CustomEvaluator {
        public Object evaluate(String var1, Map<String, Object> var2);
    }
}

