/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.os.Build;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.Base64;

class Base64Encoder {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int URL_SAFE = 2;

    Base64Encoder() {
    }

    public static String encodeToString(byte[] input, int flags) {
        boolean websafeDesired;
        if (Base64Encoder.getSdkVersion() >= 8) {
            int newFlags = 2;
            if ((flags & 1) != 0) {
                newFlags |= 1;
            }
            if ((flags & 2) != 0) {
                newFlags |= 8;
            }
            return android.util.Base64.encodeToString((byte[])input, (int)newFlags);
        }
        boolean paddingDesired = (flags & 1) == 0;
        boolean bl = websafeDesired = (flags & 2) != 0;
        if (websafeDesired) {
            return Base64.encodeWebSafe(input, paddingDesired);
        }
        return Base64.encode(input, paddingDesired);
    }

    public static byte[] decode(String s, int flags) {
        boolean websafeDesired;
        if (Base64Encoder.getSdkVersion() >= 8) {
            int newFlags = 2;
            if ((flags & 1) != 0) {
                newFlags |= 1;
            }
            if ((flags & 2) != 0) {
                newFlags |= 8;
            }
            return android.util.Base64.decode((String)s, (int)newFlags);
        }
        boolean paddingDesired = (flags & 1) == 0;
        boolean bl = websafeDesired = (flags & 2) != 0;
        if (websafeDesired) {
            return Base64.decodeWebSafe(s);
        }
        return Base64.decode(s);
    }

    @VisibleForTesting
    static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }
}

