/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.Context;
import android.text.TextUtils;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.analytics.tracking.android.ParameterLoader;

class ParameterLoaderImpl
implements ParameterLoader {
    private final Context mContext;
    private String mOverrideResourcePackageName;

    public ParameterLoaderImpl(Context context) {
        if (context == null) {
            throw new NullPointerException("Context cannot be null");
        }
        this.mContext = context.getApplicationContext();
    }

    private int getResourceIdForType(String key, String type) {
        if (this.mContext == null) {
            return 0;
        }
        String resourcePackageName = this.mOverrideResourcePackageName != null ? this.mOverrideResourcePackageName : this.mContext.getPackageName();
        return this.mContext.getResources().getIdentifier(key, type, resourcePackageName);
    }

    @Override
    public String getString(String key) {
        int id = this.getResourceIdForType(key, "string");
        if (id == 0) {
            return null;
        }
        return this.mContext.getString(id);
    }

    @Override
    public boolean getBoolean(String key) {
        int id = this.getResourceIdForType(key, "bool");
        if (id == 0) {
            return false;
        }
        return "true".equalsIgnoreCase(this.mContext.getString(id));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        int id = this.getResourceIdForType(key, "integer");
        if (id == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.mContext.getString(id));
        }
        catch (NumberFormatException e) {
            Log.w("NumberFormatException parsing " + this.mContext.getString(id));
            return defaultValue;
        }
    }

    @Override
    public boolean isBooleanKeyPresent(String key) {
        return this.getResourceIdForType(key, "bool") != 0;
    }

    @Override
    public Double getDoubleFromString(String key) {
        String value = this.getString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Log.w("NumberFormatException parsing " + value);
            return null;
        }
    }

    @Override
    public void setResourcePackageName(String resourcePackageName) {
        this.mOverrideResourcePackageName = resourcePackageName;
    }
}

