/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley.toolbox;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysNetworkStateChecker;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.VolleyError;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.ImageLoader;
import java.util.ArrayList;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

public class NetworkImageView
extends ImageView {
    protected static final String TAG = "AniwaysNetworkImageView";
    private String mUrl;
    private int mDefaultImageId;
    private int mErrorImageId;
    private ImageLoader mImageLoader;
    private ImageLoader.ImageContainer mImageContainer;
    private List<IResponseListener> mRequestListeners = new ArrayList<IResponseListener>();
    private int mMaxWidth;
    private int mMaxHeight;
    private boolean mGetDiskCacheOnMainThread;
    private IconData mIconData;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageUrl(String url, ImageLoader imageLoader) {
        this.setImageUrl(url, null, imageLoader, 0, 0, false);
    }

    public void setImageUrl(String url, IconData iconData, ImageLoader imageLoader, Integer maxWidth, Integer maxHeight, boolean getDiskCacheOnMainThread) {
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
        this.mGetDiskCacheOnMainThread = getDiskCacheOnMainThread;
        this.mIconData = iconData;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    public void registerResponseListener(IResponseListener responseListener) {
        this.mRequestListeners.add(responseListener);
    }

    public void unregisterPreviousListeners() {
        this.mRequestListeners.clear();
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.mMaxWidth == 0 ? this.getWidth() : this.mMaxWidth;
        int height = this.mMaxHeight == 0 ? this.getHeight() : this.mMaxHeight;
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        final int maxWidth = wrapWidth ? 0 : width;
        final int maxHeight = wrapHeight ? 0 : height;
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(final VolleyError error) {
                AniwaysNetworkStateChecker.checkInternet(new AniwaysNetworkStateChecker.AniwaysNetworkSateCheckCallback(){

                    @Override
                    public void run(boolean connectionAvailable) {
                        if (connectionAvailable) {
                            Log.e(true, NetworkImageView.TAG, "Error loading image from url: " + NetworkImageView.this.mUrl + ". Error: " + error.getMessage(), error);
                        } else {
                            Log.w(false, NetworkImageView.TAG, "Error loading image, but its OK since there us no internet connection. Url: " + NetworkImageView.this.mUrl + ". Error: " + error.getMessage(), error);
                        }
                    }
                });
                if (NetworkImageView.this.mErrorImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mErrorImageId);
                }
                for (IResponseListener listener : NetworkImageView.this.mRequestListeners) {
                    listener.onError();
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, final boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    NetworkImageView.this.post(new NonThrowingRunnable("Aniways volley network image view", "onResponse", null){

                        @Override
                        public void innerRun() {
                            this.onResponse(response, isImmediate);
                        }
                    });
                    return;
                }
                this.onResponseInternal(response, isImmediate);
            }

            public void onResponseInternal(ImageLoader.ImageContainer response, boolean cameFromImmediate) {
                Drawable dr = null;
                if (NetworkImageView.this.mIconData != null && NetworkImageView.this.mIconData.isAnimated() && AniwaysPrivateConfig.getInstance().animateInImageView) {
                    byte[] data = response.getRawData();
                    if (data == null) {
                        if (cameFromImmediate) {
                            Log.v(NetworkImageView.TAG, "Received immediate null response for animated gif: " + NetworkImageView.this.mUrl);
                        } else {
                            Log.w(true, NetworkImageView.TAG, "Received non-immediate null response for animated gif: " + NetworkImageView.this.mUrl);
                            for (IResponseListener listener : NetworkImageView.this.mRequestListeners) {
                                listener.onError();
                            }
                        }
                    } else if (data instanceof byte[]) {
                        dr = NetworkImageView.this.mIconData.setDrawableBounds(IconData.generateAnimatedDrawable(data), maxWidth, maxHeight);
                    } else {
                        Log.e(true, NetworkImageView.TAG, "Received non byte array for animated gif: " + NetworkImageView.this.mUrl);
                        for (IResponseListener listener : NetworkImageView.this.mRequestListeners) {
                            listener.onError();
                        }
                    }
                } else if (response.getRawData() != null) {
                    dr = IconData.generateAnimatedDrawable(response.getRawData());
                } else if (response.getBitmap() != null) {
                    dr = new BitmapDrawable(NetworkImageView.this.getContext().getResources(), response.getBitmap());
                } else if (response.getBitmap() == null) {
                    if (cameFromImmediate) {
                        Log.v(NetworkImageView.TAG, "Received immediate null response for bitmap: " + NetworkImageView.this.mUrl);
                        if (NetworkImageView.this.mDefaultImageId != 0) {
                            NetworkImageView.this.setImageResource(NetworkImageView.this.mDefaultImageId);
                        }
                        return;
                    }
                    Log.e(true, NetworkImageView.TAG, "Bitmap is null. Url: " + NetworkImageView.this.mUrl);
                    for (IResponseListener listener : NetworkImageView.this.mRequestListeners) {
                        listener.onError();
                    }
                }
                if (dr != null) {
                    if (dr instanceof GifDrawable) {
                        ((GifDrawable)dr).stop();
                    }
                    NetworkImageView.this.setImageDrawable(dr);
                    for (IResponseListener listener : NetworkImageView.this.mRequestListeners) {
                        listener.onSuccess();
                    }
                } else if (NetworkImageView.this.mDefaultImageId != 0) {
                    Log.e(true, NetworkImageView.TAG, "Setting default resource");
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mDefaultImageId);
                }
            }
        }, maxWidth, maxHeight, this.mGetDiskCacheOnMainThread);
    }

    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary(true);
    }

    protected void onDetachedFromWindow() {
        this.recycle(false, true, true);
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void stopAnimation() {
        Drawable dr = this.getDrawable();
        if (dr == null) {
            return;
        }
        if (dr instanceof GifDrawable) {
            ((GifDrawable)dr).stop();
        }
    }

    public void startAnimation() {
        Drawable dr = this.getDrawable();
        if (dr == null) {
            return;
        }
        if (dr instanceof GifDrawable) {
            ((GifDrawable)dr).start();
        }
    }

    public void recycle(boolean recycleBitmap, boolean recycleAnimatedGif, boolean keepUrl) {
        if (this.mImageContainer != null) {
            Drawable dr = this.getDrawable();
            if (dr != null) {
                Bitmap b;
                if (dr instanceof GifDrawable) {
                    if (recycleAnimatedGif) {
                        ((GifDrawable)dr).recycle();
                        Log.v(TAG, "recycled gif");
                    }
                } else if (dr instanceof BitmapDrawable && recycleBitmap && (b = ((BitmapDrawable)dr).getBitmap()) != null) {
                    b.recycle();
                    Log.v(TAG, "recycled bitmap");
                }
            }
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
            if (!keepUrl) {
                this.mUrl = null;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        try {
            super.onDraw(canvas);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

