/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley.toolbox;

import android.graphics.Bitmap;
import com.aniways.AniwaysBitmapDecodeUtils;
import com.aniways.volley.DefaultRetryPolicy;
import com.aniways.volley.NetworkResponse;
import com.aniways.volley.ParseError;
import com.aniways.volley.Request;
import com.aniways.volley.Response;
import com.aniways.volley.VolleyLog;
import com.aniways.volley.toolbox.HttpHeaderParser;

public class ImageRequest
extends Request<Bitmap> {
    private static final int IMAGE_TIMEOUT_MS = 1000;
    private static final int IMAGE_MAX_RETRIES = 2;
    private static final float IMAGE_BACKOFF_MULT = 2.0f;
    private final Response.Listener<Bitmap> mListener;
    private final int mMaxWidth;
    private final int mMaxHeight;
    private static final Object sDecodeLock = new Object();

    public ImageRequest(String url, Response.Listener<Bitmap> listener, int maxWidth, int maxHeight, Response.ErrorListener errorListener) {
        super(0, url, errorListener);
        this.setRetryPolicy(new DefaultRetryPolicy(1000, 2, 2.0f));
        this.mListener = listener;
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response<Bitmap> parseNetworkResponse(NetworkResponse response) {
        Object object = sDecodeLock;
        synchronized (object) {
            try {
                return this.doParse(response);
            }
            catch (OutOfMemoryError e) {
                VolleyLog.e("Caught OOM for %d byte image, url=%s", response.data.length, this.getUrl());
                return Response.error(new ParseError(e));
            }
        }
    }

    private Response<Bitmap> doParse(NetworkResponse response) {
        byte[] data = response.data;
        Bitmap bitmap = AniwaysBitmapDecodeUtils.decodeBitmapFromByteArray(data, this.mMaxWidth, this.mMaxHeight, response.url, true);
        if (bitmap == null) {
            return Response.error(new ParseError(response));
        }
        return Response.success(bitmap, HttpHeaderParser.parseCacheHeaders(response), data);
    }

    @Override
    protected void deliverResponse(Bitmap response) {
        this.mListener.onResponse(response);
    }

    static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }
}

