/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley;

import android.os.Handler;
import com.aniways.Log;
import com.aniways.volley.Request;
import com.aniways.volley.Response;
import com.aniways.volley.ResponseDelivery;
import com.aniways.volley.VolleyError;
import java.util.concurrent.Executor;

public class ExecutorDelivery
implements ResponseDelivery {
    private final Executor mResponsePoster;

    public ExecutorDelivery(final Handler handler) {
        this.mResponsePoster = new Executor(){

            @Override
            public void execute(Runnable command) {
                handler.post(command);
            }
        };
    }

    public ExecutorDelivery(Executor executor) {
        this.mResponsePoster = executor;
    }

    @Override
    public void postResponse(Request<?> request, Response<?> response) {
        this.postResponse(request, response, null);
    }

    @Override
    public void postResponse(Request<?> request, Response<?> response, Runnable runnable) {
        request.markDelivered();
        request.addMarker("post-response");
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, response, runnable));
    }

    @Override
    public void postError(Request<?> request, VolleyError error) {
        request.addMarker("post-error");
        Response response = Response.error(error);
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, response, null));
    }

    private class ResponseDeliveryRunnable
    implements Runnable {
        private final Request mRequest;
        private final Response mResponse;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(Request request, Response response, Runnable runnable) {
            this.mRequest = request;
            this.mResponse = response;
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                if (this.mRequest.isCanceled()) {
                    this.mRequest.finish("canceled-at-delivery");
                    return;
                }
                if (this.mResponse.isSuccess()) {
                    this.mRequest.deliverResponse(this.mResponse.result);
                } else {
                    this.mRequest.deliverError(this.mResponse.error);
                }
                if (this.mResponse.intermediate) {
                    this.mRequest.addMarker("intermediate-response");
                } else {
                    this.mRequest.finish("done");
                }
                if (this.mRunnable != null) {
                    this.mRunnable.run();
                }
            }
            catch (Throwable t) {
                Log.e(true, "Aniways volley executor delivery", "Error in ResponseDeliveryRunnable run", t);
            }
        }
    }
}

