/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.viewpagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.viewpagerindicator.PageIndicator;

public class CirclePageIndicator
extends View
implements PageIndicator {
    private static final String TAG = "AniwaysCirclePageIndicator";
    private float mRadius;
    private final Paint mPaintPageFill = new Paint(1);
    private final Paint mPaintStroke = new Paint(1);
    private final Paint mPaintFill = new Paint(1);
    private AniwaysDirectionalViewPager mViewPager;
    private AniwaysDirectionalViewPager.OnPageChangeListener mListener;
    private int mCurrentPage;
    private int mSnapPage;
    private float mPageOffset;
    private int mScrollState;
    private int mOrientation;
    private boolean mCentered;
    private boolean mSnap;

    public CirclePageIndicator(Context context) {
        this(context, null);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.aniways_vpiCirclePageIndicatorStyle);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            return;
        }
        Resources res = this.getResources();
        int defaultPageColor = res.getColor(R.color.aniways_default_circle_indicator_page_color);
        int defaultFillColor = res.getColor(R.color.aniways_default_circle_indicator_fill_color);
        int defaultOrientation = res.getInteger(R.integer.aniways_default_circle_indicator_orientation);
        int defaultStrokeColor = res.getColor(R.color.aniways_default_circle_indicator_stroke_color);
        float defaultStrokeWidth = res.getDimension(R.dimen.aniways_default_circle_indicator_stroke_width);
        float defaultRadius = res.getDimension(R.dimen.aniways_default_circle_indicator_radius);
        boolean defaultCentered = res.getBoolean(R.bool.aniways_default_circle_indicator_centered);
        boolean defaultSnap = res.getBoolean(R.bool.aniways_default_circle_indicator_snap);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AniwaysCirclePageIndicator, defStyle, 0);
        this.mCentered = a.getBoolean(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_centered, defaultCentered);
        this.mOrientation = a.getInt(R.styleable.AniwaysCirclePageIndicator_android_orientation, defaultOrientation);
        this.mPaintPageFill.setStyle(Paint.Style.FILL);
        this.mPaintPageFill.setColor(a.getColor(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_pageColor, defaultPageColor));
        this.mPaintStroke.setStyle(Paint.Style.STROKE);
        this.mPaintStroke.setColor(a.getColor(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_strokeColor, defaultStrokeColor));
        this.mPaintStroke.setStrokeWidth(a.getDimension(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_strokeWidth, defaultStrokeWidth));
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(a.getColor(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_fillColor, defaultFillColor));
        this.mRadius = a.getDimension(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_radius, defaultRadius);
        this.mSnap = a.getBoolean(R.styleable.AniwaysCirclePageIndicator_aniways_vpi_snap, defaultSnap);
        Drawable background = a.getDrawable(R.styleable.AniwaysCirclePageIndicator_android_background);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        a.recycle();
    }

    public void setCentered(boolean centered) {
        this.mCentered = centered;
        this.invalidate();
    }

    public boolean isCentered() {
        return this.mCentered;
    }

    public void setPageColor(int pageColor) {
        this.mPaintPageFill.setColor(pageColor);
        this.invalidate();
    }

    public int getPageColor() {
        return this.mPaintPageFill.getColor();
    }

    public void setFillColor(int fillColor) {
        this.mPaintFill.setColor(fillColor);
        this.invalidate();
    }

    public int getFillColor() {
        return this.mPaintFill.getColor();
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.mOrientation = orientation;
                this.requestLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException("Orientation must be either HORIZONTAL or VERTICAL.");
            }
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setStrokeColor(int strokeColor) {
        this.mPaintStroke.setColor(strokeColor);
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.mPaintStroke.getColor();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.mPaintStroke.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mPaintStroke.getStrokeWidth();
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setSnap(boolean snap) {
        this.mSnap = snap;
        this.invalidate();
    }

    public boolean isSnap() {
        return this.mSnap;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        try {
            float dY;
            float dX;
            int shortPaddingBefore;
            int longPaddingAfter;
            int longPaddingBefore;
            int longSize;
            if (this.mViewPager == null) {
                return;
            }
            int count = this.mViewPager.getAdapter().getCount();
            if (count == 0) {
                return;
            }
            if (this.mCurrentPage >= count) {
                this.setCurrentItem(count - 1);
                return;
            }
            if (this.mOrientation == 0) {
                longSize = this.getWidth();
                longPaddingBefore = this.getPaddingLeft();
                longPaddingAfter = this.getPaddingRight();
                shortPaddingBefore = this.getPaddingTop();
            } else {
                longSize = this.getHeight();
                longPaddingBefore = this.getPaddingTop();
                longPaddingAfter = this.getPaddingBottom();
                shortPaddingBefore = this.getPaddingLeft();
            }
            float threeRadius = this.mRadius * 4.0f;
            float shortOffset = (float)shortPaddingBefore + this.mRadius;
            float longOffset = (float)longPaddingBefore + this.mRadius;
            if (this.mCentered) {
                longOffset += (float)(longSize - longPaddingBefore - longPaddingAfter) / 2.0f - (float)count * threeRadius / 2.0f;
            }
            float pageFillRadius = this.mRadius;
            if (this.mPaintStroke.getStrokeWidth() > 0.0f) {
                pageFillRadius -= this.mPaintStroke.getStrokeWidth() / 2.0f;
            }
            for (int iLoop = 0; iLoop < count; ++iLoop) {
                float drawLong = longOffset + (float)iLoop * threeRadius;
                if (this.mOrientation == 0) {
                    dX = drawLong;
                    dY = shortOffset;
                } else {
                    dX = shortOffset;
                    dY = drawLong;
                }
                if (this.mPaintPageFill.getAlpha() > 0) {
                    canvas.drawCircle(dX, dY, pageFillRadius, this.mPaintPageFill);
                }
                if (pageFillRadius == this.mRadius) continue;
                canvas.drawCircle(dX, dY, this.mRadius, this.mPaintStroke);
            }
            float cx = (float)(this.mSnap ? this.mSnapPage : this.mCurrentPage) * threeRadius;
            if (!this.mSnap) {
                cx += this.mPageOffset * threeRadius;
            }
            if (this.mOrientation == 0) {
                dX = longOffset + cx;
                dY = shortOffset;
            } else {
                dX = shortOffset;
                dY = longOffset + cx;
            }
            canvas.drawCircle(dX, dY, this.mRadius, this.mPaintFill);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onDraw", ex);
        }
    }

    @Override
    public void setViewPager(AniwaysDirectionalViewPager view) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (view.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        try {
            this.mViewPager.setOnPageChangeListener(this);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setViewPager", ex);
        }
        this.invalidate();
    }

    @Override
    public void setViewPager(AniwaysDirectionalViewPager view, int initialPosition) {
        try {
            this.setViewPager(view);
            this.setCurrentItem(initialPosition);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setViewPager", ex);
        }
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        try {
            this.mViewPager.setCurrentItem(item);
            this.mCurrentPage = item;
            this.invalidate();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setCurrentItem", ex);
        }
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        try {
            this.mScrollState = state;
            if (this.mListener != null) {
                this.mListener.onPageScrollStateChanged(state);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageScrollStateChanged", ex);
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        try {
            this.mCurrentPage = position;
            this.mPageOffset = positionOffset;
            this.invalidate();
            if (this.mListener != null) {
                this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageScrolled", ex);
        }
    }

    @Override
    public void onPageSelected(int position) {
        try {
            if (this.mSnap || this.mScrollState == 0) {
                this.mCurrentPage = position;
                this.mSnapPage = position;
                this.invalidate();
            }
            if (this.mListener != null) {
                this.mListener.onPageSelected(position);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onPageSelected", ex);
        }
    }

    @Override
    public void setOnPageChangeListener(AniwaysDirectionalViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            if (this.mOrientation == 0) {
                this.setMeasuredDimension(this.measureLong(widthMeasureSpec), this.measureShort(heightMeasureSpec));
            } else {
                this.setMeasuredDimension(this.measureShort(widthMeasureSpec), this.measureLong(heightMeasureSpec));
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onMeasure", ex);
        }
    }

    private int measureLong(int measureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000 || this.mViewPager == null) {
            result = specSize;
        } else {
            int count = this.mViewPager.getAdapter().getCount();
            result = (int)((float)(this.getPaddingLeft() + this.getPaddingRight()) + (float)(count * 2) * this.mRadius + (float)(count - 1) * this.mRadius + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureShort(int measureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)(2.0f * this.mRadius + (float)this.getPaddingTop() + (float)this.getPaddingBottom() + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public void onRestoreInstanceState(Parcelable state) {
        try {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mCurrentPage = savedState.currentPage;
            this.mSnapPage = savedState.currentPage;
            this.requestLayout();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onRestoreInstanceState", ex);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        try {
            SavedState savedState = new SavedState(superState);
            savedState.currentPage = this.mCurrentPage;
            return savedState;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onSaveInstanceState", ex);
            return superState;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

