/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.preference.ListPreference;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.aniways.R;

public class ListPreferenceMultiSelect
extends ListPreference {
    private static final String SEPARATOR = "OV=I=XseparatorX=I=VO";
    private boolean[] mClickedDialogEntryIndices = new boolean[this.getEntries().length];

    public ListPreferenceMultiSelect(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setEntries(CharSequence[] entries) {
        super.setEntries(entries);
        this.mClickedDialogEntryIndices = new boolean[entries.length];
    }

    public ListPreferenceMultiSelect(Context context) {
        this(context, null);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        CharSequence[] entries = this.getEntries();
        CharSequence[] entryValues = this.getEntryValues();
        if (entries == null || entryValues == null || entries.length != entryValues.length) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array which are both the same length");
        }
        DisabledItemsArrayAdapter listAdapter = new DisabledItemsArrayAdapter(this.getContext(), R.layout.aniways_setting_language_row, this.getEntries(), null, 0);
        builder.setAdapter((ListAdapter)listAdapter, (DialogInterface.OnClickListener)this);
        super.onPrepareDialogBuilder(builder);
    }

    public static String[] parseStoredValue(CharSequence val) {
        if ("".equals(val)) {
            return null;
        }
        return ((String)val).split(SEPARATOR);
    }

    private void restoreCheckedEntries() {
        CharSequence[] entryValues = this.getEntryValues();
        String[] vals = ListPreferenceMultiSelect.parseStoredValue(this.getValue());
        if (vals != null) {
            block0: for (int j = 0; j < vals.length; ++j) {
                String val = vals[j].trim();
                for (int i = 0; i < entryValues.length; ++i) {
                    CharSequence entry = entryValues[i];
                    if (!entry.equals(val)) continue;
                    this.mClickedDialogEntryIndices[i] = true;
                    continue block0;
                }
            }
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        CharSequence[] entryValues = this.getEntryValues();
        if (positiveResult && entryValues != null) {
            StringBuffer value = new StringBuffer();
            for (int i = 0; i < entryValues.length; ++i) {
                if (!this.mClickedDialogEntryIndices[i]) continue;
                value.append(entryValues[i]).append(SEPARATOR);
            }
            if (this.callChangeListener(value)) {
                String val = value.toString();
                if (val.length() > 0) {
                    val = val.substring(0, val.length() - SEPARATOR.length());
                }
                this.setValue(val);
            }
        }
    }

    private class DisabledItemsArrayAdapter
    extends ArrayAdapter<CharSequence> {
        public DisabledItemsArrayAdapter(Context context, int textViewResourceId, CharSequence[] objects, int[] ids, int i) {
            super(context, textViewResourceId, (Object[])objects);
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return false;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            CharSequence item = (CharSequence)this.getItem(position);
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.aniways_setting_language_row, parent, false);
            }
            TextView title = (TextView)convertView.findViewById(R.id.setting_language_row_title);
            CheckBox checkBox = (CheckBox)convertView.findViewById(R.id.setting_language_row_checkbox);
            title.setText(item);
            checkBox.setChecked(true);
            return convertView;
        }
    }
}

