/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.quick.action;

import android.content.Context;
import android.support.v7.widget.GridLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.aniways.Log;
import com.aniways.quick.action.GridItemDimensions;
import com.aniways.quick.action.SelectedGridItemInfo;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.AniwaysUiUtil;
import java.util.List;

public class AniwaysGridView
extends GridLayout {
    private static final String TAG = "AniwaysGridView";
    protected List<View> collection;
    private int containerWidth;
    private AniwaysAction<SelectedGridItemInfo> onItemSelectedCallback;
    private int columns;
    private int rows;
    protected GridItemDimensions gridItemDimensions;

    public AniwaysGridView(Context context) {
        super(context);
    }

    public AniwaysGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void initialize(int containerWidth, AniwaysAction<SelectedGridItemInfo> onItemSelectedCallback) {
        this.containerWidth = containerWidth;
        this.onItemSelectedCallback = onItemSelectedCallback;
        if (this.collection == null || this.collection.isEmpty()) {
            Log.i(TAG, "trying to add action items to track with null or empty list");
            return;
        }
        if (this.gridItemDimensions == null) {
            Log.i(TAG, "trying to add action items to track without grid dimensions");
            return;
        }
        this.addItemsToGrid();
    }

    private void addItemsToGrid() {
        boolean isLastItemInRow = false;
        boolean isLastRow = false;
        int total = this.collection.size();
        int maxColumns = this.gridItemDimensions.itemWidth == -1 ? 1 : this.calcColumnsNumber(this.gridItemDimensions.itemWidth + this.gridItemDimensions.leftRightMargin, this.gridItemDimensions.leftRightMargin);
        this.columns = Math.min(total, maxColumns);
        this.rows = this.calcRowNumber(total, this.columns);
        if (this.columns <= 0) {
            return;
        }
        this.setColumnCount(this.columns);
        this.setRowCount(this.rows);
        int i = 0;
        int c = 0;
        int r = 0;
        while (i < total) {
            View gridItem = this.collection.get(i);
            if (gridItem == null) {
                --c;
            } else {
                if (c == this.columns - 1) {
                    isLastItemInRow = true;
                }
                if (c == this.columns) {
                    c = 0;
                    ++r;
                }
                if (r == this.rows - 1) {
                    isLastRow = true;
                }
                this.addItemToGrid(c, r, i, total, gridItem, isLastRow, isLastItemInRow);
                isLastItemInRow = false;
                isLastRow = false;
            }
            ++i;
            ++c;
        }
    }

    private void addItemToGrid(final int c, final int r, final int pos, final int totalNumberOfItems, final View gridItem, boolean isLastRow, boolean isLastItemInRow) {
        GridLayout.LayoutParams containerLp = this.getItemInGridLayoutParams(c, r, isLastRow, isLastItemInRow);
        gridItem.setLayoutParams((ViewGroup.LayoutParams)containerLp);
        gridItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (AniwaysGridView.this.onItemSelectedCallback != null) {
                        AniwaysGridView.this.onItemSelectedCallback.call(new SelectedGridItemInfo(AniwaysGridView.this.columns, c, r, AniwaysGridView.this.rows, gridItem, pos, totalNumberOfItems));
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysGridView.TAG, "Caught Exception in on click", ex);
                }
            }
        });
        this.addView(gridItem);
    }

    private GridLayout.LayoutParams getItemInGridLayoutParams(int column, int row, boolean isLastRow, boolean isLastItemInRow) {
        GridLayout.LayoutParams containerLp = new GridLayout.LayoutParams();
        containerLp.height = -2;
        containerLp.width = -2;
        containerLp.leftMargin = this.gridItemDimensions.leftRightMargin;
        containerLp.topMargin = this.gridItemDimensions.topBottomMargin;
        if (isLastItemInRow) {
            containerLp.rightMargin = this.gridItemDimensions.leftRightMargin;
        }
        if (isLastRow) {
            containerLp.bottomMargin = this.gridItemDimensions.topBottomMargin;
        }
        containerLp.setGravity(17);
        containerLp.columnSpec = GridLayout.spec((int)column);
        containerLp.rowSpec = GridLayout.spec((int)row);
        return containerLp;
    }

    private int calcRowNumber(int total, int columns) {
        if (columns == 0) {
            return 0;
        }
        int row = total / columns;
        return row += total % columns == 0 ? 0 : 1;
    }

    private int calcColumnsNumber(int singleIconWidth, int margin) {
        if (this.containerWidth == 0) {
            this.containerWidth = AniwaysUiUtil.getScreenDisplayMatrix().widthPixels;
        }
        return (this.containerWidth - margin) / singleIconWidth;
    }

    protected void setGridItemDimension(int gridRowHeight, int gridItemMargin, int itemHeight, int itemWidth) {
        int itemMaxHeight = Math.min(gridRowHeight - 2 * gridItemMargin, itemHeight);
        int itemMargin = (gridRowHeight - itemMaxHeight) / 2;
        this.gridItemDimensions = new GridItemDimensions(itemWidth, itemMaxHeight, itemMargin, itemMargin);
    }
}

