/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.quick.action;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.Phrase;
import com.aniways.data.PhraseAssetInfoExtractor;
import com.aniways.nineoldandroids.view.ViewHelper;
import com.aniways.quick.action.AniwaysGridView;
import com.aniways.quick.action.ContextualItemSelectedByUserEvent;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.EventAggregator;
import com.aniways.quick.action.IAniwaysPopupView;
import com.aniways.quick.action.SelectedGridItemInfo;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.AniwaysUiUtil;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AniwaysContextualPopupGridView
extends AniwaysGridView
implements IAniwaysPopupView {
    private static final String TAG = "AniwaysContextualPopupGridView";
    protected ContextualPopupCreationContext popupCreationContext;
    protected boolean selected = false;
    protected LinkedHashMap<View, IAniwaysAssetInfo> nonFullyInitializedImageContainers = new LinkedHashMap();
    protected boolean moreRevealed;
    private List<IAniwaysAssetInfo> assetInfoList = new ArrayList<IAniwaysAssetInfo>();
    private boolean secondRowLoaded;

    public AniwaysContextualPopupGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AniwaysContextualPopupGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysContextualPopupGridView(Context context) {
        super(context);
    }

    @Override
    public void initialize() {
        this.initialize(0);
    }

    @Override
    public void initialize(int containerWidth) {
        this.initializeGridDimensions();
        this.createGridWithPlaceHoldersForImages();
        super.initialize(containerWidth, this.getItemSelectedAction());
        PhraseAssetInfoExtractor modelBuilder = this.getAssetInfoExtractor();
        modelBuilder.extract(this.popupCreationContext.phrase, new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public void call(List<IAniwaysAssetInfo> model) {
                Log.i(AniwaysContextualPopupGridView.TAG, "Received model. Is null: " + (model == null));
                if (model == null) {
                    AniwaysContextualPopupGridView.this.removeAllViews();
                    return;
                }
                AniwaysContextualPopupGridView.this.bindModel(model);
            }
        });
    }

    private void createGridWithPlaceHoldersForImages() {
        int maxGridItemsNumber = this.getMaxGridItemsNumber(this.popupCreationContext.phrase);
        this.collection = new ArrayList(maxGridItemsNumber);
        for (int i = 0; i < maxGridItemsNumber; ++i) {
            this.collection.add(this.createItemView());
        }
    }

    private View createItemView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View iconContainer = inflater.inflate(R.layout.aniways_contextual_suggestions_popup_emoticon_item, null);
        NetworkImageView img = (NetworkImageView)iconContainer.findViewById(R.id.aniways_action_item_icon);
        ViewGroup.LayoutParams lp = img.getLayoutParams();
        lp.width = this.gridItemDimensions.itemWidth;
        lp.height = this.gridItemDimensions.itemHeight;
        img.setMinimumWidth(this.gridItemDimensions.itemWidth);
        img.setMinimumHeight(this.gridItemDimensions.itemHeight);
        img.setScaleType(this.getImageScaleType());
        img.setLayoutParams(lp);
        img.setDefaultImageResId(R.color.aniways_Gray);
        img.setErrorImageResId(R.color.aniways_Gray);
        img.setImageUrl(null, Volley.getImageLoader());
        return iconContainer;
    }

    @Override
    public void notifyNotSelected() {
        this.selected = false;
        this.moreRevealed = false;
        for (View v : this.collection) {
            NetworkImageView img = (NetworkImageView)v.findViewById(R.id.aniways_action_item_icon);
            img.stopAnimation();
        }
    }

    @Override
    public void notifySelected() {
        this.selected = true;
        this.moreRevealed = false;
        int index = 0;
        for (View v : this.collection) {
            NetworkImageView img = (NetworkImageView)v.findViewById(R.id.aniways_action_item_icon);
            if (index < this.getColumnCount()) {
                img.startAnimation();
            }
            ++index;
        }
    }

    private synchronized void loadSecondRow() {
        if (this.moreRevealed || this.secondRowLoaded) {
            return;
        }
        this.secondRowLoaded = true;
        int numColumns = this.getColumnCount();
        ArrayList<View> itemsToRemove = new ArrayList<View>(numColumns);
        int index = 0;
        for (Map.Entry<View, IAniwaysAssetInfo> entry : this.nonFullyInitializedImageContainers.entrySet()) {
            View imageContainer = entry.getKey();
            IAniwaysAssetInfo assetInfo = entry.getValue();
            this.setImageUrl(imageContainer, assetInfo, false);
            itemsToRemove.add(imageContainer);
            if (++index != numColumns) continue;
            break;
        }
        for (View imageContainer : itemsToRemove) {
            this.nonFullyInitializedImageContainers.remove(imageContainer);
        }
    }

    @Override
    public void notifyRevealMore() {
        this.moreRevealed = true;
        for (Map.Entry<View, IAniwaysAssetInfo> entry : this.nonFullyInitializedImageContainers.entrySet()) {
            View imageContainer = entry.getKey();
            IAniwaysAssetInfo assetInfo = entry.getValue();
            this.setImageUrl(imageContainer, assetInfo, false);
        }
        this.nonFullyInitializedImageContainers.clear();
        int index = 0;
        for (View v : this.collection) {
            NetworkImageView img = (NetworkImageView)v.findViewById(R.id.aniways_action_item_icon);
            if (index >= this.getColumnCount()) {
                img.startAnimation();
            }
            ++index;
        }
    }

    @Override
    public void notifyRevealLess() {
        this.moreRevealed = false;
        int index = 0;
        for (View v : this.collection) {
            NetworkImageView img = (NetworkImageView)v.findViewById(R.id.aniways_action_item_icon);
            if (index >= this.getColumnCount()) {
                img.stopAnimation();
            }
            ++index;
        }
    }

    @Override
    public List<IAniwaysAssetInfo> getCurrentlyPresentedAssets() {
        if (this.moreRevealed) {
            return this.assetInfoList;
        }
        if (this.assetInfoList.isEmpty()) {
            return this.assetInfoList;
        }
        return this.assetInfoList.subList(0, Math.min(this.assetInfoList.size(), super.getColumnCount()));
    }

    @Override
    public List<IAniwaysAssetInfo> getAvailableAssets() {
        return this.assetInfoList;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount();
    }

    protected void registerImageResponseListener(final NetworkImageView img, final ImageView lockImage, final View imageContainer, final IAniwaysAssetInfo assetInfo, final boolean isFirstRow) {
        img.registerResponseListener(new IResponseListener(){

            @Override
            public void onError() {
                AniwaysContextualPopupGridView.this.removeProgressbar(imageContainer);
                Log.e(true, AniwaysContextualPopupGridView.TAG, "onError invoked while trying to download image or animated gif using volley ");
                Handler h = new Handler(Looper.getMainLooper());
                h.postDelayed((Runnable)new NonThrowingRunnable(AniwaysContextualPopupGridView.TAG, "addActionItem.onError", ""){

                    @Override
                    public void innerRun() {
                        String toastString = "Please make sure you are connected to the Internet";
                        try {
                            toastString = AniwaysContextualPopupGridView.this.getContext().getResources().getString(R.string.aniways_check_internet_connection);
                        }
                        catch (Throwable ex) {
                            Log.w(true, AniwaysContextualPopupGridView.TAG, "Caught Exception while getting make sure connected to intenet toast string", ex);
                        }
                        Toast toast = Toast.makeText((Context)AniwaysContextualPopupGridView.this.getContext(), (CharSequence)toastString, (int)1);
                        toast.setGravity(17, 0, 0);
                        toast.show();
                    }
                }, AniwaysPrivateConfig.getInstance().noInternetPopupCloseDelay);
            }

            @Override
            public void onSuccess() {
                AniwaysContextualPopupGridView.this.removeProgressbar(imageContainer);
                AniwaysContextualPopupGridView.this.setLockedIconIndicationIfNecessary(img, lockImage, assetInfo);
                AniwaysContextualPopupGridView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        AniwaysContextualPopupGridView.this.loadSecondRow();
                    }
                });
                if (AniwaysContextualPopupGridView.this.selected && (AniwaysContextualPopupGridView.this.moreRevealed || isFirstRow)) {
                    img.startAnimation();
                } else {
                    img.stopAnimation();
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void setLockedIconIndicationIfNecessary(NetworkImageView img, ImageView lockImage, IAniwaysAssetInfo assetInfo) {
        if (assetInfo == null) {
            return;
        }
        IconData icon = assetInfo.getIconData();
        if (icon == null) {
            return;
        }
        if (AniwaysStoreManager.isIconLocked(icon)) {
            lockImage.setVisibility(0);
            ViewHelper.setAlpha((View)img, AniwaysPrivateConfig.getInstance().lockedIconAlpha);
        } else {
            lockImage.setVisibility(8);
        }
    }

    protected void removeProgressbar(View imageContainer) {
        try {
            ProgressBar spinner = (ProgressBar)imageContainer.findViewById(R.id.aniways_progress_bar_id);
            if (spinner != null) {
                spinner.setVisibility(8);
            }
        }
        catch (Throwable t) {
            Log.e(true, TAG, "Exception in IResponseListener onSuccess", t);
        }
    }

    protected void addProgressBar(View container) {
        View relativeLayout = container.findViewById(R.id.relative_container);
        int progressBarStyle = AniwaysPrivateConfig.getInstance().contextualGridRowHeight >= AniwaysUiUtil.convertDipsToPixels(76) ? 16842874 : 16842873;
        ProgressBar pb = new ProgressBar(this.getContext(), null, progressBarStyle);
        pb.setId(R.id.aniways_progress_bar_id);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        pb.setLayoutParams((ViewGroup.LayoutParams)params);
        ((ViewGroup)relativeLayout).addView((View)pb);
    }

    public void setPopupCreationContext(ContextualPopupCreationContext context) {
        this.popupCreationContext = context;
    }

    private void bindModel(List<IAniwaysAssetInfo> assetInfoList) {
        int maxGridItemsNumber = this.getMaxGridItemsNumber(this.popupCreationContext.phrase);
        this.assetInfoList = new ArrayList<IAniwaysAssetInfo>(assetInfoList);
        int index = 0;
        int numColumns = super.getColumnCount();
        for (IAniwaysAssetInfo assetInfo : assetInfoList) {
            if (index == maxGridItemsNumber) break;
            View imageContainer = (View)this.collection.get(index);
            imageContainer.setTag(R.id.aniways_asset_info_tag, (Object)assetInfo);
            if (index < numColumns) {
                this.setImageUrl(imageContainer, assetInfo, true);
            } else {
                this.nonFullyInitializedImageContainers.put(imageContainer, assetInfo);
            }
            ++index;
        }
    }

    private void setImageUrl(View imageContainer, IAniwaysAssetInfo assetInfo, boolean isFirstRow) {
        final String url = assetInfo.getLowQualityUrl();
        Log.i(TAG, "setting image url: " + url);
        this.addProgressBar(imageContainer);
        final NetworkImageView imageView = (NetworkImageView)imageContainer.findViewById(R.id.aniways_action_item_icon);
        ImageView lock = (ImageView)imageContainer.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
        this.registerImageResponseListener(imageView, lock, imageContainer, assetInfo, isFirstRow);
        imageView.setDefaultImageResId(R.color.aniways_Gray);
        imageView.setErrorImageResId(R.color.aniways_Gray);
        this.post(new Runnable(){

            @Override
            public void run() {
                imageView.setImageUrl(url, Volley.getImageLoader());
            }
        });
    }

    private AniwaysAction<SelectedGridItemInfo> getItemSelectedAction() {
        return new AniwaysAction<SelectedGridItemInfo>(){

            @Override
            public void call(SelectedGridItemInfo selectedGridItemInfo) {
                IAniwaysAssetInfo assetInfo = (IAniwaysAssetInfo)selectedGridItemInfo.getGridItem().getTag(R.id.aniways_asset_info_tag);
                if (assetInfo == null) {
                    Log.w(true, AniwaysContextualPopupGridView.TAG, "Selected item with no asset info. Probably because the info has not yet been loaded to the model, so doing nothing");
                    return;
                }
                EventAggregator.getInstance().notify(new ContextualItemSelectedByUserEvent(AniwaysContextualPopupGridView.this.popupCreationContext, selectedGridItemInfo, assetInfo));
            }
        };
    }

    protected abstract void initializeGridDimensions();

    protected abstract int getMaxGridItemsNumber(Phrase var1);

    protected abstract ImageView.ScaleType getImageScaleType();

    protected abstract PhraseAssetInfoExtractor getAssetInfoExtractor();
}

