/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.nineoldandroids.animation;

import com.aniways.nineoldandroids.animation.ValueAnimator;

public class TimeAnimator
extends ValueAnimator {
    private TimeListener mListener;
    private long mPreviousTime = -1L;

    @Override
    boolean animationFrame(long currentTime) {
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = currentTime;
            } else {
                this.mStartTime = currentTime - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        if (this.mListener != null) {
            long totalTime = currentTime - this.mStartTime;
            long deltaTime = this.mPreviousTime < 0L ? 0L : currentTime - this.mPreviousTime;
            this.mPreviousTime = currentTime;
            this.mListener.onTimeUpdate(this, totalTime, deltaTime);
        }
        return false;
    }

    public void setTimeListener(TimeListener listener) {
        this.mListener = listener;
    }

    @Override
    void animateValue(float fraction) {
    }

    @Override
    void initAnimation() {
    }

    public static interface TimeListener {
        public void onTimeUpdate(TimeAnimator var1, long var2, long var4);
    }
}

