/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.nineoldandroids.animation;

import android.util.Log;
import com.aniways.nineoldandroids.animation.FloatEvaluator;
import com.aniways.nineoldandroids.animation.FloatKeyframeSet;
import com.aniways.nineoldandroids.animation.IntEvaluator;
import com.aniways.nineoldandroids.animation.IntKeyframeSet;
import com.aniways.nineoldandroids.animation.Keyframe;
import com.aniways.nineoldandroids.animation.KeyframeSet;
import com.aniways.nineoldandroids.animation.TypeEvaluator;
import com.aniways.nineoldandroids.util.FloatProperty;
import com.aniways.nineoldandroids.util.IntProperty;
import com.aniways.nineoldandroids.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    String mPropertyName;
    protected Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class mValueType;
    KeyframeSet mKeyframeSet = null;
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static Class[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;

    private PropertyValuesHolder(String propertyName) {
        this.mPropertyName = propertyName;
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    public static PropertyValuesHolder ofInt(String propertyName, int ... values) {
        return new IntPropertyValuesHolder(propertyName, values);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... values) {
        return new IntPropertyValuesHolder(property, values);
    }

    public static PropertyValuesHolder ofFloat(String propertyName, float ... values) {
        return new FloatPropertyValuesHolder(propertyName, values);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... values) {
        return new FloatPropertyValuesHolder(property, values);
    }

    public static PropertyValuesHolder ofObject(String propertyName, TypeEvaluator evaluator, Object ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    public static PropertyValuesHolder ofKeyframe(String propertyName, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(propertyName, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(propertyName, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframeSet = keyframeSet;
        pvh.mValueType = values[0].getType();
        return pvh;
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(property, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(property, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframeSet = keyframeSet;
        pvh.mValueType = values[0].getType();
        return pvh;
    }

    public void setIntValues(int ... values) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(values);
    }

    public void setFloatValues(float ... values) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(values);
    }

    public void setKeyframes(Keyframe ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe[Math.max(numKeyframes, 2)];
        this.mValueType = values[0].getType();
        for (int i = 0; i < numKeyframes; ++i) {
            keyframes[i] = values[i];
        }
        this.mKeyframeSet = new KeyframeSet(keyframes);
    }

    public void setObjectValues(Object ... values) {
        this.mValueType = values[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(values);
    }

    private Method getPropertyFunction(Class targetClass, String prefix, Class valueType) {
        Method returnVal = null;
        String methodName = PropertyValuesHolder.getMethodName(prefix, this.mPropertyName);
        Class[] args = null;
        if (valueType == null) {
            try {
                returnVal = targetClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException e) {
                try {
                    returnVal = targetClass.getDeclaredMethod(methodName, args);
                    returnVal.setAccessible(true);
                }
                catch (NoSuchMethodException e2) {
                    Log.e((String)"PropertyValuesHolder", (String)("Couldn't find no-arg method for property " + this.mPropertyName + ": " + e));
                }
            }
        } else {
            args = new Class[1];
            Class[] typeVariants = this.mValueType.equals(Float.class) ? FLOAT_VARIANTS : (this.mValueType.equals(Integer.class) ? INTEGER_VARIANTS : (this.mValueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{this.mValueType}));
            Class[] classArray = typeVariants;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class typeVariant;
                args[0] = typeVariant = classArray[i];
                try {
                    returnVal = targetClass.getMethod(methodName, args);
                    this.mValueType = typeVariant;
                    return returnVal;
                }
                catch (NoSuchMethodException e) {
                    try {
                        returnVal = targetClass.getDeclaredMethod(methodName, args);
                        returnVal.setAccessible(true);
                        this.mValueType = typeVariant;
                        return returnVal;
                    }
                    catch (NoSuchMethodException e2) {
                        continue;
                    }
                }
            }
            Log.e((String)"PropertyValuesHolder", (String)("Couldn't find setter/getter for property " + this.mPropertyName + " with value type " + this.mValueType));
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method setupSetterOrGetter(Class targetClass, HashMap<Class, HashMap<String, Method>> propertyMapMap, String prefix, Class valueType) {
        Method setterOrGetter = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> propertyMap = propertyMapMap.get(targetClass);
            if (propertyMap != null) {
                setterOrGetter = propertyMap.get(this.mPropertyName);
            }
            if (setterOrGetter == null) {
                setterOrGetter = this.getPropertyFunction(targetClass, prefix, valueType);
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                    propertyMapMap.put(targetClass, propertyMap);
                }
                propertyMap.put(this.mPropertyName, setterOrGetter);
            }
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
        return setterOrGetter;
    }

    void setupSetter(Class targetClass) {
        this.mSetter = this.setupSetterOrGetter(targetClass, sSetterPropertyMap, "set", this.mValueType);
    }

    private void setupGetter(Class targetClass) {
        this.mGetter = this.setupSetterOrGetter(targetClass, sGetterPropertyMap, "get", null);
    }

    void setupSetterAndGetter(Object target) {
        if (this.mProperty != null) {
            try {
                Object testValue = this.mProperty.get(target);
                for (Keyframe kf : this.mKeyframeSet.mKeyframes) {
                    if (kf.hasValue()) continue;
                    kf.setValue(this.mProperty.get(target));
                }
                return;
            }
            catch (ClassCastException e) {
                Log.e((String)"PropertyValuesHolder", (String)("No such property (" + this.mProperty.getName() + ") on target object " + target + ". Trying reflection instead"));
                this.mProperty = null;
            }
        }
        Class<?> targetClass = target.getClass();
        if (this.mSetter == null) {
            this.setupSetter(targetClass);
        }
        for (Keyframe kf : this.mKeyframeSet.mKeyframes) {
            if (kf.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter(targetClass);
            }
            try {
                kf.setValue(this.mGetter.invoke(target, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
        }
    }

    private void setupValue(Object target, Keyframe kf) {
        if (this.mProperty != null) {
            kf.setValue(this.mProperty.get(target));
        }
        try {
            if (this.mGetter == null) {
                Class<?> targetClass = target.getClass();
                this.setupGetter(targetClass);
            }
            kf.setValue(this.mGetter.invoke(target, new Object[0]));
        }
        catch (InvocationTargetException e) {
            Log.e((String)"PropertyValuesHolder", (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)"PropertyValuesHolder", (String)e.toString());
        }
    }

    void setupStartValue(Object target) {
        this.setupValue(target, this.mKeyframeSet.mKeyframes.get(0));
    }

    void setupEndValue(Object target) {
        this.setupValue(target, this.mKeyframeSet.mKeyframes.get(this.mKeyframeSet.mKeyframes.size() - 1));
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mPropertyName = this.mPropertyName;
            newPVH.mProperty = this.mProperty;
            newPVH.mKeyframeSet = this.mKeyframeSet.clone();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void setAnimatedValue(Object target) {
        if (this.mProperty != null) {
            this.mProperty.set(target, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
        }
    }

    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframeSet.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframeSet.setEvaluator(evaluator);
    }

    void calculateValue(float fraction) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(fraction);
    }

    public void setPropertyName(String propertyName) {
        this.mPropertyName = propertyName;
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframeSet.toString();
    }

    static String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private FloatProperty mFloatProperty;
        FloatKeyframeSet mFloatKeyframeSet;
        float mFloatAnimatedValue;

        public FloatPropertyValuesHolder(String propertyName, FloatKeyframeSet keyframeSet) {
            super(propertyName);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        public FloatPropertyValuesHolder(Property property, FloatKeyframeSet keyframeSet) {
            super(property);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(String propertyName, float ... values) {
            super(propertyName);
            this.setFloatValues(values);
        }

        public FloatPropertyValuesHolder(Property property, float ... values) {
            super(property);
            this.setFloatValues(values);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        @Override
        public void setFloatValues(float ... values) {
            super.setFloatValues(values);
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void calculateValue(float fraction) {
            this.mFloatAnimatedValue = this.mFloatKeyframeSet.getFloatValue(fraction);
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder newPVH = (FloatPropertyValuesHolder)super.clone();
            newPVH.mFloatKeyframeSet = (FloatKeyframeSet)newPVH.mKeyframeSet;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(target, this.mFloatAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }

        @Override
        void setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(targetClass);
        }
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private IntProperty mIntProperty;
        IntKeyframeSet mIntKeyframeSet;
        int mIntAnimatedValue;

        public IntPropertyValuesHolder(String propertyName, IntKeyframeSet keyframeSet) {
            super(propertyName);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        public IntPropertyValuesHolder(Property property, IntKeyframeSet keyframeSet) {
            super(property);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(String propertyName, int ... values) {
            super(propertyName);
            this.setIntValues(values);
        }

        public IntPropertyValuesHolder(Property property, int ... values) {
            super(property);
            this.setIntValues(values);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        @Override
        public void setIntValues(int ... values) {
            super.setIntValues(values);
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void calculateValue(float fraction) {
            this.mIntAnimatedValue = this.mIntKeyframeSet.getIntValue(fraction);
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder newPVH = (IntPropertyValuesHolder)super.clone();
            newPVH.mIntKeyframeSet = (IntKeyframeSet)newPVH.mKeyframeSet;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }

        @Override
        void setupSetter(Class targetClass) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(targetClass);
        }
    }
}

