/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.annotation.SuppressLint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.emoticons.button.EmoticonsButtonIconClickContext;
import com.aniways.emoticons.button.EmoticonsOnDemandPagerAdapterBase;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

public class EmoticonsPagerAdapterWithTable
extends EmoticonsOnDemandPagerAdapterBase {
    public static final int MAX_ITEMS_PER_PAGE = 8;
    public static final int MAX_ITEMS_PER_PAGE_SMALL_ICONS = 18;
    public static final int MAX_ITEMS_PER_PAGE_SMALLER_ICONS = 40;
    private String TAG = "AniwaysEmoticonsPagerAdapterWithTable";
    private int NO_OF_ROWS = 0;
    private int NO_OF_CELLS_IN_ROW = 0;
    private int NO_OF_EMOTICONS_PER_PAGE = this.NO_OF_ROWS * this.NO_OF_CELLS_IN_ROW;
    private List<IconData> mEmoticons;
    private AniwaysLockedIconHelper mLockedIconHelper;
    private String mFamilyName;
    private String mCategoryName;
    private boolean mIsRecentsTab;
    private int mNumberOfGeniousIcons;

    @SuppressLint(value={"UseSparseArrays"})
    public EmoticonsPagerAdapterWithTable(List<IconData> emoticons, AniwaysLockedIconHelper lockedIconHelper, int assetCode, String categoryName, int categoryPage, String familyName, int familyPage, boolean isRecentsTab, int numberOfGeniousIcons, EmoticonsOnDemandPagerAdapterBase parent) {
        super("AniwaysEmoticonsPagerAdapterWithTable-" + assetCode + "-" + categoryPage + "-" + familyPage, EmoticonsOnDemandPagerAdapterBase.AdapterType.Table, assetCode, categoryPage, familyPage, parent, familyPage);
        this.TAG = this.TAG + "-" + assetCode + "-" + categoryPage + "-" + familyPage;
        this.mEmoticons = emoticons;
        this.mLockedIconHelper = lockedIconHelper;
        this.mFamilyName = familyName;
        this.mCategoryName = categoryName;
        this.mIsRecentsTab = isRecentsTab;
        this.mNumberOfGeniousIcons = numberOfGeniousIcons;
        LayoutInflater inflater = (LayoutInflater)lockedIconHelper.getContext().getSystemService("layout_inflater");
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        int layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table;
        if (assetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup) {
            layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table_smaller_icons;
        } else if (config.useSmallerIconsInIconsOnDemendPopup) {
            layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table_small_icons;
        }
        TableLayout table = (TableLayout)inflater.inflate(layout2, null);
        this.NO_OF_ROWS = table.getChildCount();
        this.NO_OF_CELLS_IN_ROW = ((TableRow)table.getChildAt(0)).getChildCount();
        this.NO_OF_EMOTICONS_PER_PAGE = this.NO_OF_ROWS * this.NO_OF_CELLS_IN_ROW;
    }

    public static int getMaxItemsPerPage(int assetCode) {
        int retMaxItems = 8;
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if (assetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup) {
            retMaxItems = 18;
        } else if (config.useSmallerIconsInIconsOnDemendPopup) {
            retMaxItems = 40;
        }
        return retMaxItems;
    }

    public int getCount() {
        try {
            return this.mEmoticons == null ? 0 : (this.mAssetCode != AssetType.Emoji.getAssetCode() ? 1 : (int)Math.ceil((double)this.mEmoticons.size() / (double)this.NO_OF_EMOTICONS_PER_PAGE));
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in getCount", ex);
            return 0;
        }
    }

    @Override
    protected View instantiateItem(View collection) {
        try {
            LayoutInflater inflater = (LayoutInflater)collection.getContext().getSystemService("layout_inflater");
            AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
            int layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table;
            if (this.mAssetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup) {
                layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table_smaller_icons;
            } else if (config.useSmallerIconsInIconsOnDemendPopup) {
                layout2 = R.layout.aniways_emoticons_button_popup_emoticons_table_small_icons;
            }
            return inflater.inflate(layout2, null);
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in instatiateItem", ex);
            return null;
        }
    }

    @Override
    protected void onHolderCreated(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
            this.clearLockImagesFromAllCells(holder);
        }
        super.onHolderCreated(holder);
    }

    @Override
    protected void instantiateItemInternal(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        int i;
        if (holder.instantiated && !holder.iconsCleared) {
            for (NetworkImageView iv : holder.images) {
                if (!(iv.getDrawable() instanceof GifDrawable)) continue;
                ((GifDrawable)iv.getDrawable()).start();
            }
            return;
        }
        TableLayout table = (TableLayout)holder.view;
        int initialPosition = holder.position * this.NO_OF_EMOTICONS_PER_PAGE;
        ArrayList<IconData> emoticonsInAPage = new ArrayList<IconData>();
        if (this.mEmoticons != null) {
            for (i = initialPosition; i < initialPosition + this.NO_OF_EMOTICONS_PER_PAGE && i < this.mEmoticons.size(); ++i) {
                emoticonsInAPage.add(this.mEmoticons.get(i));
            }
        }
        for (i = emoticonsInAPage.size(); i < this.NO_OF_EMOTICONS_PER_PAGE; ++i) {
            emoticonsInAPage.add(null);
        }
        holder.images = new ArrayList();
        for (i = 0; i < this.NO_OF_ROWS; ++i) {
            TableRow row = (TableRow)table.getChildAt(i);
            for (int j = 0; j < this.NO_OF_CELLS_IN_ROW; ++j) {
                int position = i * this.NO_OF_CELLS_IN_ROW + j;
                this.setupCell((IconData)emoticonsInAPage.get(position), row.getChildAt(j), holder, position, (IconData)emoticonsInAPage.get(0));
            }
        }
        holder.instantiated = true;
        holder.iconsCleared = false;
    }

    @Override
    protected void recycleBitmapsInPosition(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        for (NetworkImageView imageView : holder.images) {
            if (imageView == null) continue;
            imageView.recycle(true, true, false);
            imageView.unregisterPreviousListeners();
            Log.v(this.TAG, "recycled image");
        }
        holder.images.clear();
        this.clearLockImagesFromAllCells(holder);
    }

    @Override
    protected void regenerateItem(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        if (holder == null) {
            Log.e(true, this.TAG, "Trying to regenerate a null holder");
            return;
        }
        this.instantiateItemInternal(holder);
    }

    private void setupCell(final IconData icon, View cell, final EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder, final int position, IconData firstIconInTable) {
        String path;
        final ImageView lock = (ImageView)cell.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
        final NetworkImageView image = (NetworkImageView)cell.findViewById(R.id.aniways_ebp_emoticons_item_emoticon);
        String string2 = path = icon == null ? null : icon.getFileName();
        if (path == null) {
            String pathOfFirstIconInTable;
            lock.setVisibility(8);
            String string3 = pathOfFirstIconInTable = firstIconInTable == null ? null : firstIconInTable.getFileName();
            if (pathOfFirstIconInTable == null) {
                Log.e(true, this.TAG, "First icon in table's path is null: " + (firstIconInTable == null ? null : Integer.valueOf(firstIconInTable.id)));
                image.setImageDrawable(null);
                holder.images.add(null);
                image.setVisibility(4);
                return;
            }
            image.unregisterPreviousListeners();
            image.registerResponseListener(new IResponseListener(){

                @Override
                public void onSuccess() {
                    try {
                        holder.images.add(image);
                        image.setVisibility(4);
                    }
                    catch (Throwable t) {
                        Log.e(true, EmoticonsPagerAdapterWithTable.this.TAG, "Exception in IResponseListener onSuccess", t);
                    }
                }

                @Override
                public void onError() {
                }
            });
            AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
            image.setImageUrl(config.getIconUrl(firstIconInTable, false, false), firstIconInTable, Volley.getImageLoader(), config.getMaxWidthForCache(firstIconInTable), config.getMaxHeightForCache(firstIconInTable), false);
            return;
        }
        image.unregisterPreviousListeners();
        image.registerResponseListener(new OnDemandResponseListener(holder, icon, image, lock));
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        image.setImageUrl(config.getIconUrl(icon, false, false), icon, Volley.getImageLoader(), config.getMaxWidthForCache(icon), config.getMaxHeightForCache(icon), false);
        cell.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    int iconNumber = EmoticonsPagerAdapterWithTable.this.NO_OF_EMOTICONS_PER_PAGE * holder.position + position;
                    boolean isGeniousIcon = EmoticonsPagerAdapterWithTable.this.mIsRecentsTab && iconNumber < EmoticonsPagerAdapterWithTable.this.mNumberOfGeniousIcons;
                    int row = position / EmoticonsPagerAdapterWithTable.this.NO_OF_CELLS_IN_ROW + 1;
                    int column = position % EmoticonsPagerAdapterWithTable.this.NO_OF_CELLS_IN_ROW + 1;
                    EmoticonsPagerAdapterWithTable.this.mLockedIconHelper.onIconClicked(image, lock, icon, new EmoticonsButtonIconClickContext(icon, EmoticonsPagerAdapterWithTable.this.mIsRecentsTab, isGeniousIcon, EmoticonsPagerAdapterWithTable.this.mCategoryName, EmoticonsPagerAdapterWithTable.this.mCategoryPage, EmoticonsPagerAdapterWithTable.this.mFamilyName, EmoticonsPagerAdapterWithTable.this.mFamilyPage, holder.position, position + 1, EmoticonsPagerAdapterWithTable.this.NO_OF_EMOTICONS_PER_PAGE, row, column, EmoticonsPagerAdapterWithTable.this.NO_OF_ROWS, EmoticonsPagerAdapterWithTable.this.NO_OF_CELLS_IN_ROW));
                    Log.i(EmoticonsPagerAdapterWithTable.this.TAG, "Clicked on table item in position: " + position);
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonsPagerAdapterWithTable.this.TAG, "Caught excedption in onItemClick. Pos is: " + position, ex);
                }
            }
        });
    }

    private void clearLockImagesFromAllCells(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        if (holder.iconsCleared) {
            return;
        }
        TableLayout table = (TableLayout)holder.view;
        for (int i = 0; i < this.NO_OF_ROWS; ++i) {
            TableRow row = (TableRow)table.getChildAt(i);
            for (int j = 0; j < this.NO_OF_CELLS_IN_ROW; ++j) {
                View cell = row.getChildAt(j);
                ImageView lock = (ImageView)cell.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
                lock.setVisibility(8);
            }
        }
        holder.iconsCleared = true;
    }

    private final class OnDemandResponseListener
    implements IResponseListener {
        private final EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder;
        private final IconData icon;
        private NetworkImageView image;
        private final ImageView lock;

        private OnDemandResponseListener(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder, IconData icon, NetworkImageView image, ImageView lock) {
            this.holder = holder;
            this.icon = icon;
            this.image = image;
            this.lock = lock;
        }

        @Override
        public void onSuccess() {
            try {
                if (EmoticonsPagerAdapterWithTable.this.isVisible(this.holder.position)) {
                    this.image.startAnimation();
                    this.startFadeInAnimation(this.image);
                    this.holder.images.add(this.image);
                    EmoticonsPagerAdapterWithTable.this.mLockedIconHelper.setIconAndLockVisibility(this.image, this.lock, this.icon);
                } else if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
                    if (this.image != null) {
                        this.image.recycle(true, true, false);
                        this.image.unregisterPreviousListeners();
                        this.image = null;
                    } else {
                        Log.e(true, EmoticonsPagerAdapterWithTable.this.TAG, "image is null");
                    }
                } else {
                    this.holder.images.add(this.image);
                    EmoticonsPagerAdapterWithTable.this.mLockedIconHelper.setIconAndLockVisibility(this.image, this.lock, this.icon);
                }
            }
            catch (Throwable t) {
                Log.e(true, EmoticonsPagerAdapterWithTable.this.TAG, "Exception in OnDemandResponseListener onSuccess", t);
            }
        }

        @SuppressLint(value={"NewApi"})
        private void startFadeInAnimation(NetworkImageView image) {
            if (Utils.isAndroidVersionAtLeast(11)) {
                image.setAlpha(1.0f);
            } else {
                image.setAlpha(255);
            }
            AlphaAnimation fadeInAnimation = new AlphaAnimation(0.0f, 1.0f);
            fadeInAnimation.setDuration(1200L);
            fadeInAnimation.setStartOffset(0L);
            fadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
            image.startAnimation((Animation)fadeInAnimation);
        }

        @Override
        public void onError() {
            Log.e(false, EmoticonsPagerAdapterWithTable.this.TAG, "OnDemandResponseListener onError called");
        }
    }
}

