/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.support.v4.view.AniwaysDirectionalViewPager;
import android.view.LayoutInflater;
import android.view.View;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import com.aniways.emoticons.button.EmoticonsOnDemandPagerAdapterBase;
import com.aniways.emoticons.button.EmoticonsPagerAdapterWithTable;
import com.aniways.viewpagerindicator.CirclePageIndicator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class EmoticonFamiliesPagerAdapter
extends EmoticonsOnDemandPagerAdapterBase {
    private String TAG = "AniwaysEmoticonFamiliesPagerAdapter";
    private HashMap<String, List<IconData>> mFamiliesToIcons;
    private String[] mIconFamilies;
    private AniwaysLockedIconHelper mLockedIconHelper;
    private String mCategoryName;
    private AniwaysEmoticonsButtonMaker.LastPagesLocation mLastPagesLocation;
    private boolean mIsRecentsTab;
    private int mNumberOfGeniousIcons;

    public EmoticonFamiliesPagerAdapter(HashMap<String, List<IconData>> familiesToIcons, int assetCode, String categoryName, int categoryPage, AniwaysLockedIconHelper lockedIconHelper, boolean isRecentsTab, int numberOfGeniousIcons, AniwaysEmoticonsButtonMaker.LastPagesLocation lastPagesLocation, EmoticonsOnDemandPagerAdapterBase parent) {
        super("AniwaysEmoticonFamiliesPagerAdapter-" + assetCode + "-" + categoryPage, EmoticonsOnDemandPagerAdapterBase.AdapterType.Family, assetCode, categoryPage, 0, parent, categoryPage);
        try {
            this.TAG = this.TAG + "-" + assetCode + "-" + categoryPage;
            this.mCategoryName = categoryName;
            this.mIsRecentsTab = isRecentsTab;
            this.mNumberOfGeniousIcons = numberOfGeniousIcons;
            this.mLockedIconHelper = lockedIconHelper;
            this.mLastPagesLocation = lastPagesLocation;
            this.mFamiliesToIcons = familiesToIcons;
            if (familiesToIcons.keySet().isEmpty() && !categoryName.equalsIgnoreCase("Recent")) {
                Log.e(true, this.TAG, "No Icon families in category: " + categoryName);
                this.mIconFamilies = null;
            } else {
                this.mIconFamilies = new String[familiesToIcons.keySet().size()];
                familiesToIcons.keySet().toArray(this.mIconFamilies);
            }
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in constructor", ex);
        }
    }

    public CharSequence getPageTitle(int position) {
        try {
            if (this.mIconFamilies == null) {
                return "EMPTY";
            }
            return this.mIconFamilies[position % this.mIconFamilies.length].toUpperCase(Locale.getDefault());
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in getPageTitle", ex);
            return "EMPTY";
        }
    }

    public int getCount() {
        return this.mIconFamilies == null ? 0 : this.mIconFamilies.length;
    }

    @Override
    protected View instantiateItem(View collection) {
        try {
            LayoutInflater inflater = (LayoutInflater)collection.getContext().getSystemService("layout_inflater");
            return inflater.inflate(R.layout.aniways_emoticons_button_popup_icons_pager, null);
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in instantiateItem", ex);
            return null;
        }
    }

    @Override
    protected void instantiateItemInternal(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        View layout2 = holder.view;
        String iconFamily = this.mIconFamilies == null ? "EMPTY" : this.mIconFamilies[holder.position];
        List<IconData> emoticons = null;
        if (this.mIconFamilies != null) {
            emoticons = this.mFamiliesToIcons.get(iconFamily);
        }
        AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager)layout2.findViewById(R.id.aniways_ebp_icons_pager);
        pager.setOffscreenPageLimit(1);
        holder.pager = pager;
        EmoticonsPagerAdapterWithTable adapter = new EmoticonsPagerAdapterWithTable(emoticons, this.mLockedIconHelper, this.mAssetCode, this.mCategoryName, this.mCategoryPage, iconFamily, holder.position, this.mIsRecentsTab, this.mNumberOfGeniousIcons, this);
        pager.setAdapter(adapter);
        CirclePageIndicator indicator = (CirclePageIndicator)layout2.findViewById(R.id.aniways_ebp_icons_pager_indicator);
        indicator.setViewPager(pager);
        if (adapter.getCount() == 1) {
            indicator.setVisibility(8);
        }
        AniwaysDirectionalViewPager.OnPageChangeListener pageChangeListener = new AniwaysDirectionalViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int arg0) {
            }

            @Override
            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            @Override
            public void onPageSelected(int pageNumber) {
                try {
                    Log.i(EmoticonFamiliesPagerAdapter.this.TAG, "Selected table num: " + pageNumber);
                    EmoticonFamiliesPagerAdapter.this.mLastPagesLocation.setTableNumber(pageNumber);
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonFamiliesPagerAdapter.this.TAG, "Caught Exception in onPageSelected", ex);
                }
            }
        };
        indicator.setOnPageChangeListener(pageChangeListener);
        if (this.mLastPagesLocation.getSelectedAssetType().getAssetCode() == this.mAssetCode && this.mLastPagesLocation.getCategoryPage() == this.mCategoryPage && this.mLastPagesLocation.getFamilyPage() == holder.position) {
            indicator.setCurrentItem(this.mLastPagesLocation.getTableNumber());
        }
        holder.instantiated = true;
    }
}

