/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import com.aniways.Aniways;
import com.aniways.AniwaysEditText;
import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.utils.ContextualEventData;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.emoticons.button.AniwaysRecentIconsManager;
import com.aniways.emoticons.button.EmoticonAssetsPagerAdapter;
import com.aniways.emoticons.button.EmoticonsButtonIconClickContext;
import com.aniways.viewpagerindicator.PageIndicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AniwaysEmoticonsButtonMaker
implements AniwaysLockedIconHelper.OnStoreAboutToLaunchListener {
    private static final String TAG = "AniwaysEmoticonsButtonMaker";
    private static HashSet<PopupWindow> sOpenedPopups;
    private View mButton;
    private JsonParser mParser;
    private LastPagesLocation mLastPagesLocation;
    private View popUpView;
    private LinearLayout emoticonsPlaceholder;
    private PopupWindow popupWindow;
    private int keyboardHeightPortrait;
    private int keyboardHeightLandscape;
    private AniwaysEditText mEditText;
    private EmoticonAssetsPagerAdapter mPagerAdapter;
    private boolean isKeyBoardVisible;
    private int previousHeightDiffrence = 0;
    private int mNumberOfEmoticonsPicked = 0;
    private Context mContext;
    private long mTimeOfLastEventThatClosedThePopup = -3L;
    private long mTimeOfLastDownEventOnEmoticonsButton = -4L;
    protected long mStartUserInPopupTime;
    private ViewGroup mParentLayout;
    private Aniways.OnAniwaysEmoticonsKeyboardListener mStateChangeListener;
    private boolean mUsePadding;
    int estimatedKeyboardHeight;
    private int deltaFromOpenedKeyboardPortrait;
    private int deltaFromOpenedKeyboardLandscape;
    private int previousOrientation;

    @SuppressLint(value={"InflateParams"})
    public boolean makeButtonAniwaysEmoticonsButton(View button, LinearLayout aniwaysEmoticonsButtonPlaceholder, ViewGroup parentLayout, AniwaysEditText editText, Aniways.OnAniwaysEmoticonsKeyboardListener listener, boolean usePadding) {
        try {
            Log.i(TAG, "Making Aniways Emoticons Button");
            if (button == null) {
                Log.w(false, TAG, "There is no button yet in the parent layout, so not setting up anything");
                return false;
            }
            if (editText == null) {
                Log.w(false, TAG, "There is no AniwaysEditText yet to attach to the emoticons on demand button, so icons that are picked will not go anywere..");
            }
            this.mEditText = editText;
            this.mParentLayout = parentLayout;
            this.mContext = this.mParentLayout.getContext();
            this.mButton = button;
            this.mStateChangeListener = listener;
            this.mUsePadding = usePadding;
            this.emoticonsPlaceholder = aniwaysEmoticonsButtonPlaceholder;
            this.popUpView = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(R.layout.aniways_emoticons_button_popup, null);
            DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
            this.estimatedKeyboardHeight = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)metrics);
            this.setupEmoticonsButton(button, this.mParentLayout);
            this.changeKeyboardHeight(2, (int)this.mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_landscape));
            this.changeKeyboardHeight(1, (int)this.mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_portrait));
            this.setupKeyboardHeightUpdater((View)this.mParentLayout);
            return aniwaysEmoticonsButtonPlaceholder != null && editText != null;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caought Exception which making an Aniways Emoticons Button", ex);
            return false;
        }
    }

    private void setupEmoticonsButton(View button, final ViewGroup parentLayout) {
        this.setButtonImage(EmoticonsButtonImageType.Smiley);
        button.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                try {
                    if (event.getAction() == 0) {
                        Log.i(AniwaysEmoticonsButtonMaker.TAG, "Time of last event on emoticons button: " + AniwaysEmoticonsButtonMaker.this.mTimeOfLastDownEventOnEmoticonsButton);
                        AniwaysEmoticonsButtonMaker.this.mTimeOfLastDownEventOnEmoticonsButton = event.getEventTime();
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in onTouch of Emoticons button", ex);
                }
                return false;
            }
        });
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    AniwaysBackendSyncChecker.requestSyncWithServerIfNecessary();
                    if (AniwaysEmoticonsButtonMaker.this.popupWindow != null && AniwaysEmoticonsButtonMaker.this.popupWindow.isShowing()) {
                        AniwaysEmoticonsButtonMaker.this.popupWindow.dismiss();
                    } else {
                        Log.i(AniwaysEmoticonsButtonMaker.TAG, "(Time of event that closed popup" + AniwaysEmoticonsButtonMaker.this.mTimeOfLastEventThatClosedThePopup + ". Time of last event on emoticons button: " + AniwaysEmoticonsButtonMaker.this.mTimeOfLastDownEventOnEmoticonsButton);
                        if (AniwaysEmoticonsButtonMaker.this.mTimeOfLastEventThatClosedThePopup == AniwaysEmoticonsButtonMaker.this.mTimeOfLastDownEventOnEmoticonsButton) {
                            Log.i(AniwaysEmoticonsButtonMaker.TAG, "detected click on emoticons button that was the click that closed the popup, so not opening the popup again");
                            return;
                        }
                        AniwaysEmoticonsButtonMaker.this.previousOrientation = ((AniwaysEmoticonsButtonMaker)AniwaysEmoticonsButtonMaker.this).mContext.getResources().getConfiguration().orientation;
                        AniwaysEmoticonsButtonMaker.this.mParser = AniwaysPhraseReplacementData.getDataParser();
                        if (AniwaysEmoticonsButtonMaker.this.mLastPagesLocation == null || !AniwaysEmoticonsButtonMaker.this.mLastPagesLocation.isInstanceRelevantForParser(AniwaysEmoticonsButtonMaker.this.mParser)) {
                            AniwaysEmoticonsButtonMaker.this.mLastPagesLocation = new LastPagesLocation(AniwaysEmoticonsButtonMaker.this.mParser);
                        }
                        if (Utils.compareVersionStrings((String)((AniwaysEmoticonsButtonMaker)AniwaysEmoticonsButtonMaker.this).mParser.getKeywordsVersion(), (String)"2.6").result < 0) {
                            Log.i(AniwaysEmoticonsButtonMaker.TAG, "Not showing Emoticons button content because the keywords version is not 2.6 or above. Version is: " + AniwaysEmoticonsButtonMaker.this.mParser.getKeywordsVersion());
                            Toast.makeText((Context)AniwaysEmoticonsButtonMaker.this.mContext, (CharSequence)"The button will be available in a few seconds", (int)1).show();
                            return;
                        }
                        long startTime = System.currentTimeMillis();
                        List iconsForGenious = AniwaysEmoticonsButtonMaker.this.getIconsForGeniousMode();
                        AniwaysEmoticonsButtonMaker.this.setupPopUpView(iconsForGenious);
                        AniwaysEmoticonsButtonMaker.this.mNumberOfEmoticonsPicked = 0;
                        AniwaysEmoticonsButtonMaker.this.mStartUserInPopupTime = System.currentTimeMillis();
                        if (sOpenedPopups == null) {
                            sOpenedPopups = new HashSet();
                        }
                        sOpenedPopups.add(AniwaysEmoticonsButtonMaker.this.popupWindow);
                        AniwaysEmoticonsButtonMaker.this.popupWindow.showAtLocation((View)parentLayout, 80, 0, 0);
                        if (AniwaysEmoticonsButtonMaker.this.mStateChangeListener != null) {
                            AniwaysEmoticonsButtonMaker.this.mStateChangeListener.onShow();
                        }
                        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "Display Emoticons Button", "", AniwaysEmoticonsButtonMaker.TAG, "");
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in onClick of Emoticons button", ex);
                }
            }
        });
    }

    private void setupKeyboardHeightUpdater(final View parentLayout) {
        final Rect r = new Rect();
        parentLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                try {
                    parentLayout.getWindowVisibleDisplayFrame(r);
                    Log.d(AniwaysEmoticonsButtonMaker.TAG, "On Global layout");
                    int screenHeight = ((AniwaysEmoticonsButtonMaker)AniwaysEmoticonsButtonMaker.this).mContext.getResources().getDisplayMetrics().heightPixels;
                    int heightDifference = screenHeight - r.bottom;
                    int orientation = ((AniwaysEmoticonsButtonMaker)AniwaysEmoticonsButtonMaker.this).mContext.getResources().getConfiguration().orientation;
                    if (AniwaysEmoticonsButtonMaker.this.previousOrientation != orientation && AniwaysEmoticonsButtonMaker.this.popupWindow != null && AniwaysEmoticonsButtonMaker.this.popupWindow.isShowing()) {
                        AniwaysEmoticonsButtonMaker.this.popupWindow.dismiss();
                        AniwaysEmoticonsButtonMaker.this.mButton.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                AniwaysEmoticonsButtonMaker.this.mButton.performClick();
                            }
                        }, 100L);
                        return;
                    }
                    if (AniwaysEmoticonsButtonMaker.this.previousHeightDiffrence != heightDifference) {
                        AniwaysEmoticonsButtonMaker.this.previousHeightDiffrence = heightDifference;
                        if (heightDifference > AniwaysEmoticonsButtonMaker.this.estimatedKeyboardHeight) {
                            AniwaysEmoticonsButtonMaker.this.isKeyBoardVisible = true;
                            AniwaysEmoticonsButtonMaker.this.changeKeyboardHeight(((AniwaysEmoticonsButtonMaker)AniwaysEmoticonsButtonMaker.this).mButton.getResources().getConfiguration().orientation, heightDifference);
                            AniwaysEmoticonsButtonMaker.this.makePlaceholderInvisible(AniwaysEmoticonsButtonMaker.this.popupWindow != null && AniwaysEmoticonsButtonMaker.this.popupWindow.isShowing());
                        } else {
                            AniwaysEmoticonsButtonMaker.this.isKeyBoardVisible = false;
                            if (AniwaysEmoticonsButtonMaker.this.popupWindow != null && AniwaysEmoticonsButtonMaker.this.popupWindow.isShowing()) {
                                AniwaysEmoticonsButtonMaker.this.makePlaceholderVisible();
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in OnGlobalLayoutListener", ex);
                }
            }
        });
    }

    private void changeKeyboardHeight(int orientation, int height) {
        if (height > 100) {
            int minHeight;
            Log.i(TAG, "Changing keyboard height to: " + height + " . Orientation: " + orientation);
            int delta = 0;
            if (orientation == 2) {
                this.keyboardHeightLandscape = height;
                minHeight = (int)this.mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_landscape);
                delta = this.deltaFromOpenedKeyboardLandscape = Math.max(0, minHeight - height);
                Log.d(TAG, "Keyboard height is: " + height + ". Min height is: " + minHeight + ". Delta from keyboard height is: " + this.deltaFromOpenedKeyboardLandscape + ". Orientation: Landscape");
            } else if (orientation == 1) {
                this.keyboardHeightPortrait = height;
                minHeight = (int)this.mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_portrait);
                delta = this.deltaFromOpenedKeyboardPortrait = Math.max(0, minHeight - height);
                Log.d(TAG, "Keyboard height is: " + height + ". Min height is: " + minHeight + ". Delta from keyboard height is: " + this.deltaFromOpenedKeyboardPortrait + ". Orientation: Portrait");
            } else {
                Log.e(true, TAG, "Illegal orientation, treating like portrait: " + orientation);
                orientation = 1;
                this.changeKeyboardHeight(orientation, height);
                return;
            }
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, height + delta);
            if (this.emoticonsPlaceholder != null) {
                this.emoticonsPlaceholder.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    private void setupPopUpView(List<IconData> iconsForGenious) {
        if (iconsForGenious == null) {
            iconsForGenious = new ArrayList<IconData>();
        }
        int popupHeight = this.getKeyboardHeight() + this.getDelataFromKeyboard();
        Log.d(TAG, "Setting up popup with height: " + popupHeight);
        this.popupWindow = new PopupWindow(this.popUpView, -1, popupHeight, false);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mContext.getResources()));
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                try {
                    AniwaysEmoticonsButtonMaker.this.mTimeOfLastEventThatClosedThePopup = event.getEventTime();
                    Log.i(AniwaysEmoticonsButtonMaker.TAG, "(Time of event that closed popup (in touch interceptor): " + AniwaysEmoticonsButtonMaker.this.mTimeOfLastEventThatClosedThePopup);
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in onTouch of popup window touch interceptor", ex);
                }
                return false;
            }
        });
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                try {
                    Log.i(AniwaysEmoticonsButtonMaker.TAG, "Dismissing Aniways Emoticons button popup");
                    AniwaysEmoticonsButtonMaker.this.makePlaceholderInvisible(false);
                    if (sOpenedPopups != null) {
                        sOpenedPopups.remove(AniwaysEmoticonsButtonMaker.this.popupWindow);
                    }
                    if (AniwaysEmoticonsButtonMaker.this.mPagerAdapter != null && AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
                        AniwaysEmoticonsButtonMaker.this.mPagerAdapter.recycleAllBitmaps();
                    }
                    if (AniwaysEmoticonsButtonMaker.this.mStateChangeListener != null) {
                        AniwaysEmoticonsButtonMaker.this.mStateChangeListener.onHide();
                    }
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, AniwaysEmoticonsButtonMaker.this.mStartUserInPopupTime, "User Action", "Time User Spent In Emoticons Button", Integer.toString(AniwaysEmoticonsButtonMaker.this.mNumberOfEmoticonsPicked), AniwaysEmoticonsButtonMaker.TAG, "Number of emoticons picked");
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in onDismiss of popup window", ex);
                }
            }
        });
        AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener onItemContainingLockedIconClickListener = new AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener(){

            @Override
            public void onItemClick(Object iconClickContext) {
                EmoticonsButtonIconClickContext context = (EmoticonsButtonIconClickContext)iconClickContext;
                AniwaysEmoticonsButtonMaker.this.onEmoticonClicked(context);
            }
        };
        Button creditsBalanceButton = (Button)this.popUpView.findViewById(R.id.aniways_ebp_credits_balance);
        AniwaysLockedIconHelper lockedIconHelper = new AniwaysLockedIconHelper(this.mParser, onItemContainingLockedIconClickListener, null, (TextView)creditsBalanceButton, this.popupWindow, (View)this.mParentLayout, false, this.mContext, "IOD");
        AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager)this.popUpView.findViewById(R.id.aniways_ebp_icon_assets_pager);
        pager.setOffscreenPageLimit(1);
        this.mPagerAdapter = new EmoticonAssetsPagerAdapter(lockedIconHelper, this.mLastPagesLocation, pager.getContext(), iconsForGenious, this.mEditText);
        pager.setAdapter(this.mPagerAdapter);
        PageIndicator indicator = (PageIndicator)this.popUpView.findViewById(R.id.aniways_ebp_icon_assets_pager_indicator);
        indicator.setViewPager(pager);
        indicator.setOnPageChangeListener(new AniwaysDirectionalViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int arg0) {
            }

            @Override
            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            @Override
            public void onPageSelected(int assetCode) {
                try {
                    AniwaysEmoticonsButtonMaker.this.mLastPagesLocation.setSelectedAssetType(AssetType.getAssetType(assetCode));
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysEmoticonsButtonMaker.TAG, "Caught Exception in onPageSelected", ex);
                }
            }
        });
        indicator.setCurrentItem(this.mLastPagesLocation.getSelectedAssetType().getAssetCode());
        this.mLastPagesLocation.reportScreenViewEvent();
        this.popupWindow.setHeight(this.getKeyboardHeight() + this.getDelataFromKeyboard());
        if (this.isKeyBoardVisible) {
            this.makePlaceholderInvisible(true);
        } else {
            this.makePlaceholderVisible();
        }
    }

    public static boolean dismissAllOpenedButtonPopups() {
        boolean closedSomething;
        block6: {
            closedSomething = false;
            try {
                Log.d(TAG, "dismissing all Emoticon Button popups");
                if (sOpenedPopups == null) break block6;
                Log.d(TAG, "Closing opened popups");
                HashSet<PopupWindow> secondary = new HashSet<PopupWindow>(sOpenedPopups);
                for (PopupWindow popup : secondary) {
                    if (popup.isShowing()) {
                        try {
                            popup.dismiss();
                        }
                        catch (IllegalArgumentException ex) {
                            // empty catch block
                        }
                        closedSomething = true;
                        continue;
                    }
                    Log.w(true, TAG, "An opened emoticons button popup is not showing");
                }
            }
            catch (Exception e) {
                Log.w(true, TAG, "caught Exception while dismissing all opened emoticons button popups", e);
            }
        }
        return closedSomething;
    }

    public static boolean isEmoticonsButtonShowing() {
        try {
            if (sOpenedPopups != null) {
                for (PopupWindow popup : sOpenedPopups) {
                    if (popup.isShowing()) {
                        return true;
                    }
                    Log.w(true, TAG, "An opened emoticons button popup is not showing");
                }
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in isEmoticonsButtonShowing", ex);
        }
        return false;
    }

    private void onEmoticonClicked(EmoticonsButtonIconClickContext context) {
        Phrase phrase = context.icon.primaryPhrase;
        if (phrase == null) {
            Log.e(true, TAG, "There is no primary phrase for icon path: " + context.icon.getFileName());
            return;
        }
        if (this.mEditText != null) {
            int selectionStart = this.mEditText.getSelectionStart();
            int selectionEnd = this.mEditText.getSelectionEnd();
            this.mEditText.insetTextCoveredWithIcon(context.icon, selectionStart, selectionEnd, phrase, new IAniwaysImageSpan.ImageSpanMetadata(context.icon, IAniwaysImageSpan.IconSelectionOrigin.AniwaysKeyboard), true);
        }
        String fileName = context.icon.getFileName();
        if (context.isGeniousIcon) {
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Picked Icon in Emoticons button - genious - android", phrase.getPhraseSubPhraseString(), fileName, 0L);
        } else {
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Picked Icon in Emoticons button - android", context.tabName + "--" + context.familyName + "--" + context.pageNumber, fileName, 0L);
        }
        AnalyticsReporter.reportOnDemandIconSelectedlEvent(new ContextualEventData(AnalyticsReporter.PhrasesEventAction.selected, this.mEditText == null ? null : this.mEditText.getMessageId(), phrase, new IconData[]{context.icon}, AniwaysStoreManager.isIconUnlocked(context.icon), null, context.isGeniousIcon, context.tabName, context.tabNumber, context.tabNumber == 0 ? context.icon.family : context.familyName, context.familyNumber, context.pageNumber, context.position, context.outOf, context.row, context.column, context.numRows, context.numColumns, 0, null, null, new IAniwaysImageSpan.ImageSpanMetadata(context.icon, IAniwaysImageSpan.IconSelectionOrigin.AniwaysKeyboard), -1));
        AniwaysRecentIconsManager.addRecentIcon(context.icon.id, context.icon.assetType);
        if (!context.isFromRecentsTab) {
            this.mPagerAdapter.notifyDataSetChanged();
        }
        ++this.mNumberOfEmoticonsPicked;
    }

    @Override
    public void onStoreAboutToLaunch() {
    }

    @Override
    public void onStoreClosing() {
    }

    private void makePlaceholderVisible() {
        this.setButtonImage(EmoticonsButtonImageType.Collapse);
        if (this.emoticonsPlaceholder != null) {
            this.emoticonsPlaceholder.setVisibility(0);
        } else if (this.mUsePadding) {
            this.mParentLayout.setPadding(0, 0, 0, this.getKeyboardHeight() + this.getDelataFromKeyboard());
        } else {
            this.showSoftKeyboard();
        }
    }

    private void makePlaceholderInvisible(boolean isButtonOpened) {
        if (isButtonOpened) {
            this.setButtonImage(EmoticonsButtonImageType.Keyboard);
        } else {
            this.setButtonImage(EmoticonsButtonImageType.Smiley);
        }
        if (this.emoticonsPlaceholder != null) {
            this.emoticonsPlaceholder.setVisibility(8);
        } else if (this.mUsePadding) {
            this.mParentLayout.setPadding(0, 0, 0, isButtonOpened ? this.getDelataFromKeyboard() : 0);
        }
    }

    private int getOrientation() {
        int orientation = this.mButton.getResources().getConfiguration().orientation;
        if (orientation != 2 && orientation != 1) {
            orientation = 1;
            Log.e(true, TAG, "Illegal orientation, treating like portrait: " + orientation);
        }
        return orientation;
    }

    private int getDelataFromKeyboard() {
        return this.getOrientation() == 2 ? this.deltaFromOpenedKeyboardLandscape : this.deltaFromOpenedKeyboardPortrait;
    }

    private int getKeyboardHeight() {
        return this.getOrientation() == 2 ? this.keyboardHeightLandscape : this.keyboardHeightPortrait;
    }

    private void setButtonImage(EmoticonsButtonImageType type) {
        switch (type) {
            case Collapse: {
                this.setButtonResource(R.drawable.aniways_ebp_collapse_button);
                break;
            }
            case Keyboard: {
                this.setButtonResource(R.drawable.aniways_ebp_keyboard_button);
                break;
            }
            case Smiley: {
                this.setButtonResource(R.drawable.aniways_ebp_icons_button);
                break;
            }
            default: {
                Log.e(true, TAG, "Illegal button image type: " + (Object)((Object)type));
            }
        }
    }

    private void setButtonResource(int resource) {
        if (this.mButton instanceof ImageView) {
            ((ImageView)this.mButton).setImageResource(resource);
            ((ImageView)this.mButton).setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
    }

    private List<IconData> getIconsForGeniousMode() {
        ArrayList<IconData> iconsForGenious = new ArrayList<IconData>();
        if (this.mEditText == null) {
            return iconsForGenious;
        }
        ArrayList<AniwaysEditText.RecognizedPhrase> recognizedPhrases = this.mEditText.getRecognizedPhrases(false);
        if (recognizedPhrases != null && recognizedPhrases.size() > 0) {
            for (AniwaysEditText.RecognizedPhrase rp : recognizedPhrases) {
                IconData[] newIcons = rp.phrase.emoticonsPhraseAssetBuilder.icons;
                if (newIcons == null || newIcons.length <= 0) continue;
                iconsForGenious.addAll(Arrays.asList(newIcons));
            }
        }
        return iconsForGenious;
    }

    private void showSoftKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        imm.showSoftInput((View)this.mEditText, 0);
    }

    private static enum EmoticonsButtonImageType {
        Smiley,
        Keyboard,
        Collapse;

    }

    class LastPagesLocation {
        private int NO_RECENTS_CATEGORY_EXISTS = -1;
        private JsonParser parser;
        private int categoryPage;
        private int familyPage;
        private int tableNumber;
        private AssetType selectedAssetType;

        LastPagesLocation(JsonParser parser) {
            this.parser = parser;
            this.selectedAssetType = AssetType.Emoticons;
            this.categoryPage = this.getRecentCategoryPageByAssetType(this.selectedAssetType);
            this.familyPage = 0;
            this.tableNumber = 0;
        }

        boolean isInstanceRelevantForParser(JsonParser parser) {
            return this.parser.getKeywordsVersion().equalsIgnoreCase(parser.getKeywordsVersion());
        }

        boolean isCurrentCategoryTheRecentsCategory() {
            return this.getCategoryPage() == this.getRecentCategoryPageByAssetType(this.selectedAssetType);
        }

        AssetType getSelectedAssetType() {
            return this.selectedAssetType;
        }

        void setSelectedAssetType(AssetType assetType) {
            if (this.selectedAssetType != assetType) {
                this.selectedAssetType = assetType;
                this.categoryPage = this.getRecentCategoryPageByAssetType(this.selectedAssetType);
                this.familyPage = 0;
                this.tableNumber = 0;
                this.reportScreenViewEvent();
            }
        }

        int getCategoryPage() {
            return this.categoryPage;
        }

        void setCategoryPage(int categoryPage) {
            if (this.categoryPage != categoryPage) {
                this.categoryPage = categoryPage;
                this.familyPage = 0;
                this.tableNumber = 0;
                this.reportScreenViewEvent();
            }
        }

        public void reportScreenViewEvent() {
            AnalyticsReporter.reportIconsOnDemandScreenView(this.selectedAssetType, this.getCurrentCategoryName(), this.getCategoryPage(), this.getCurrentFamilyName(), this.getFamilyPage(), this.getTableNumber());
        }

        private String getCurrentFamilyName() {
            if (this.isCurrentCategoryTheRecentsCategory()) {
                return "default";
            }
            ArrayList<String> families = AniwaysEmoticonsButtonMaker.this.mParser.getFamiliesInOrderForSuperCategory(this.getSelectedAssetType(), this.getCurrentCategoryName());
            if (families.size() < 1) {
                return "Empty";
            }
            return families.get(this.getFamilyPage());
        }

        private String getCurrentCategoryName() {
            return AniwaysEmoticonsButtonMaker.this.mParser.getIconCategoriesInOrderByAssetType(this.selectedAssetType)[this.getCategoryPage()];
        }

        int getFamilyPage() {
            return this.familyPage;
        }

        void setFamilyPage(int familyPage) {
            if (this.getFamilyPage() != familyPage) {
                this.familyPage = familyPage;
                this.tableNumber = 0;
                this.reportScreenViewEvent();
            }
        }

        int getTableNumber() {
            return this.tableNumber;
        }

        void setTableNumber(int tableNumber) {
            if (this.getTableNumber() != tableNumber) {
                this.tableNumber = tableNumber;
                this.reportScreenViewEvent();
            }
        }

        private int getRecentCategoryPageByAssetType(AssetType assetType) {
            int retRecentsCategoryPageNum = this.NO_RECENTS_CATEGORY_EXISTS;
            String[] categories = this.parser.getIconCategoriesInOrderByAssetType(assetType);
            if (categories != null) {
                for (int i = 0; i < categories.length; ++i) {
                    String category = categories[i];
                    if (!category.equalsIgnoreCase("Recent")) continue;
                    retRecentsCategoryPageNum = i;
                    break;
                }
            }
            return retRecentsCategoryPageNum;
        }
    }
}

