/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.support.annotation.NonNull;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IAssetInfoBuilder;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.volley.Response;
import com.aniways.volley.VolleyError;
import com.aniways.volley.toolbox.JsonObjectRequest;
import com.aniways.volley.toolbox.Volley;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public abstract class WebAssetInfoBuilderBase
implements IAssetInfoBuilder {
    private final String builderName;
    private List<IAniwaysAssetInfo> assetInfoItems;
    private int numberOfRequestToPerform;
    private int numberOfRequestDone;
    private AniwaysAction<List<IAniwaysAssetInfo>> callback;

    protected WebAssetInfoBuilderBase(String name) {
        this.builderName = name;
    }

    @Override
    public boolean canBuild(String providerName) {
        return this.builderName.equalsIgnoreCase(providerName);
    }

    @Override
    public void buildAssets(String[] resourcesIds, AniwaysAction<List<IAniwaysAssetInfo>> callback) {
        try {
            this.callback = callback;
            if (callback == null) {
                return;
            }
            if (resourcesIds == null || resourcesIds.length == 0) {
                callback.call(null);
                return;
            }
            this.assetInfoItems = new LinkedList<IAniwaysAssetInfo>();
            this.numberOfRequestToPerform = resourcesIds.length;
            this.numberOfRequestDone = 0;
            for (String resource : resourcesIds) {
                if (resource.startsWith(AniwaysPrivateConfig.getInstance().providerSearchTermPrefix)) {
                    this.performSearchRequest(resource, false);
                    continue;
                }
                this.performSearchRequest(resource, true);
            }
        }
        catch (Throwable ex) {
            Log.e(true, this.builderName, "Caught Exception while building", ex);
        }
    }

    @Override
    public void cancelPendingRequests() {
        Volley.cancelPendingRequests(this.builderName);
    }

    private void performSearchRequest(String resource, final boolean searchedById) {
        String requestUrl;
        try {
            requestUrl = searchedById ? this.getSearchUrlByResourceId(resource) : this.getSearchUrlBySearchTerm(resource);
        }
        catch (Exception e) {
            Log.e(true, this.builderName, "Unable to construct search request url for resource:" + resource, e);
            this.signalRequestCompleted();
            return;
        }
        try {
            JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(0, requestUrl, null, new Response.Listener<JSONObject>(){

                @Override
                public void onResponse(JSONObject response) {
                    WebAssetInfoBuilderBase.this.processResponse(response, searchedById);
                }
            }, new Response.ErrorListener(){

                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e(true, WebAssetInfoBuilderBase.this.builderName, "Search failed for the following url:" + requestUrl, error);
                    WebAssetInfoBuilderBase.this.signalRequestCompleted();
                }
            });
            Volley.addToRequestQueue(jsonObjectRequest, this.builderName);
        }
        catch (Exception e) {
            Log.e(true, this.builderName, "Exception thrown while trying to search Giphy api using the following url:" + requestUrl, e);
            this.callback.call(null);
        }
    }

    private synchronized void processResponse(JSONObject response, boolean searchedById) {
        if (response != null) {
            if (searchedById) {
                IAniwaysAssetInfo item = this.parseResourceIdSearchResponse(response);
                if (item != null) {
                    this.assetInfoItems.add(item);
                }
            } else {
                List<IAniwaysAssetInfo> items = this.parseTermSearchResponse(response);
                if (items != null && items.size() > 0) {
                    this.assetInfoItems.addAll(items);
                }
            }
        }
        this.signalRequestCompleted();
    }

    private void signalRequestCompleted() {
        ++this.numberOfRequestDone;
        if (this.numberOfRequestDone == this.numberOfRequestToPerform && this.callback != null) {
            this.callback.call(this.assetInfoItems);
        }
    }

    protected abstract String getSearchUrlByResourceId(String var1);

    protected abstract String getSearchUrlBySearchTerm(String var1);

    protected abstract IAniwaysAssetInfo parseResourceIdSearchResponse(@NonNull JSONObject var1);

    protected abstract List<IAniwaysAssetInfo> parseTermSearchResponse(@NonNull JSONObject var1);
}

