/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.PhraseAssetInfoBuilderBase;
import com.aniways.service.utils.AniwaysAction;
import java.util.LinkedList;
import java.util.List;

public class PhraseAssetInfoExtractor {
    private static final int EMPTY_REQUEST_ID = -1;
    private List<IAniwaysAssetInfo> assetInfoItems;
    private boolean requestPending;
    private int currentRequestId = -1;
    private PhraseAssetInfoBuilderBase phraseAssetInfoBuilder;
    private final AssetType assetType;

    public PhraseAssetInfoExtractor(AssetType assetType) {
        this.assetType = assetType;
    }

    public void extract(Phrase phrase, final AniwaysAction<List<IAniwaysAssetInfo>> callback) {
        if (this.requestPending) {
            this.cancelPendingRequest();
        }
        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        PhraseAssetInfoBuilderBase assetInfoBuilder = phrase.getAssetInfoBuilder(this.assetType);
        Phrase referencePhrase = assetInfoBuilder.getReferencePhrase(parser, phrase);
        if (referencePhrase == null) {
            callback.call(null);
            return;
        }
        phrase = referencePhrase;
        this.resetMembers();
        Phrase finalPhrase = phrase;
        this.phraseAssetInfoBuilder = phrase.getAssetInfoBuilder(this.assetType);
        if (this.phraseAssetInfoBuilder == null || this.phraseAssetInfoBuilder.isEmpty()) {
            callback.call(null);
            return;
        }
        this.requestPending = true;
        this.currentRequestId = this.phraseAssetInfoBuilder.buildAssets(new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public void call(List<IAniwaysAssetInfo> items) {
                PhraseAssetInfoExtractor.this.requestPending = false;
                if (items != null && !items.isEmpty()) {
                    PhraseAssetInfoExtractor.this.assetInfoItems.addAll(items);
                    callback.call(PhraseAssetInfoExtractor.this.assetInfoItems);
                } else {
                    callback.call(null);
                }
            }
        }, finalPhrase);
    }

    private void resetMembers() {
        this.assetInfoItems = new LinkedList<IAniwaysAssetInfo>();
        this.requestPending = false;
        this.currentRequestId = -1;
        this.phraseAssetInfoBuilder = null;
    }

    private void cancelPendingRequest() {
        if (this.phraseAssetInfoBuilder != null && this.currentRequestId != -1) {
            this.phraseAssetInfoBuilder.cancelBuildAssetsRequest(this.currentRequestId);
        }
    }
}

