/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import com.aniways.volley.toolbox.Volley;

public class GiphyIconData
extends IconData {
    private static final String GIPHY_FAMILY = "Giphy";
    private static final String TAG = "AniwaysGiphyIconData";
    public final String idInGiphy;
    private final String stillUrl;
    private final String animationUrlLowQuality;
    private final String animationUrlHighQuality;

    public GiphyIconData(String id2, String stillUrl, String animationUrlLowQuality, String animationUrlHighQuality, Phrase primaryPhrase) {
        super(AniwaysPrivateConfig.getInstance().animatedGifImageId, GIPHY_FAMILY, false, primaryPhrase, null, AssetType.AnimatedGif, IAniwaysImageSpan.AssetProvider.Giphy, true);
        this.idInGiphy = id2;
        this.stillUrl = stillUrl;
        this.animationUrlLowQuality = animationUrlLowQuality;
        this.animationUrlHighQuality = animationUrlHighQuality;
    }

    @Override
    public String getUrl(boolean useSmallEmoji, boolean displayBig, boolean displayBanner) {
        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
        Object data = Volley.getImageLoader().getCached(this.stillUrl, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
        if (data == null) {
            data = Volley.getImageLoader().getCached(this.animationUrlLowQuality, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
            if (data == null) {
                data = Volley.getImageLoader().getCached(this.animationUrlHighQuality, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
                if (data == null) {
                    Log.d(TAG, "Returning still url since nothing is cached");
                    return this.stillUrl;
                }
                Log.d(TAG, "Returning high quality animation url");
                return this.animationUrlHighQuality;
            }
            Log.d(TAG, "Returning low quality animation url");
            return this.animationUrlLowQuality;
        }
        Log.d(TAG, "Returning still url since it is cached");
        return this.stillUrl;
    }

    @Override
    public Drawable generateDrawable(Bitmap image, Context ctx) {
        if (ctx == null) {
            Log.e(true, TAG, "context is null");
            return null;
        }
        if (image == null) {
            Log.e(true, TAG, "image is null");
            return null;
        }
        return RoundedBitmapDrawableFactory.create((Resources)ctx.getResources(), (Bitmap)image);
    }

    @Override
    public Drawable setDrawableBounds(Drawable drawable2, int maxWidth, int maxHeight) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof RoundedBitmapDrawable) {
            drawable2.setBounds(0, 0, maxWidth, maxHeight);
            ((RoundedBitmapDrawable)drawable2).setCornerRadius((float)(maxHeight / 2));
            return drawable2;
        }
        return super.setDrawableBounds(drawable2, maxWidth, maxHeight);
    }

    @Override
    public String getAssetIdFromProvider() {
        return this.idInGiphy;
    }
}

