/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.aniways.Log;
import com.aniways.data.AnimatedGifsProviders;
import com.aniways.data.AniwaysAnimatedAssetInfo;
import com.aniways.data.AniwaysClientConfig;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.GiphyIconData;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IAssetInfoBuilder;
import com.aniways.data.Phrase;
import com.aniways.data.WebAssetInfoBuilderBase;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GiphyAssetInfoBuilder
extends WebAssetInfoBuilderBase
implements IAssetInfoBuilder {
    private static final String TAG = "GiphyAssetInfoBuilder";
    private String apiKey = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_key");
    private String apiSearchTermUrlFormat = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_search_term_url_format");
    private String apiSearchByIdUrlFormat = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_search_by_id_url_format");
    private int limit;
    private int offset;
    private static final Phrase phrase = new Phrase("gif", null);
    private String rating;

    public GiphyAssetInfoBuilder() {
        super(AnimatedGifsProviders.GIPHY.getStringRepresentation());
        this.limit = AniwaysPrivateConfig.getInstance().animatedGifsRequestSize;
        this.rating = AniwaysPrivateConfig.getInstance().animatedGifsRating;
        this.offset = 0;
    }

    @Override
    protected String getSearchUrlByResourceId(String resourceId) {
        return String.format(this.apiSearchByIdUrlFormat, resourceId, this.apiKey);
    }

    @Override
    protected String getSearchUrlBySearchTerm(String resource) {
        String searchTerm = resource.split(":")[1];
        searchTerm = searchTerm.replace(' ', '+');
        String requestUrl = String.format(this.apiSearchTermUrlFormat, searchTerm, this.apiKey, this.limit, this.offset);
        if (!TextUtils.isEmpty((CharSequence)this.rating)) {
            requestUrl = requestUrl + "&rating=" + this.rating;
        }
        return requestUrl;
    }

    @Override
    protected IAniwaysAssetInfo parseResourceIdSearchResponse(@NonNull JSONObject response) {
        try {
            JSONObject itemData = response.getJSONObject("data");
            return this.parseSingleItem(itemData);
        }
        catch (JSONException e) {
            Log.e(true, TAG, "Unable to parse Giphy api response:" + response.toString(), e);
            return null;
        }
    }

    @Override
    protected List<IAniwaysAssetInfo> parseTermSearchResponse(@NonNull JSONObject response) {
        try {
            JSONArray array = response.getJSONArray("data");
            LinkedList<IAniwaysAssetInfo> retItems = new LinkedList<IAniwaysAssetInfo>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject itemData = array.getJSONObject(i);
                retItems.add(this.parseSingleItem(itemData));
            }
            return retItems;
        }
        catch (JSONException e) {
            Log.e(true, TAG, "Unable to parse Giphy api response:" + response.toString(), e);
            return null;
        }
    }

    private IAniwaysAssetInfo parseSingleItem(JSONObject itemData) throws JSONException {
        JSONObject images = itemData.getJSONObject("images");
        JSONObject highQualityObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyHighQualityImageObjectName);
        JSONObject lowQualityObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyLowQualityImageObjectName);
        JSONObject stillObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyHighQualityStillImageObjectName);
        String id2 = itemData.getString("id");
        String stillUrl = stillObj.getString("url");
        String highQualityAnimationUrl = highQualityObj.getString("url");
        String lowQualityAnimationUrl = lowQualityObj.getString("url");
        AniwaysAnimatedAssetInfo result = new AniwaysAnimatedAssetInfo(new GiphyIconData(id2, stillUrl, lowQualityAnimationUrl, highQualityAnimationUrl, phrase));
        result.setId(id2);
        result.setHighQualityAnimatedGifUrl(highQualityAnimationUrl);
        result.setLowQualityAnimatedGifUrl(lowQualityAnimationUrl);
        result.setHighHeight(highQualityObj.getInt("height"));
        result.setLowHeight(lowQualityObj.getInt("height"));
        result.setHighWidth(highQualityObj.getInt("width"));
        result.setLowWidth(lowQualityObj.getInt("width"));
        result.setStillUrl(stillUrl);
        result.setStillHeight(stillObj.getInt("height"));
        result.setStillWidth(stillObj.getInt("width"));
        result.setJson(itemData);
        return result;
    }
}

