/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.helper.KeywordsHelper;
import com.aniways.service.utils.AniwaysServiceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AniwaysStorageManager {
    public static final String NO_MEDIA = ".nomedia";
    private static final String TAG = "AniwaysStorageManager";
    private static final String CNOFIG_DIR = "/aniways/config";
    private static final String CNOFIG_FILE = "configuration";
    private static String sPackageName;
    private static Context sContext;
    private static AniwaysStorageManager sInstance;
    private static boolean sIsInit;
    private boolean mExternalStorageReadable = false;
    private boolean mExternalStorageWriteable = false;
    private boolean mUsingExternal;
    private File mKeywordsCacheDir;
    private File mKeywordsDir;
    private File mExternalRootCacheDir;
    private File mExternalRootFilesDir;
    private File mInternalRootCacheDir;
    private File mInternalRootFilesDir;
    private Context mContext;
    private boolean notAllDirsInitialized;

    static void forceInit(Context applicationContext) {
        if (AniwaysStorageManager.isInit()) {
            Log.e(true, TAG, "Calling init of AniwaysStorageManager more than once");
        }
        if ((sContext = applicationContext).getApplicationInfo() == null || AniwaysStorageManager.sContext.getApplicationInfo().packageName == null) {
            Log.e(true, TAG, "Could not resolve package name. Using app ID");
            sPackageName = AniwaysPrivateConfig.getInstance().appId;
        } else {
            sPackageName = AniwaysStorageManager.sContext.getApplicationInfo().packageName;
        }
        AniwaysStorageManager.resetStorageIfNamesFromOldVersionExist();
        AniwaysStorageManager.onUseExternalStorageConfigurationChange(sContext);
        AniwaysStorageManager.setInit();
    }

    private static boolean isInit() {
        return sIsInit;
    }

    private static void setInit() {
        sIsInit = true;
    }

    public static void onUseExternalStorageConfigurationChange(Context context) {
        AniwaysStorageManager instance = new AniwaysStorageManager(context);
        AniwaysStorageManager.setInstance(instance);
    }

    public static AniwaysStorageManager getInstance(Context context) {
        AniwaysStorageManager instance = sInstance;
        if (instance.notAllDirsInitialized) {
            instance = new AniwaysStorageManager(context);
            if (instance.notAllDirsInitialized) {
                Log.e(true, TAG, "Not all dirs initialized after creating new instance again");
            } else {
                Log.w(true, TAG, "All dirs initialized only after creating new instance again");
            }
            AniwaysStorageManager.setInstance(instance);
        }
        return instance;
    }

    public File getKeywordsDir() throws IOException {
        this.createNonMediaDirectoryIfDoesntExist(this.mKeywordsDir);
        return this.mKeywordsDir;
    }

    public File getKeywordsCacheDir() throws IOException {
        this.createNonMediaDirectoryIfDoesntExist(this.mKeywordsCacheDir);
        return this.mKeywordsCacheDir;
    }

    private AniwaysStorageManager(Context context) {
        this.mContext = context;
        this.determineUseInternalOrExternal();
        Log.i(TAG, "Is app installed on sd card:" + AniwaysStorageManager.isAppInstalledOnSdCard() + " . Use external: " + this.mUsingExternal);
        this.generateStorageDirs();
        boolean result = true;
        try {
            result = this.moveFilesToInternalOrExternalIfNecessary();
        }
        catch (IOException ex) {
            result = false;
            Log.e(true, TAG, "Moving file to or from external storage failed", ex);
        }
        if (result) {
            this.recordLocationOfNewKeywords();
        }
        if (!result) {
            AniwaysStorageManager.resetKeywordsVersions();
        }
    }

    private static void setInstance(AniwaysStorageManager instance) {
        sInstance = instance;
    }

    private static void resetKeywordsVersions() {
        KeywordsHelper keywordsHelper = KeywordsHelper.getInstance();
        keywordsHelper.setKeywordsVersion(sContext, "0.0", "");
        AniwaysServiceUtils.setLastSuccessfulUpdate(sContext, 0L);
        AniwaysStorageManager.removeAreEmoticonsStoredOnExternalStorageKey();
    }

    private boolean moveFilesToInternalOrExternalIfNecessary() throws IOException {
        boolean success = true;
        Boolean areStoredOnExternal = AniwaysStorageManager.getAreEmoticonsStoredOnExternalStorage();
        if (areStoredOnExternal == null) {
            areStoredOnExternal = false;
        }
        if (!areStoredOnExternal.booleanValue() && this.mUsingExternal) {
            if (this.getStorageDir(false, false).exists()) {
                Log.i(TAG, "Move files to external");
                this.moveRecursive(this.getStorageDir(false, false), this.getKeywordsDir(), true);
            }
        } else if (areStoredOnExternal.booleanValue() && !this.mUsingExternal && this.isExternalStorageReadable()) {
            Log.i(TAG, "Move files to internal");
            this.moveRecursive(this.getStorageDir(true, false), this.getKeywordsDir(), true);
        }
        return success;
    }

    private void determineUseInternalOrExternal() {
        if (!AniwaysPrivateConfig.getInstance().tryUsingExternalStorageForIconCaching) {
            this.mUsingExternal = false;
            return;
        }
        if (AniwaysStorageManager.isAppInstalledOnSdCard()) {
            this.mUsingExternal = true;
            return;
        }
        this.mUsingExternal = false;
    }

    private void generateStorageDirs() {
        this.generateStorageDirRoots();
        this.mKeywordsCacheDir = this.getStorageDir(this.mUsingExternal, true);
        this.mKeywordsDir = this.getStorageDir(this.mUsingExternal, false);
    }

    private void generateStorageDirRoots() {
        this.mExternalRootCacheDir = this.getExternalFilesDir(true);
        this.mInternalRootCacheDir = this.getInternalFilesDir(true);
        this.mExternalRootFilesDir = this.getExternalFilesDir(false);
        this.mInternalRootFilesDir = this.getInternalFilesDir(false);
        if (this.mUsingExternal) {
            if (this.mExternalRootCacheDir == null || this.mExternalRootFilesDir == null) {
                Log.e(true, TAG, "One of the root dirs is null. mUsingExternal:" + this.mUsingExternal + " . cache is null:" + (this.mExternalRootCacheDir == null) + " . files is null:" + (this.mExternalRootFilesDir == null));
                this.notAllDirsInitialized = true;
            } else {
                this.notAllDirsInitialized = false;
            }
        } else if (this.mInternalRootCacheDir == null || this.mInternalRootFilesDir == null) {
            Log.e(true, TAG, "One of the root dirs is null. mUsingExternal:" + this.mUsingExternal + " . cache is null:" + (this.mInternalRootCacheDir == null) + " . files is null:" + (this.mInternalRootFilesDir == null));
            this.notAllDirsInitialized = true;
        } else {
            this.notAllDirsInitialized = false;
        }
    }

    private File getStorageDir(boolean useExternal, boolean isCache) {
        File dir = this.getStorageDirRoot(useExternal, isCache);
        if (dir != null) {
            return new File(dir.getAbsolutePath() + "/aniways/keywords");
        }
        Log.e(true, TAG, "Returning null storage folder!! useExternal: " + useExternal + " isCache: " + isCache);
        this.notAllDirsInitialized = true;
        return null;
    }

    private File getStorageDirRoot(boolean isExternal, boolean isCache) {
        if (isExternal) {
            return isCache ? this.mExternalRootCacheDir : this.mExternalRootFilesDir;
        }
        return isCache ? this.mInternalRootCacheDir : this.mInternalRootFilesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyRecursive(File sourceLocation, File targetLocation) throws Throwable {
        if (!sourceLocation.exists()) {
            throw new FileNotFoundException(sourceLocation.getAbsolutePath());
        }
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                throw new IOException("Cannot create dir " + targetLocation.getAbsolutePath());
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                this.copyRecursive(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
            return;
        }
        File directory = targetLocation.getParentFile();
        if (directory != null && !directory.exists() && !directory.mkdirs()) {
            throw new IOException("Cannot create dir " + directory.getAbsolutePath());
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(sourceLocation);
            out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            out.flush();
            return;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Error copying file from " + sourceLocation + " to " + targetLocation, ex);
            throw ex;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Error closing input stream while copying file from " + sourceLocation + " to " + targetLocation, ex);
            }
            finally {
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, TAG, "Error closing output stream while copying file from " + sourceLocation + " to " + targetLocation, ex);
                }
            }
        }
    }

    private boolean deleteRecursive(File fileOrDirectory) {
        try {
            if (!fileOrDirectory.exists()) {
                Log.e(true, TAG, "Source file for delete doesnt exist: " + fileOrDirectory.getAbsolutePath());
                return false;
            }
            return this.DeleteRecursiveInternal(fileOrDirectory);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Failed deleting from: " + fileOrDirectory.getAbsolutePath());
            return false;
        }
    }

    private boolean DeleteRecursiveInternal(File fileOrDirectory) {
        boolean result2;
        boolean result = true;
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                result &= this.DeleteRecursiveInternal(child);
            }
        }
        if (!(result2 = fileOrDirectory.delete())) {
            Log.e(true, TAG, "Error deleting file or dir: " + fileOrDirectory.getAbsolutePath());
        }
        return result &= result2;
    }

    private boolean moveRecursive(File sourceLocation, File destLocation, boolean deleteSourceIfFail) {
        boolean successCopy = true;
        boolean successDelete = true;
        try {
            this.copyRecursive(sourceLocation, destLocation);
        }
        catch (Throwable ex) {
            successCopy = false;
            Log.e(true, TAG, "Failed copying from: " + sourceLocation.getAbsolutePath() + " to: " + destLocation.getAbsolutePath() + (deleteSourceIfFail ? ". Deleting source" : ""));
        }
        if ((successCopy || deleteSourceIfFail) && !(successDelete = this.deleteRecursive(sourceLocation))) {
            Log.e(true, TAG, "Failed deleting from: " + sourceLocation.getAbsolutePath() + " after " + (deleteSourceIfFail ? "failed" : "succeeded copying to: " + destLocation.getAbsolutePath()));
        }
        return successCopy & successDelete;
    }

    @SuppressLint(value={"InlinedApi", "SdCardPath"})
    private static boolean isAppInstalledOnSdCard() {
        if (Utils.isAndroidVersionAtLeast(8)) {
            PackageManager pm = sContext.getPackageManager();
            try {
                PackageInfo pi = pm.getPackageInfo(sContext.getPackageName(), 0);
                ApplicationInfo ai = pi.applicationInfo;
                return (ai.flags & 0x40000) == 262144;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        try {
            String filesDir = sContext.getFilesDir().getAbsolutePath();
            if (filesDir.startsWith("/data/")) {
                return false;
            }
            if (filesDir.contains("/mnt/") || filesDir.contains("/sdcard/") || filesDir.contains(Environment.getExternalStorageDirectory().getPath())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    private File getExternalFilesDir(boolean isCache) {
        if (Utils.isAndroidVersionAtLeast(8)) {
            return isCache ? this.mContext.getExternalCacheDir() : this.mContext.getExternalFilesDir(null);
        }
        return new File(Environment.getExternalStorageDirectory() + "/Android/data/" + sPackageName + "/files" + (isCache ? "/cache" : ""));
    }

    private File getInternalFilesDir(boolean isCache) {
        return isCache ? this.mContext.getCacheDir() : this.mContext.getFilesDir();
    }

    private void updateExternalStorageState() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            this.mExternalStorageWriteable = true;
            this.mExternalStorageReadable = true;
        } else if ("mounted_ro".equals(state)) {
            this.mExternalStorageReadable = true;
            this.mExternalStorageWriteable = false;
        } else {
            this.mExternalStorageWriteable = false;
            this.mExternalStorageReadable = false;
        }
        Log.i(TAG, "External stogare readable: " + this.mExternalStorageReadable + ". Writable: " + this.mExternalStorageWriteable);
    }

    private File createNonMediaDirectoryIfDoesntExist(File dir) throws IOException {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create directory: " + dir.getAbsolutePath());
            }
            Log.i(TAG, "Created non media directory:" + dir.getAbsolutePath());
        }
        this.addNonMediaFileToDirIfDoesntExist(dir.getAbsolutePath());
        return dir;
    }

    private void addNonMediaFileToDirIfDoesntExist(String dirName) throws IOException {
        File nomedia = new File(dirName, NO_MEDIA);
        if (!nomedia.exists()) {
            nomedia.createNewFile();
        }
    }

    private boolean isExternalStorageReadable() {
        this.updateExternalStorageState();
        return this.mExternalStorageReadable;
    }

    private static Boolean getAreEmoticonsStoredOnExternalStorage() {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (prefs.contains("com.aniways.ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE")) {
            return prefs.getBoolean("com.aniways.ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE", false);
        }
        return null;
    }

    private void setAreEmoticonsStoredOnExternalStorage(boolean areThey) {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putBoolean("com.aniways.ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE", areThey);
        edit.commit();
    }

    private static synchronized void removeAreEmoticonsStoredOnExternalStorageKey() {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.remove("com.aniways.ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE");
        edit.commit();
    }

    private static void resetStorageIfNamesFromOldVersionExist() {
        File oldAssetsDir = new File(sContext.getFilesDir() + "/assets");
        File oldKeywordsFile = new File(sContext.getFilesDir() + "/" + "keywords");
        if (oldAssetsDir.exists() || oldKeywordsFile.exists()) {
            if (oldAssetsDir.exists()) {
                AniwaysStorageManager.deleteDirectory(oldAssetsDir);
            }
            AniwaysStorageManager.resetKeywordsVersions();
        }
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    AniwaysStorageManager.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public void recordLocationOfNewKeywords() {
        this.setAreEmoticonsStoredOnExternalStorage(this.mUsingExternal);
    }

    public static String getConfigFilePath(Context context) {
        return AniwaysStorageManager.getConfigDirPath(context) + "/" + CNOFIG_FILE;
    }

    public static String getConfigDirPath(Context context) {
        return context.getFilesDir().getAbsolutePath() + CNOFIG_DIR;
    }

    public static String getConfigCacheDirPath(Context context) {
        return context.getCacheDir().getAbsolutePath() + CNOFIG_DIR;
    }

    public static String getConfigFileName() {
        return CNOFIG_FILE;
    }

    static {
        sContext = null;
    }
}

