/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import android.content.res.Resources;
import android.util.Pair;
import com.aniways.data.AniwaysStatics;

public class AniwaysClientConfig {
    private static final String TAG = "AniwaysClientConfig";
    private static final String PREFIX = "AW_Client_";
    private static AniwaysClientConfig instance;

    private AniwaysClientConfig() {
    }

    public static AniwaysClientConfig getInstance() {
        if (instance == null) {
            instance = new AniwaysClientConfig();
        }
        return instance;
    }

    public String getResourceString(String name) {
        int clientResId = this.getResourceId(PREFIX + name, "string");
        int resId = this.getResourceId(name, "string");
        Resources resources = AniwaysStatics.getApplicationContext().getResources();
        if (clientResId != 0) {
            String result = resources.getString(clientResId);
            return result;
        }
        if (resId != 0) {
            String result = resources.getString(resId);
            return result;
        }
        return "";
    }

    public int getResourceInt(String name) {
        int clientResId = this.getResourceId(PREFIX + name, "integer");
        int resId = this.getResourceId(name, "integer");
        Resources resources = AniwaysStatics.getApplicationContext().getResources();
        if (clientResId != 0) {
            int result = resources.getInteger(clientResId);
            return result;
        }
        if (resId != 0) {
            int result = resources.getInteger(resId);
            return result;
        }
        return -1;
    }

    public Pair<Boolean, Boolean> getResourceBoolean(String name) {
        int resId = this.getResourceId(name, "bool");
        int clientResId = this.getResourceId(PREFIX + name, "bool");
        Resources resources = AniwaysStatics.getApplicationContext().getResources();
        if (clientResId != 0) {
            boolean result = resources.getBoolean(clientResId);
            return new Pair((Object)true, (Object)result);
        }
        if (resId != 0) {
            boolean result = resources.getBoolean(resId);
            return new Pair((Object)true, (Object)result);
        }
        return new Pair((Object)false, (Object)false);
    }

    private int getResourceId(String name, String type) {
        Context applicationContext = AniwaysStatics.getApplicationContext();
        String packageName = applicationContext.getPackageName();
        return applicationContext.getResources().getIdentifier(name, type, packageName);
    }
}

