/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.support.annotation.NonNull;
import com.aniways.IconData;
import com.aniways.data.AnimatedGifsProviders;
import com.aniways.data.AssetInfoBuilderRequestContext;
import com.aniways.data.GiphyAssetInfoBuilder;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IAssetInfoBuilder;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.PhraseAssetInfoBuilderBase;
import com.aniways.service.utils.AniwaysAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AnimatedGifPhraseAssetInfoBuilder
extends PhraseAssetInfoBuilderBase {
    public static final AnimatedGifPhraseAssetInfoBuilder DEFAULT = new AnimatedGifPhraseAssetInfoBuilder();
    private static final List<IAssetInfoBuilder> assetInfoBuilders = new LinkedList<IAssetInfoBuilder>();
    private final HashMap<String, String[]> providerNameToResourceIdsMap;
    private final boolean searchAllProviders;

    public AnimatedGifPhraseAssetInfoBuilder(@NonNull HashMap<String, String[]> providerNameToResourceIds) {
        this.searchAllProviders = false;
        this.providerNameToResourceIdsMap = providerNameToResourceIds;
    }

    private AnimatedGifPhraseAssetInfoBuilder() {
        this.searchAllProviders = true;
        this.providerNameToResourceIdsMap = new HashMap();
        this.providerNameToResourceIdsMap.put(AnimatedGifsProviders.GIPHY.getStringRepresentation(), null);
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        return this.extractPrimaryPhrase(phrase);
    }

    @Override
    public boolean isEmpty() {
        return this.providerNameToResourceIdsMap.isEmpty();
    }

    @Override
    public int buildAssets(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        if (this.isEmpty()) {
            callback.call(null);
            return -1;
        }
        HashMap<IAssetInfoBuilder, String[]> matchedBuilders = new HashMap<IAssetInfoBuilder, String[]>();
        block0: for (Map.Entry<String, String[]> entry : this.providerNameToResourceIdsMap.entrySet()) {
            String providerName = entry.getKey();
            String[] resourceIds = this.searchAllProviders ? new String[]{"search:" + phrase.getName()} : entry.getValue();
            for (IAssetInfoBuilder candidate : assetInfoBuilders) {
                if (!candidate.canBuild(providerName)) continue;
                matchedBuilders.put(candidate, resourceIds);
                continue block0;
            }
        }
        if (matchedBuilders.isEmpty()) {
            callback.call(null);
            return -1;
        }
        AssetInfoBuilderRequestContext ctx = new AssetInfoBuilderRequestContext(matchedBuilders.keySet(), callback);
        int requestId = AnimatedGifPhraseAssetInfoBuilder.getNewRequestId();
        requests.put(requestId, ctx);
        for (Map.Entry entry : matchedBuilders.entrySet()) {
            IAssetInfoBuilder builder = (IAssetInfoBuilder)entry.getKey();
            String[] data = (String[])entry.getValue();
            builder.buildAssets(data, this.getCompletionCallback(requestId, ctx));
        }
        return requestId;
    }

    private Phrase extractPrimaryPhrase(Phrase phrase) {
        if (phrase == null) {
            return null;
        }
        if (phrase.emoticonsPhraseAssetBuilder == null || phrase.emoticonsPhraseAssetBuilder.icons.length <= 0) {
            return null;
        }
        for (IconData icon : phrase.emoticonsPhraseAssetBuilder.icons) {
            Phrase primaryPhrase = icon.primaryPhrase;
            if (primaryPhrase == null) continue;
            if (primaryPhrase.animatedGifsPhraseAssetBuilder == null) {
                primaryPhrase.animatedGifsPhraseAssetBuilder = DEFAULT;
            }
            return primaryPhrase;
        }
        return phrase;
    }

    static {
        assetInfoBuilders.add(new GiphyAssetInfoBuilder());
    }
}

