/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.contextual;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.aniways.AssetType;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.contextual.SuggestionPopupModelBuilder;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.IAniwaysPopupView;
import com.aniways.quick.action.PhraseContextualContentViewProvider;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.views.AniwaysSlidingLayer;
import com.aniways.ui.views.ContextualAssetView;
import com.aniways.ui.views.ContextualSettingsView;
import java.util.List;

public class ContextualPopupAdapter
extends PagerAdapter
implements ViewPager.OnPageChangeListener,
AniwaysAction<View> {
    private static final String TAG = "AniwaysContextualPopupAdapter";
    private final LayoutInflater inflater;
    private final ContextualAssetView[] assetViews;
    private final ViewPager pager;
    private final ContextualPopupCreationContext creationContext;
    private final float cardElevationInPixels;
    private final float cardRevealWidthInPixels;
    private final float cardRightMarginInPixels;
    private final List<PhraseContextualContentViewProvider> contextualTabs;
    private final float cardCornerRadius;
    private final int toastHeight;
    private final Toast pagingToast;
    private final ImageView pagingToastImageView;
    private final TextView pagingToastTextView;
    private int currentPageIndex = 0;
    AniwaysSlidingLayer.OnInteractListener slidingLayerInteractListener;
    private int oldPos = 0;

    public ContextualPopupAdapter(Context context, LayoutInflater inflater, ViewPager pager, ContextualPopupCreationContext creationContext) {
        this.inflater = inflater;
        this.pager = pager;
        this.creationContext = creationContext;
        this.contextualTabs = SuggestionPopupModelBuilder.getInstance().build(creationContext, context).getTabs();
        Resources res = context.getResources();
        this.cardElevationInPixels = res.getDimension(R.dimen.aniways_contextual_card_elevation);
        this.cardRevealWidthInPixels = res.getDimension(R.dimen.aniways_contextual_card_reveal_width);
        this.cardRightMarginInPixels = res.getDimension(R.dimen.aniways_contextual_card_right_margin_width);
        this.cardCornerRadius = res.getDimension(R.dimen.cardview_default_radius);
        this.toastHeight = (int)res.getDimension(R.dimen.aniways_asset_toast_height);
        View toastLayout = inflater.inflate(R.layout.aniways_asset_toast, null);
        this.pagingToast = new Toast(context);
        this.pagingToast.setView(toastLayout);
        this.pagingToastImageView = (ImageView)toastLayout.findViewById(R.id.aniways_asset_toast_icon);
        this.pagingToastTextView = (TextView)toastLayout.findViewById(R.id.aniways_asset_toast_text);
        this.assetViews = new ContextualAssetView[this.contextualTabs.size()];
        this.initSlidingLayerInteractionHandler(creationContext);
        this.initPopupContentState();
    }

    private void initPopupContentState() {
        this.creationContext.popupStateHolder.isInRevealMoreState = false;
        this.creationContext.popupStateHolder.pageIndex = 0;
        this.creationContext.popupStateHolder.totalPages = this.contextualTabs.size();
        this.creationContext.popupStateHolder.currentAssetType = this.contextualTabs.get(0).getAssetType();
        this.creationContext.popupStateHolder.nextScreen = "popup_close";
    }

    private void initSlidingLayerInteractionHandler(final ContextualPopupCreationContext creationContext) {
        this.slidingLayerInteractListener = new AniwaysSlidingLayer.OnInteractListener(){

            @Override
            public void onOpen() {
                AssetType assetType;
                ContextualPopupAdapter.this.pagingToast.cancel();
                int position = ContextualPopupAdapter.this.currentPageIndex;
                if (ContextualPopupAdapter.this.isSettingsScreenIndex(position)) {
                    assetType = AssetType.Settings;
                } else {
                    assetType = ((PhraseContextualContentViewProvider)ContextualPopupAdapter.this.contextualTabs.get(position)).getAssetType();
                    ContextualPopupAdapter.this.assetViews[position].notifyRevealMore();
                }
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Popup Reveal More-" + (Object)((Object)creationContext.selectionOrigin), assetType.toString() + "-" + position, creationContext.phrase.getPhraseSubPhraseString(), 0L);
                if (assetType != AssetType.Settings && ContextualPopupAdapter.this.hasMoreThanOnLine(ContextualPopupAdapter.this.assetViews[position].getContent())) {
                    creationContext.popupStateHolder.isInRevealMoreState = false;
                    creationContext.popupStateHolder.exitMethod = "reveal more";
                    AnalyticsReporter.reportScreenEvent(creationContext.popupStateHolder);
                    creationContext.popupStateHolder.entryMethod = "reveal more";
                    ContextualPopupAdapter.this.addPopupContentState(ContextualPopupAdapter.this.assetViews[position]);
                }
            }

            @Override
            public void onClose() {
                int position = ContextualPopupAdapter.this.currentPageIndex;
                if (position != ContextualPopupAdapter.this.contextualTabs.size()) {
                    ContextualPopupAdapter.this.assetViews[position].notifyRevealLess();
                }
                if (creationContext.popupStateHolder.entryMethod.equals("reveal more")) {
                    creationContext.popupStateHolder.isInRevealMoreState = true;
                    creationContext.popupStateHolder.exitMethod = "reveal less";
                    AnalyticsReporter.reportScreenEvent(creationContext.popupStateHolder);
                    ContextualPopupAdapter.this.addPopupContentState(ContextualPopupAdapter.this.assetViews[position]);
                    creationContext.popupStateHolder.entryMethod = "reveal less";
                }
            }

            @Override
            public void onOpened() {
            }

            @Override
            public void onClosed() {
            }
        };
    }

    private boolean hasMoreThanOnLine(IAniwaysPopupView content) {
        try {
            int columnCount = content.getColumnCount();
            int contentSize = content.getAvailableAssets().size();
            return contentSize > columnCount;
        }
        catch (Exception e) {
            Log.e(true, TAG, "Exception was thrown inside hasMoreThanOnLine method", e);
            return false;
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        if (position < this.assetViews.length) {
            int distFromBottom = this.getCount() - (position + 1);
            ContextualAssetView assetView = (ContextualAssetView)this.inflater.inflate(R.layout.aniways_contextual_card, null);
            container.addView((View)assetView);
            this.assetViews[position] = assetView;
            CardView cardView = (CardView)assetView.findViewById(R.id.aniways_contextual_card_view);
            cardView.setCardElevation((float)distFromBottom * this.cardElevationInPixels);
            int cardSidePadding = 0;
            if (!Utils.isAndroidVersionAtLeast(21)) {
                float maxCardElevation = cardView.getMaxCardElevation();
                cardSidePadding = (int)((double)maxCardElevation + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
                int cardTopBottomPadding = (int)((double)maxCardElevation * 1.5 + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
                LinearLayout.LayoutParams cardLayoutParams = (LinearLayout.LayoutParams)cardView.getLayoutParams();
                cardLayoutParams.setMargins(-cardSidePadding, -cardTopBottomPadding, 0, -cardTopBottomPadding);
            }
            View rightSpacer = assetView.findViewById(R.id.aniways_contextual_card_right_spacer);
            ViewGroup.LayoutParams spacerLayoutParams = rightSpacer.getLayoutParams();
            int spacerWidth = this.getSpacerWidth(distFromBottom);
            spacerLayoutParams.width = spacerWidth + cardSidePadding;
            rightSpacer.setLayoutParams(spacerLayoutParams);
            assetView.initContent(this.contextualTabs.get(position), this.pager.getMeasuredHeight(), position, spacerWidth, this.slidingLayerInteractListener, this);
            this.setFirstPageAsSelected();
            return assetView;
        }
        ContextualSettingsView settingsView = (ContextualSettingsView)this.inflater.inflate(R.layout.aniways_contextual_settings_card, null);
        container.addView((View)settingsView);
        settingsView.initContent(this.pager.getMeasuredHeight());
        if (!Utils.isAndroidVersionAtLeast(21)) {
            CardView cardView = (CardView)settingsView.findViewById(R.id.aniways_contextual_settings_card_view);
            float maxCardElevation = cardView.getMaxCardElevation();
            int cardSidePadding = (int)((double)maxCardElevation + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
            int cardTopBottomPadding = (int)((double)maxCardElevation * 1.5 + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
            LinearLayout.LayoutParams cardLayoutParams = (LinearLayout.LayoutParams)cardView.getLayoutParams();
            cardLayoutParams.setMargins(-cardSidePadding, -cardTopBottomPadding, 0, -cardTopBottomPadding);
        }
        return settingsView;
    }

    public void setToastOffset(int yOffset) {
        this.pagingToast.setGravity(48, 0, yOffset - this.toastHeight);
    }

    private int getSpacerWidth(int distFromBottom) {
        return (int)(this.cardRevealWidthInPixels * (float)distFromBottom - this.cardRightMarginInPixels);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        if (position < this.assetViews.length) {
            this.assetViews[position] = null;
        }
    }

    public int getCount() {
        return this.contextualTabs.size() + 1;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        AssetType oldAssetType;
        AssetType newAssetType;
        this.oldPos = this.currentPageIndex;
        this.currentPageIndex = position;
        if (this.isSettingsScreenIndex(position)) {
            newAssetType = AssetType.Settings;
        } else {
            newAssetType = this.contextualTabs.get(position).getAssetType();
            this.assetViews[position].notifySelected();
        }
        if (this.isSettingsScreenIndex(this.oldPos)) {
            oldAssetType = AssetType.Settings;
        } else {
            oldAssetType = this.contextualTabs.get(this.oldPos).getAssetType();
            this.assetViews[this.oldPos].notifyNotSelected();
        }
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Popup Scroll-" + (Object)((Object)this.creationContext.selectionOrigin), "To:" + newAssetType.toString() + "-" + position + ". From: " + oldAssetType.toString() + "-" + this.oldPos, this.creationContext.phrase.getPhraseSubPhraseString(), 0L);
        this.flushPopupScreenEvent(oldAssetType, newAssetType);
        switch (newAssetType) {
            case Emoticons: {
                this.pagingToastImageView.setImageResource(R.drawable.aniways_contextual_asset_emoticons_white);
                this.pagingToastTextView.setText(R.string.aniways_asset_type_emoticons);
                this.pagingToast.show();
                break;
            }
            case AnimatedGif: {
                this.pagingToastImageView.setImageResource(R.drawable.aniways_contextual_asset_gifs_white);
                this.pagingToastTextView.setText(R.string.aniways_asset_type_gifs);
                this.pagingToast.show();
                break;
            }
            case Settings: {
                this.pagingToast.cancel();
            }
        }
        SharedPreferences prefs = AniwaysStatics.getApplicationContext().getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED")) {
            prefs.edit().putString("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED", "1").commit();
        }
    }

    private boolean isSettingsScreenIndex(int position) {
        return position == this.contextualTabs.size();
    }

    private void flushPopupScreenEvent(AssetType oldAssetType, AssetType currentAssetType) {
        try {
            this.creationContext.popupStateHolder.nextScreen = currentAssetType.toString();
            this.creationContext.popupStateHolder.exitMethod = "swipe";
            this.creationContext.popupStateHolder.pageIndex = this.oldPos;
            this.addPopupContentState(this.assetViews[this.oldPos]);
            AnalyticsReporter.reportScreenEvent(this.creationContext.popupStateHolder);
            this.creationContext.popupStateHolder.entryMethod = "swipe";
            this.creationContext.popupStateHolder.currentAssetType = currentAssetType;
            this.creationContext.popupStateHolder.pageIndex = this.currentPageIndex;
            this.creationContext.popupStateHolder.previousScreen = oldAssetType.toString();
            if (!this.isSettingsScreenIndex(this.currentPageIndex)) {
                this.addPopupContentState(this.assetViews[this.currentPageIndex]);
            }
        }
        catch (Exception e) {
            Log.e(true, TAG, "Error was thrown while trying to report on popup event", e);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.currentPageIndex == this.assetViews.length) {
            return;
        }
        switch (state) {
            case 1: {
                this.assetViews[this.currentPageIndex].hideHint();
                break;
            }
            case 0: {
                this.assetViews[this.currentPageIndex].showHint();
            }
        }
    }

    private void setFirstPageAsSelected() {
        this.assetViews[0].notifySelected();
    }

    public void showFirstPageHintOrWink() {
        SharedPreferences prefs = AniwaysStatics.getApplicationContext().getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED")) {
            this.pager.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ContextualPopupAdapter.this.assetViews[0] != null) {
                        ContextualPopupAdapter.this.assetViews[0].wink();
                    }
                }
            }, 800L);
        } else {
            this.pager.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ContextualPopupAdapter.this.assetViews[0] != null) {
                        ContextualPopupAdapter.this.assetViews[0].showHint();
                    }
                }
            }, 800L);
        }
    }

    @Override
    public void call(View inflatedView) {
        try {
            ContextualAssetView assetView = (ContextualAssetView)inflatedView;
            if (assetView == null) {
                return;
            }
            this.addPopupContentState(assetView);
        }
        catch (Exception e) {
            Log.e(true, TAG, "Exception was thrown in onInitializationDone method", e);
        }
    }

    private void addPopupContentState(ContextualAssetView assetView) {
        List<IAniwaysAssetInfo> currentlyPresentedAssets = assetView.getContent().getCurrentlyPresentedAssets();
        int columnCount = assetView.getContent().getColumnCount();
        int contentLines = currentlyPresentedAssets.size() / columnCount;
        if (currentlyPresentedAssets.size() % columnCount != 0) {
            ++contentLines;
        }
        this.creationContext.popupStateHolder.popupAssetInfos = currentlyPresentedAssets;
        this.creationContext.popupStateHolder.contentLines = contentLines;
    }
}

