/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.Configuration;
import com.aniways.bugsnag.Error;
import com.aniways.bugsnag.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class Notification {
    private Configuration config;
    ByteArrayInputStream firstNotificationStream = null;
    ByteArrayInputStream secondNotificationStream = null;
    InputStream errorStream;

    public Notification(Configuration config) {
        this.config = config;
        JSONObject notification = new JSONObject();
        JSONUtils.safePut(notification, "apiKey", config.apiKey);
        JSONObject notifier = new JSONObject();
        JSONUtils.safePut(notifier, "name", config.notifierName);
        JSONUtils.safePut(notifier, "version", config.notifierVersion);
        JSONUtils.safePut(notifier, "url", config.notifierUrl);
        JSONUtils.safePut(notification, "notifier", notifier);
        JSONUtils.safePut(notification, "events", new JSONArray());
        String notificationString = notification.toString();
        String eventsLocator = "events\":[";
        int eventsLocation = notificationString.indexOf(eventsLocator);
        try {
            this.firstNotificationStream = new ByteArrayInputStream(notificationString.substring(0, eventsLocation + eventsLocator.length()).getBytes("UTF-8"));
            this.secondNotificationStream = new ByteArrayInputStream(notificationString.substring(eventsLocation + eventsLocator.length()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            config.logger.warn("Unable to create notification stream", e);
        }
    }

    public Notification(Configuration config, Error error) {
        this(config);
        this.setError(error);
    }

    public void setError(Error error) {
        if (error != null) {
            try {
                this.errorStream = new ByteArrayInputStream(error.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.config.logger.warn("Unable to stream error to bugsnag", e);
            }
        }
    }

    public void setError(File file) {
        if (file != null && file.exists() && file.isFile()) {
            try {
                this.errorStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                this.config.logger.warn("Bugsnag error file not found, but file exists...", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getPayload() {
        InputStream is = this.concatStreams();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        StringBuilder payload = new StringBuilder();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                payload.append(line);
            }
        }
        catch (IOException e) {
            this.config.logger.warn("Unable to create payload in bugsnag", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                this.config.logger.warn("Unable to close stream in bugsnag", e);
            }
        }
        return payload;
    }

    private InputStream concatStreams() {
        this.firstNotificationStream.reset();
        this.secondNotificationStream.reset();
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        inputStreams.add(this.firstNotificationStream);
        inputStreams.add(this.errorStream);
        inputStreams.add(this.secondNotificationStream);
        Enumeration enu = inputStreams.elements();
        return new SequenceInputStream(enu);
    }
}

