/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.service;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;

public abstract class ContinuosIntentService
extends Service {
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;
    private String mName;
    private boolean mRedelivery;

    public ContinuosIntentService(String name) {
        this.mName = name;
    }

    public void setIntentRedelivery(boolean enabled) {
        this.mRedelivery = enabled;
    }

    public void onCreate() {
        super.onCreate();
        HandlerThread thread = new HandlerThread("IntentService[" + this.mName + "]");
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void onStart(Intent intent, int startId) {
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        msg.obj = intent;
        this.mServiceHandler.sendMessage(msg);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mRedelivery ? 3 : 2;
    }

    public void onDestroy() {
        this.mServiceLooper.quit();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected abstract void onHandleIntent(Intent var1);

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            ContinuosIntentService.this.onHandleIntent((Intent)msg.obj);
        }
    }
}

