/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.service;

import android.content.Intent;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.db.IPayloadDatabaseLayer;
import com.aniways.analytics.db.PayloadDatabase;
import com.aniways.analytics.db.PayloadDatabaseThread;
import com.aniways.analytics.flush.FlushThread;
import com.aniways.analytics.flush.FlushTimer;
import com.aniways.analytics.info.InfoManager;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.models.Batch;
import com.aniways.analytics.models.Context;
import com.aniways.analytics.request.BasicRequester;
import com.aniways.analytics.service.ContinuosIntentService;
import com.aniways.analytics.stats.AnalyticsStatistics;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.service.utils.AniwaysServiceUtils;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;

public class AniwaysAnalyticsService
extends ContinuosIntentService {
    public static final String ACTION_ENQUEUE = "Enqueue";
    public static final String ACTION_ENQUEUE_ERROR = "Enqueue_Error";
    public static final String ACTION_FLUSH = "Flush";
    public static final String SERIALIZED_EVENT_KEY = "event";
    private static final String TAG = "AniwaysAnalyticsService";
    private FlushTimer mFlushTimer;
    private PayloadDatabase mDatabase;
    private PayloadDatabaseThread mDatabaseLayer;
    private FlushThread mFlushLayer;
    private AnalyticsStatistics mStatistics;
    private boolean mInitialized;
    private InfoManager mInfoManager;
    private volatile boolean mIsFlushingToAniwaysServer;
    private volatile boolean mIsFlushingErrorHandler;
    private NonThrowingRunnable mFlushClock;
    private FlushThread.BatchFactory mBatchFactory;
    private volatile long mFlushingToAniwaysServerStartTime;
    private volatile long mFlushingToErrorHandlerStartTime;

    public AniwaysAnalyticsService() {
        super(TAG);
    }

    public AniwaysAnalyticsService(String name) {
        super(name);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.setIntentRedelivery(false);
        try {
            AniwaysStatics.init(this.getApplicationContext(), (android.content.Context)this, true);
            if (this.mInitialized) {
                return;
            }
            this.mFlushClock = new NonThrowingRunnable(TAG, "flush runnable", "", true){
                private int mNumberOfEmptyDbFlushes;
                {
                    this.mNumberOfEmptyDbFlushes = 0;
                }

                @Override
                public void innerRun() {
                    this.mNumberOfEmptyDbFlushes = AniwaysAnalyticsService.this.mDatabase.getRowCount() == 0L && AniwaysAnalyticsService.this.mDatabase.getErrorsRowCount() == 0L ? ++this.mNumberOfEmptyDbFlushes : 0;
                    if (this.mNumberOfEmptyDbFlushes > AniwaysPrivateConfig.getInstance().emptyAnalyticsFlushIntervalsBeforeKillingService) {
                        Log.v(AniwaysAnalyticsService.TAG, "Stopping Analytics Service due to lack of activity");
                        AniwaysAnalyticsService.this.stopSelf();
                        return;
                    }
                    if (this.mNumberOfEmptyDbFlushes == 0) {
                        Log.i(AniwaysAnalyticsService.TAG, "Flushing in flush clock");
                        AniwaysAnalyticsService.this.flush();
                    }
                }
            };
            this.mBatchFactory = new FlushThread.BatchFactory(){

                @Override
                public Batch create(List<BasePayload> payloads) {
                    Batch batch = new Batch(payloads);
                    try {
                        batch.setContext(new Context(AniwaysAnalyticsService.this.mInfoManager.buildV3((android.content.Context)AniwaysAnalyticsService.this)));
                    }
                    catch (JSONException e) {
                        Log.eToGaOnly(true, AniwaysAnalyticsService.TAG, "Caught Exception While creating batch context", e);
                    }
                    return batch;
                }
            };
            this.mIsFlushingToAniwaysServer = false;
            this.mIsFlushingErrorHandler = false;
            this.mStatistics = new AnalyticsStatistics();
            this.mInfoManager = new InfoManager();
            this.mDatabase = PayloadDatabase.getInstance((android.content.Context)this);
            BasicRequester requester = new BasicRequester((android.content.Context)this);
            this.mDatabaseLayer = new PayloadDatabaseThread(this.mDatabase);
            this.mDatabaseLayer.start();
            this.mFlushLayer = new FlushThread(requester, this.mBatchFactory, this.mDatabaseLayer);
            this.mFlushTimer = new FlushTimer(this.mFlushClock);
            this.mInitialized = true;
            this.mFlushTimer.start();
            this.mFlushLayer.start();
        }
        catch (Throwable e) {
            Log.eToGaOnly(true, TAG, "Caught Exception While creating Analytics service", e);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            this.mFlushTimer.quit();
            this.mFlushLayer.quit();
            this.mDatabaseLayer.quit();
            this.mDatabase.close();
            this.mInitialized = false;
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception while destroying the Analytics service", ex);
        }
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        try {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equalsIgnoreCase(ACTION_ENQUEUE)) {
                String jsonText = intent.getStringExtra(SERIALIZED_EVENT_KEY);
                this.enqueue(jsonText);
            } else if (action.equalsIgnoreCase(ACTION_ENQUEUE_ERROR)) {
                String payload = intent.getStringExtra(SERIALIZED_EVENT_KEY);
                this.enqueueErrorPayload(payload);
            } else if (action.equalsIgnoreCase(ACTION_FLUSH)) {
                Log.i(TAG, "Received request to flush, so flushing..");
                this.flush();
            } else {
                Log.e(true, TAG, "Unknown Action: " + intent.getAction());
            }
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in onHandleIntent", ex);
        }
    }

    private void enqueue(String payload) {
        this.mStatistics.updateInsertAttempts(1.0);
        final long start = System.currentTimeMillis();
        this.mDatabaseLayer.enqueue(payload, new IPayloadDatabaseLayer.EnqueueCallback(){

            @Override
            public void onEnqueue(boolean success, long rowCount) {
                long duration = System.currentTimeMillis() - start;
                AniwaysAnalyticsService.this.mStatistics.updateInsertTime(duration);
                if (rowCount >= (long)AniwaysPrivateConfig.getInstance().analyticsMaxEventsBeforeFlush) {
                    Log.i(AniwaysAnalyticsService.TAG, "Flushing because row count >= max defined. Count: " + rowCount + ". Max defined: " + AniwaysPrivateConfig.getInstance().analyticsMaxEventsBeforeFlush);
                    AniwaysAnalyticsService.this.flush();
                }
            }
        });
    }

    private void enqueueErrorPayload(String payload) {
        this.mStatistics.updateInsertAttempts(1.0);
        final long start = System.currentTimeMillis();
        this.mDatabaseLayer.enqueueErrorPayload(payload, new IPayloadDatabaseLayer.EnqueueCallback(){

            @Override
            public void onEnqueue(boolean success, long rowCount) {
                long duration = System.currentTimeMillis() - start;
                AniwaysAnalyticsService.this.mStatistics.updateInsertTime(duration);
                if (rowCount >= (long)AniwaysPrivateConfig.getInstance().analyticsMaxEventsBeforeFlush) {
                    Log.i(AniwaysAnalyticsService.TAG, "Flushing to error handler because row count >= max defined. Count: " + rowCount + ". Max defined: " + AniwaysPrivateConfig.getInstance().analyticsMaxEventsBeforeFlush);
                    AniwaysAnalyticsService.this.flush();
                }
            }
        });
    }

    private synchronized void flush() {
        CountDownLatch latch;
        long start;
        if (!AniwaysServiceUtils.shouldPerformFlush((android.content.Context)this)) {
            return;
        }
        if (this.mIsFlushingToAniwaysServer && System.currentTimeMillis() - this.mFlushingToAniwaysServerStartTime < AniwaysPrivateConfig.getInstance().flushTimeout) {
            Log.v(TAG, "Not flushing to Aniways server since a previous flush is already running");
        } else {
            if (this.mIsFlushingToAniwaysServer) {
                Log.w(true, TAG, "Previous flush took too long, so starting a new one: " + (System.currentTimeMillis() - this.mFlushingToAniwaysServerStartTime));
            }
            this.mIsFlushingToAniwaysServer = true;
            this.mFlushingToAniwaysServerStartTime = System.currentTimeMillis();
            this.mStatistics.updateFlushAttempts(1.0);
            start = System.currentTimeMillis();
            latch = new CountDownLatch(1);
            this.mFlushLayer.flushAniwaysEvents(new FlushThread.FlushCallback(){

                @Override
                public void onFlushCompleted(boolean success) {
                    AniwaysAnalyticsService.this.mIsFlushingToAniwaysServer = false;
                    latch.countDown();
                    if (success) {
                        long currentTimeMillis = System.currentTimeMillis();
                        AniwaysServiceUtils.setLastSuccessAnalyticsFlush((android.content.Context)AniwaysAnalyticsService.this, currentTimeMillis);
                        long duration = currentTimeMillis - start;
                        AniwaysAnalyticsService.this.mStatistics.updateFlushTime(duration);
                        if (AniwaysAnalyticsService.this.mDatabase.getRowCount() == 0L && AniwaysAnalyticsService.this.mDatabase.getErrorsRowCount() == 0L && !AniwaysAnalyticsService.this.mIsFlushingErrorHandler && AniwaysPrivateConfig.getInstance().emptyAnalyticsFlushIntervalsBeforeKillingService == 0) {
                            Log.v(AniwaysAnalyticsService.TAG, "Stopping Analytics Service after successful analytics flush");
                            AniwaysAnalyticsService.this.stopSelf();
                        }
                    }
                }
            });
        }
        if (this.mIsFlushingErrorHandler && System.currentTimeMillis() - this.mFlushingToErrorHandlerStartTime < AniwaysPrivateConfig.getInstance().flushTimeout) {
            Log.v(TAG, "Not flushing to error handler since a previous flush is already running");
        } else {
            if (this.mIsFlushingErrorHandler) {
                Log.w(true, TAG, "Previous flush to error handler took too long, so starting a new one: " + (System.currentTimeMillis() - this.mFlushingToErrorHandlerStartTime));
            }
            this.mIsFlushingErrorHandler = true;
            this.mFlushingToErrorHandlerStartTime = System.currentTimeMillis();
            this.mStatistics.updateFlushAttempts(1.0);
            start = System.currentTimeMillis();
            latch = new CountDownLatch(1);
            this.mFlushLayer.flushErrorEvents(new FlushThread.FlushCallback(){

                @Override
                public void onFlushCompleted(boolean success) {
                    AniwaysAnalyticsService.this.mIsFlushingErrorHandler = false;
                    latch.countDown();
                    if (success) {
                        long duration = System.currentTimeMillis() - start;
                        AniwaysAnalyticsService.this.mStatistics.updateFlushTime(duration);
                        if (AniwaysAnalyticsService.this.mDatabase.getRowCount() == 0L && AniwaysAnalyticsService.this.mDatabase.getErrorsRowCount() == 0L && !AniwaysAnalyticsService.this.mIsFlushingToAniwaysServer && AniwaysPrivateConfig.getInstance().emptyAnalyticsFlushIntervalsBeforeKillingService == 0) {
                            Log.v(AniwaysAnalyticsService.TAG, "Stopping Analytics Service after successful error handler flush");
                            AniwaysAnalyticsService.this.stopSelf();
                        }
                    }
                }
            });
        }
    }
}

