/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.request.azure;

import com.aniways.analytics.request.azure.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class StorageKey {
    private Mac hmacSha256;
    private SecretKey key256;
    private byte[] key;

    static synchronized String computeMacSha256(StorageKey storageKey, String stringToSign) throws InvalidKeyException {
        if (storageKey.hmacSha256 == null) {
            storageKey.initHmacSha256();
        }
        byte[] utf8Bytes = null;
        try {
            utf8Bytes = stringToSign.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.encode(storageKey.hmacSha256.doFinal(utf8Bytes));
    }

    StorageKey(byte[] key) {
        this.key = key;
        this.hmacSha256 = null;
        this.key256 = null;
    }

    private void initHmacSha256() throws InvalidKeyException {
        this.key256 = new SecretKeySpec(this.key, "HmacSHA256");
        try {
            this.hmacSha256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException();
        }
        this.hmacSha256.init(this.key256);
    }
}

