/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.request;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.info.Build;
import com.aniways.analytics.request.azure.AzureRequest;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Installation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class BasicRequester {
    private static final String TAG = "AniwaysAnalyticsBasicRequester";
    private Context mContext;

    public BasicRequester(Context context) {
        this.mContext = context;
    }

    public boolean sendToErrorHandler(String content) {
        HttpResponse response = null;
        String url = AniwaysPrivateConfig.getInstance().errorHandlingEndpoint;
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            ConnManagerParams.setTimeout((HttpParams)httpClient.getParams(), (long)15000L);
            HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)15000);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)15000);
            HttpClientParams.setRedirecting((HttpParams)httpClient.getParams(), (boolean)true);
            System.setProperty("http.keepAlive", "false");
            HttpPost post = new HttpPost(url);
            Header[] se = new ByteArrayEntity(content.getBytes("UTF-8"));
            post.setHeader("Content-Type", "application/json; charset=utf-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=utf-8"));
            post.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)post);
        }
        catch (MalformedURLException e) {
            Log.eToGaOnly(true, TAG, "Malformed URL: " + url, e);
        }
        catch (ProtocolException e) {
            Log.eToGaOnly(true, TAG, "Protocol Exception for url: " + url, e);
        }
        catch (IOException e) {
            String networkInterface = Utils.isInternetAvailable(this.mContext);
            if (networkInterface != null) {
                Log.wToGaOnly(true, TAG, "IO Exception on URL " + url + " Network interface: " + networkInterface, e);
            } else {
                Log.wToGaOnly(false, TAG, "IO Exception, but there is no internet connection, so that's expected. URL: " + url + " Retry number: ", e);
            }
        }
        catch (IllegalArgumentException e) {
            Log.eToGaOnly(true, TAG, "Illegal arg Exception on URL: " + url, e);
        }
        catch (Throwable e) {
            Log.wToGaOnly(true, TAG, "Failed to send request on URL: " + url, e);
        }
        if (response == null) {
            Log.wToGaOnly(false, TAG, "Failed to make request to the server. Url: " + url, null);
            return false;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            String responseString = "";
            try {
                responseString = responseString + response.getStatusLine().getReasonPhrase() + "\n";
                Header[] headers = response.getAllHeaders();
                if (headers != null) {
                    for (Header header : headers) {
                        responseString = responseString + header.getName();
                        responseString = responseString + " : ";
                        responseString = responseString + header.getValue() + "\n";
                    }
                }
                responseString = responseString + EntityUtils.toString((HttpEntity)response.getEntity());
                Log.eToGaOnly(true, TAG, "Received a failed response from the server. Url: " + url + ".Response code: " + response.getStatusLine().getStatusCode() + ". Response: " + responseString, null);
            }
            catch (ParseException e) {
                Log.wToGaOnly(true, TAG, "Failed to parse the response from the server. Url: " + url + ". Response: " + responseString, e);
            }
            catch (IOException e) {
                String networkInterface = Utils.isInternetAvailable(this.mContext);
                if (networkInterface != null) {
                    Log.wToGaOnly(true, TAG, "Failed to read the response from the server. Url: " + url + ". Response: " + responseString, e);
                }
                Log.wToGaOnly(false, TAG, "Failed to read the response from the server, but there is no internet connection, so that's expected. URL: " + url + " Retry number: ", e);
            }
            return response.getStatusLine().getStatusCode() == 413;
        }
        return true;
    }

    public boolean sendAnalytics(String json, AniwaysPrivateConfig.AnalyticsCloud provider) {
        return this.sendAnalytics(json, provider, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"TrulyRandom"})
    private boolean sendAnalytics(String json, AniwaysPrivateConfig.AnalyticsCloud provider, String date) {
        String url = null;
        if (provider == AniwaysPrivateConfig.AnalyticsCloud.Amazon) {
            url = AniwaysPrivateConfig.getInstance().analyticsS3Address;
        } else if (provider == AniwaysPrivateConfig.AnalyticsCloud.Azure) {
            url = AniwaysPrivateConfig.getInstance().azureAnalyticsEndpint;
        } else if (provider == AniwaysPrivateConfig.AnalyticsCloud.Aniways) {
            url = AniwaysPrivateConfig.getInstance().baseAnalyticsUrl;
        } else {
            Log.e(true, TAG, "Bad analytics provider: " + (Object)((Object)provider));
            return false;
        }
        HttpURLConnection connection = null;
        try {
            byte[] byteArrayToSend = null;
            boolean isCompressed = false;
            if (AniwaysPrivateConfig.getInstance().compressAnalytics) {
                try {
                    byteArrayToSend = this.compress(json);
                    isCompressed = true;
                }
                catch (IOException e) {
                    Log.e(true, TAG, "Could not compress json: " + json, e);
                }
            }
            if (byteArrayToSend == null) {
                byteArrayToSend = json.getBytes("UTF-8");
                isCompressed = false;
            }
            X509TrustManager trustAllCerts = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new X509TrustManager[]{trustAllCerts}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.US);
            dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String dateTimeString = dateTimeFormat.format(Calendar.getInstance().getTime());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String dateString = dateFormat.format(Calendar.getInstance().getTime());
            SimpleDateFormat hourFormat = new SimpleDateFormat("HH", Locale.US);
            hourFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String hourString = hourFormat.format(Calendar.getInstance().getTime());
            String appName = Build.getAppName(this.mContext);
            if (appName == null) {
                appName = AniwaysPrivateConfig.getInstance().appId;
            }
            Random r = new Random();
            int partitionNumber = r.nextInt(AniwaysPrivateConfig.getInstance().numberOfAnalyticsPartitions);
            String partitionNumberString = Integer.toString(partitionNumber);
            int numberOfZerosToAdd = AniwaysPrivateConfig.getInstance().analyticsPartitionsStringLength - partitionNumberString.length();
            for (int i = 0; i < numberOfZerosToAdd; ++i) {
                partitionNumberString = '0' + partitionNumberString;
            }
            String fileName = "v2/android/" + appName.replace(" ", "_") + "/" + dateString + "/" + hourString + "/" + partitionNumberString + "/" + dateTimeString + "." + Installation.id(this.mContext).replace("-", "") + ".json";
            if (isCompressed) {
                fileName = fileName + ".gz";
            }
            URL urlConnectionOpener = new URL(url + "/" + fileName);
            connection = (HttpURLConnection)urlConnectionOpener.openConnection();
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(15000);
            HttpURLConnection.setFollowRedirects(true);
            if (Utils.isAndroidVersionAtLeast(8)) {
                connection.setRequestProperty("Connection", "Keep-Alive");
            } else {
                System.setProperty("http.keepAlive", "false");
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            if (provider == AniwaysPrivateConfig.AnalyticsCloud.Aniways) {
                connection.setRequestMethod("POST");
            } else {
                connection.setRequestMethod("PUT");
            }
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            if (isCompressed) {
                connection.setRequestProperty("Content-Encoding", "gzip");
            }
            connection.setRequestProperty("Content-Length", Integer.toString(byteArrayToSend.length));
            if (provider == AniwaysPrivateConfig.AnalyticsCloud.Amazon) {
                connection.setRequestProperty("x-amz-storage-class", AniwaysPrivateConfig.getInstance().s3StorageClass);
                connection.setRequestProperty("x-amz-acl", AniwaysPrivateConfig.getInstance().s3Acl);
            } else if (provider == AniwaysPrivateConfig.AnalyticsCloud.Azure) {
                AzureRequest.addAzureHeaders(connection, byteArrayToSend.length, date);
            } else if (provider != AniwaysPrivateConfig.AnalyticsCloud.Aniways) {
                Log.e(true, TAG, "Bad analytics provider2: " + (Object)((Object)provider));
                return false;
            }
            int maxBufferSize = 0x100000;
            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(byteArrayToSend);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (MalformedURLException e) {
            Log.eToGaOnly(true, TAG, "Malformed analytics URL: " + url, e);
        }
        catch (ProtocolException e) {
            Log.eToGaOnly(true, TAG, "Protocol Exception for analytics url: " + url, e);
        }
        catch (IOException e) {
            String networkInterface = Utils.isInternetAvailable(this.mContext);
            if (networkInterface != null) {
                Log.wToGaOnly(true, TAG, "IO Exception on analytics URL " + url + " Network interface: " + networkInterface, e);
            } else {
                Log.wToGaOnly(false, TAG, "IO Exception in analytics, but there is no internet connection, so that's expected. URL: " + url + " Retry number: ", e);
            }
        }
        catch (IllegalArgumentException e) {
            Log.eToGaOnly(true, TAG, "Illegal arg Exception on analytics URL: " + url, e);
        }
        catch (Throwable e) {
            Log.wToGaOnly(true, TAG, "Failed to send request on analytics URL: " + url, e);
        }
        String responseString = "";
        try {
            if (connection == null) {
                Log.wToGaOnly(false, TAG, "Failed to make request to the analytics server. Url: " + url, null);
                boolean networkInterface = false;
                return networkInterface;
            }
            if (connection.getResponseCode() != 200 && connection.getResponseCode() != 201 && connection.getResponseCode() != 204) {
                InputStream errorStream;
                InputStream responseStream;
                String dateFromServer;
                if (connection.getResponseCode() == 403 && provider == AniwaysPrivateConfig.AnalyticsCloud.Azure && date == null && !TextUtils.isEmpty((CharSequence)(dateFromServer = connection.getHeaderField("Date")))) {
                    dateFromServer.replace("[", "");
                    dateFromServer.replace("]", "");
                    Log.w(false, TAG, "Couldnt send file to Azure. Trying to send again with server time: " + dateFromServer);
                    boolean trustAllCerts = this.sendAnalytics(json, provider, dateFromServer);
                    return trustAllCerts;
                }
                responseString = responseString + connection.getResponseMessage() + "\n";
                if (connection.getHeaderFields() != null && connection.getHeaderFields().entrySet() != null) {
                    StringBuilder responseHeadersSb = new StringBuilder();
                    for (Map.Entry entry : connection.getHeaderFields().entrySet()) {
                        responseHeadersSb.append("\n" + (String)entry.getKey() + ":" + entry.getValue());
                    }
                    responseString = responseString + responseHeadersSb.toString();
                }
                if ((responseStream = connection.getInputStream()) != null) {
                    responseString = responseString + "\n" + this.convertStreamToString(responseStream);
                    responseStream.close();
                }
                if ((errorStream = connection.getErrorStream()) != null) {
                    responseString = responseString + "\n" + this.convertStreamToString(errorStream);
                    errorStream.close();
                }
                Log.eToGaOnly(true, TAG, "Received a failed response from the analytics server. Url: " + url + "Response code: " + connection.getResponseCode() + ". Response: " + responseString, null);
                boolean bl = false;
                return bl;
            }
            boolean responseStream = true;
            return responseStream;
        }
        catch (ParseException e) {
            Log.wToGaOnly(true, TAG, "Failed to parse the response from the analytics server. Url: " + url + ". Response: " + responseString, e);
        }
        catch (IOException e) {
            String networkInterface = Utils.isInternetAvailable(this.mContext);
            if (networkInterface != null) {
                Log.wToGaOnly(true, TAG, "Failed to read the response from the analytics server. Url: " + url + ". Response: " + responseString, e);
            } else {
                Log.wToGaOnly(false, TAG, "Failed to read the response from the analytics server, but there is no internet connection, so that's expected. URL: " + url + " Retry number: ", e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private byte[] compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return compressed;
    }

    public class NullHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            Log.i("RestUtilImpl", "Approving certificate for " + hostname);
            return true;
        }
    }
}

