/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.LocationManager;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.info.Info;
import com.aniways.analytics.models.EasyJSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public class Location
implements Info<JSONObject> {
    private static final String TAG = "AniwaysAnalyticsContextLocation";
    private static final String LAST_LOCATION_KEY_PREFIX = "com.aniways.LAST_LOCATION_";
    public static final String UNKNOWN = "unknown";
    public static final String COUNTRY_CODE = "countryCode";
    public static final String COUNTRY_NAME = "country";
    public static final String STATE = "state";
    public static final String COUNTY = "county";
    public static final String CITY = "city";
    public static final String NEIGHBORHOOD = "neighborhood";
    public static final String LANDMARK = "landmark";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String SPEED = "speed";

    @Override
    public String getKey() {
        return "location";
    }

    @Override
    public EasyJSONObject get(Context context) {
        EasyJSONObject object;
        try {
            boolean extraPropertiesTaken;
            boolean coordinatesTaken;
            String state;
            String landmark;
            String county;
            String neighborhood;
            String city;
            String countryCode;
            String countryName;
            String speed;
            String latitude;
            String longitude;
            block11: {
                object = new EasyJSONObject();
                longitude = null;
                latitude = null;
                speed = null;
                countryName = null;
                countryCode = null;
                city = null;
                neighborhood = null;
                county = null;
                landmark = null;
                state = null;
                coordinatesTaken = false;
                extraPropertiesTaken = false;
                try {
                    android.location.Location location;
                    LocationManager locationManager = (LocationManager)context.getSystemService("location");
                    Criteria crit = new Criteria();
                    crit.setPowerRequirement(1);
                    crit.setAccuracy(2);
                    String provider = locationManager.getBestProvider(crit, true);
                    if (provider == null || (location = locationManager.getLastKnownLocation(provider)) == null) break block11;
                    latitude = Double.toString(location.getLatitude());
                    longitude = Double.toString(location.getLongitude());
                    speed = Float.toString(location.getSpeed());
                    coordinatesTaken = true;
                    try {
                        Geocoder geocoder = new Geocoder(context.getApplicationContext(), Locale.US);
                        List listAddresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
                        if (null != listAddresses && listAddresses.size() > 0) {
                            countryCode = ((Address)listAddresses.get(0)).getCountryCode();
                            countryName = ((Address)listAddresses.get(0)).getCountryName();
                            state = ((Address)listAddresses.get(0)).getAdminArea();
                            county = ((Address)listAddresses.get(0)).getSubAdminArea();
                            city = ((Address)listAddresses.get(0)).getLocality();
                            neighborhood = ((Address)listAddresses.get(0)).getSubLocality();
                            landmark = ((Address)listAddresses.get(0)).getFeatureName();
                            extraPropertiesTaken = true;
                        }
                    }
                    catch (IOException e) {
                        Log.w(false, TAG, "Caught Exception in get location", e);
                    }
                }
                catch (Exception ex) {
                    Log.eToGaOnly(true, TAG, "Caught Exception in Location info", ex);
                }
            }
            if (!coordinatesTaken) {
                latitude = Location.getProperty(context, LATITUDE);
                longitude = Location.getProperty(context, LONGITUDE);
                speed = Location.getProperty(context, SPEED);
            }
            if (!extraPropertiesTaken) {
                countryCode = Location.getProperty(context, COUNTRY_CODE);
                countryName = Location.getProperty(context, COUNTRY_NAME);
                state = Location.getProperty(context, STATE);
                county = Location.getProperty(context, COUNTY);
                city = Location.getProperty(context, CITY);
                neighborhood = Location.getProperty(context, NEIGHBORHOOD);
                landmark = Location.getProperty(context, LANDMARK);
            }
            object.put(LATITUDE, latitude == null ? UNKNOWN : latitude);
            object.put(LONGITUDE, longitude == null ? UNKNOWN : longitude);
            object.put(SPEED, speed == null ? UNKNOWN : speed);
            object.put(COUNTRY_CODE, countryCode == null ? UNKNOWN : countryCode);
            object.put(COUNTRY_NAME, countryName == null ? UNKNOWN : countryName);
            object.put(STATE, state == null ? UNKNOWN : state);
            object.put(COUNTY, county == null ? UNKNOWN : county);
            object.put(CITY, city == null ? UNKNOWN : city);
            object.put(NEIGHBORHOOD, neighborhood == null ? UNKNOWN : neighborhood);
            object.put(LANDMARK, landmark == null ? UNKNOWN : landmark);
            if (coordinatesTaken) {
                Location.setProperty(context, LATITUDE, latitude == null ? UNKNOWN : latitude);
                Location.setProperty(context, LONGITUDE, longitude == null ? UNKNOWN : longitude);
                Location.setProperty(context, SPEED, speed == null ? UNKNOWN : speed);
            }
            if (extraPropertiesTaken) {
                Location.setProperty(context, COUNTRY_CODE, countryCode == null ? UNKNOWN : countryCode);
                Location.setProperty(context, COUNTRY_NAME, countryName == null ? UNKNOWN : countryName);
                Location.setProperty(context, STATE, state == null ? UNKNOWN : state);
                Location.setProperty(context, COUNTY, county == null ? UNKNOWN : county);
                Location.setProperty(context, CITY, city == null ? UNKNOWN : city);
                Location.setProperty(context, NEIGHBORHOOD, neighborhood == null ? UNKNOWN : neighborhood);
                Location.setProperty(context, LANDMARK, landmark == null ? UNKNOWN : landmark);
            }
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception while processing location data", e);
            object = null;
        }
        return object;
    }

    private static synchronized void setProperty(Context context, String name, String value) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString(LAST_LOCATION_KEY_PREFIX + name, value);
        edit.commit();
    }

    private static synchronized String getProperty(Context context, String name) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString(LAST_LOCATION_KEY_PREFIX + name, UNKNOWN);
    }
}

