/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.db;

import android.util.Pair;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.db.IPayloadDatabaseLayer;
import com.aniways.analytics.db.PayloadDatabase;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.LinkedList;
import java.util.List;

public class PayloadDatabaseThread
extends LooperThreadWithHandler {
    private static final String TAG = "AniwaysPayloadDatabaseThread";
    private PayloadDatabase database;

    public PayloadDatabaseThread(PayloadDatabase database) {
        super(TAG);
        this.database = database;
    }

    public void enqueue(final String payload, final IPayloadDatabaseLayer.EnqueueCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "enqueue", "", true){

            @Override
            public void innerRun() {
                boolean success = PayloadDatabaseThread.this.database.addPayload(payload);
                long rowCount = PayloadDatabaseThread.this.database.getRowCount();
                if (callback != null) {
                    callback.onEnqueue(success, rowCount);
                }
            }
        });
    }

    public void enqueueErrorPayload(final String payload, final IPayloadDatabaseLayer.EnqueueCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "enqueueError", "", true){

            @Override
            public void innerRun() {
                boolean success = PayloadDatabaseThread.this.database.addErrorPayload(payload);
                long rowCount = PayloadDatabaseThread.this.database.getErrorsRowCount();
                if (callback != null) {
                    callback.onEnqueue(success, rowCount);
                }
            }
        });
    }

    public void nextPayload(final IPayloadDatabaseLayer.PayloadCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "nextPayload", "", true){

            @Override
            public void innerRun() {
                List<Pair<Long, BasePayload>> pairs = PayloadDatabaseThread.this.database.getEvents(AniwaysPrivateConfig.getInstance().analyticsMaxFlushSize);
                long minId = 0L;
                long maxId = 0L;
                LinkedList<BasePayload> payloads = new LinkedList<BasePayload>();
                if (pairs.size() > 0) {
                    minId = (Long)pairs.get((int)0).first;
                    maxId = (Long)pairs.get((int)(pairs.size() - 1)).first;
                    for (Pair<Long, BasePayload> pair : pairs) {
                        payloads.add((BasePayload)((Object)pair.second));
                    }
                }
                if (callback != null) {
                    callback.onPayload(minId, maxId, payloads);
                }
            }
        });
    }

    public void nextErrorPayload(final IPayloadDatabaseLayer.ErrorPayloadCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "nextErrorPayload", "", true){

            @Override
            public void innerRun() {
                List<Pair<Long, String>> pairs = PayloadDatabaseThread.this.database.getErrorEvents(1);
                long minId = 0L;
                long maxId = 0L;
                LinkedList<Object> payloads = new LinkedList<Object>();
                if (pairs.size() > 0) {
                    minId = (Long)pairs.get((int)0).first;
                    maxId = (Long)pairs.get((int)(pairs.size() - 1)).first;
                    for (Pair<Long, String> pair : pairs) {
                        payloads.add(pair.second);
                    }
                }
                if (callback != null) {
                    callback.onPayload(minId, maxId, payloads == null || payloads.size() == 0 ? null : (String)payloads.get(0));
                }
            }
        });
    }

    public void removePayloads(final long minId, final long maxId, final IPayloadDatabaseLayer.RemoveCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "removePayloads", "", true){

            @Override
            public void innerRun() {
                int removed = PayloadDatabaseThread.this.database.removeEvents(minId, maxId);
                if (callback != null) {
                    callback.onRemoved(removed);
                }
            }
        });
    }

    public void removeErrorPayloads(final long minId, final long maxId, final IPayloadDatabaseLayer.RemoveCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "removeErrorPayloads", "", true){

            @Override
            public void innerRun() {
                int removed = PayloadDatabaseThread.this.database.removeErrorEvents(minId, maxId);
                if (callback != null) {
                    callback.onRemoved(removed);
                }
            }
        });
    }
}

